/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.consent.service;

import io.jans.casa.core.model.Client;
import io.jans.casa.core.model.Scope;
import io.jans.casa.misc.Utils;
import io.jans.casa.plugins.consent.model.ClientAuthorization;
import io.jans.casa.plugins.consent.model.Token;
import io.jans.casa.service.IPersistenceService;
import io.jans.orm.search.filter.Filter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthorizationsService {
    private static final String TOKENS_DN = "ou=tokens,o=jans";
    private static final String AUTHORIZATIONS_DN = "ou=authorizations,o=jans";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);

    public Map<Client, Set<Scope>> getUserClientPermissions(String userId) {
        ClientAuthorization caSample = new ClientAuthorization();
        caSample.setBaseDn(AUTHORIZATIONS_DN);
        caSample.setUserId(userId);
        List authorizations = this.persistenceService.find((Object)caSample);
        int caEntries = authorizations.size();
        this.logger.debug("{} client-authorization entries found", (Object)caEntries);
        if (caEntries == 0) {
            return Collections.emptyMap();
        }
        Set clientIds = authorizations.stream().map(ClientAuthorization::getJansClntId).collect(Collectors.toSet());
        Filter[] filters = clientIds.stream().map(id -> Filter.createEqualityFilter((String)"inum", (Object)id)).collect(Collectors.toList()).toArray(new Filter[0]);
        List clients = this.persistenceService.find(Client.class, this.persistenceService.getClientsDn(), Filter.createORFilter((Filter[])filters));
        Set scopeIds = authorizations.stream().map(ClientAuthorization::getScopes).flatMap(Collection::stream).collect(Collectors.toSet());
        filters = scopeIds.stream().map(id -> Filter.createEqualityFilter((String)"jansId", (Object)id)).collect(Collectors.toList()).toArray(new Filter[0]);
        List scopes = this.persistenceService.find(Scope.class, this.persistenceService.getScopesDn(), Filter.createORFilter((Filter[])filters));
        this.logger.info("Found {} client authorizations for user {}", (Object)clients.size(), (Object)userId);
        HashMap<Client, Set<Scope>> perms = new HashMap<Client, Set<Scope>>();
        for (Client client : clients) {
            HashSet clientScopes = new HashSet();
            for (ClientAuthorization auth : authorizations) {
                if (!auth.getJansClntId().equals(client.getInum())) continue;
                for (String scopeName : auth.getScopes()) {
                    scopes.stream().filter(sc -> sc.getId().equals(scopeName)).findAny().ifPresent(clientScopes::add);
                }
            }
            perms.put(client, clientScopes);
        }
        return perms;
    }

    public void removeClientAuthorizations(String userId, String userName, String clientId) {
        ClientAuthorization caSample = new ClientAuthorization();
        caSample.setJansClntId(clientId);
        caSample.setBaseDn(AUTHORIZATIONS_DN);
        caSample.setUserId(userId);
        this.logger.info("Removing client authorizations for user {}", (Object)userName);
        this.persistenceService.find((Object)caSample).forEach(arg_0 -> ((IPersistenceService)this.persistenceService).delete(arg_0));
        Token sampleToken = new Token();
        sampleToken.setBaseDn(TOKENS_DN);
        sampleToken.setClientId(clientId);
        sampleToken.setTokenType("refresh_token");
        sampleToken.setUserId(userName);
        this.logger.info("Removing refresh tokens associated to this user/client pair");
        this.persistenceService.find((Object)sampleToken).forEach(token -> {
            this.logger.debug("Deleting token {}", (Object)token.getTokenCode());
            this.persistenceService.delete((Object)token);
        });
    }
}

