/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.bioid.vm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.GeneralException;
import io.jans.casa.conf.OIDCClientSettings;
import io.jans.casa.core.pojo.User;
import io.jans.casa.misc.Utils;
import io.jans.casa.misc.WebUtils;
import io.jans.casa.plugins.bioid.BioIdService;
import io.jans.casa.service.IPersistenceService;
import io.jans.casa.service.ISessionContext;
import io.jans.inbound.oauth2.CodeGrantUtil;
import io.jans.inbound.oauth2.OAuthParams;
import io.jans.util.Pair;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.QueryParam;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Sessions;

public class RedirectViewModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ISessionContext sessionContext;
    private String text;
    private String title;
    private String serverUrl;
    private BioIdService bis = BioIdService.getInstance();
    private User user;
    private ObjectMapper mapper;

    public RedirectViewModel() {
        this.serverUrl = ((IPersistenceService)Utils.managedBean(IPersistenceService.class)).getIssuerUrl();
        this.sessionContext = (ISessionContext)Utils.managedBean(ISessionContext.class);
        this.user = this.sessionContext.getLoggedUser();
        this.mapper = new ObjectMapper();
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    @Init
    public void init(@QueryParam(value="start") String start) {
        try {
            String bioIdCode = this.storeBioIdCode();
            String currentUrl = WebUtils.getServletRequest().getRequestURL().toString();
            this.title = Labels.getLabel((String)"general.error.general");
            CodeGrantUtil cgu = new CodeGrantUtil(this.makeOAuthParams(this.bis.getCasaClient(), bioIdCode, currentUrl));
            if (Utils.isNotEmpty((String)start)) {
                String agamaUrl = this.getAuthzRequestRedirectUrl(cgu);
                WebUtils.execRedirect((String)agamaUrl, (boolean)false);
            } else {
                String state = Optional.ofNullable(Sessions.getCurrent().getAttribute("st")).map(Object::toString).orElse(null);
                if (state == null) {
                    return;
                }
                Map params = WebUtils.getServletRequest().getParameterMap();
                for (Map.Entry entry : params.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = Arrays.toString((Object[])entry.getValue());
                    this.logger.info("Key: " + key + ", value: " + value);
                }
                String incomingState = ((String[])params.get("state"))[0];
                if (!incomingState.equals(state)) {
                    throw new GeneralException("State mismatch");
                }
                this.title = Labels.getLabel((String)"bioid_success");
                this.text = Labels.getLabel((String)"bioid_close");
            }
        }
        catch (Exception e) {
            this.text = e.getMessage();
            this.logger.error(this.text, (Throwable)e);
        }
    }

    private String storeBioIdCode() {
        byte size = 25;
        String code = this.bis.generateBioIdCode(size);
        HashMap<String, Object> bioIdDict = new HashMap<String, Object>();
        bioIdDict.put("code", code);
        bioIdDict.put("expiration", new Date().getTime() + 60000L);
        this.bis.setBioIdCode(this.user.getId(), bioIdDict);
        this.logger.debug("BioID code stored successfully");
        return code;
    }

    private OAuthParams makeOAuthParams(OIDCClientSettings cl, String bioIdCode, String redirectUri) {
        OAuthParams p = new OAuthParams();
        p.setAuthzEndpoint(this.serverUrl + "/jans-auth/restv1/authorize");
        p.setTokenEndpoint(this.serverUrl + "/jans-auth/restv1/token");
        p.setClientId(cl.getClientId());
        p.setClientSecret(cl.getClientSecret());
        p.setScopes(Collections.singletonList("openid"));
        p.setRedirectUri(redirectUri);
        HashMap<String, String> custMap = new HashMap<String, String>();
        custMap.put("acr_values", this.makeAgamaFlowParam(bioIdCode));
        custMap.put("prompt", "login");
        p.setCustParamsAuthReq(custMap);
        return p;
    }

    private String getAuthzRequestRedirectUrl(CodeGrantUtil cgu) throws URISyntaxException {
        this.logger.info("Building an agama authentication request");
        Pair pair = cgu.makeAuthzRequest();
        Sessions.getCurrent().setAttribute("st", pair.getSecond());
        return (String)pair.getFirst();
    }

    private String makeAgamaFlowParam(String bioIdCode) {
        String temp = null;
        try {
            temp = this.mapper.writeValueAsString(Map.of("bioid_enrollment_code", bioIdCode, "login_hint", this.user.getUserName()));
            temp = new String(Base64.getUrlEncoder().encode(temp.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return "agama_io.jans.agama.bioid.enroll-" + temp;
    }
}

