/*
 * Decompiled with CFR 0.152.
 */
package io.jans.inbound;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.client.ClientRegistrationErrorResponse;
import com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationResponseParser;
import io.jans.inbound.OpenIdParams;
import io.jans.inbound.Provider;
import io.jans.inbound.oauth2.CodeGrantUtil;
import io.jans.inbound.oauth2.OAuthParams;
import io.jans.service.CacheService;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.util.NetworkUtils;
import io.jans.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProcessor {
    private static String KEY_PREFIX = "agama-openid-";
    private static ConfigProcessor instance;
    private static Logger logger;

    public static ConfigProcessor getInstance() {
        if (instance == null) {
            instance = new ConfigProcessor();
        }
        return instance;
    }

    public OAuthParams exec(Provider p) throws Exception {
        boolean credsMissing;
        logger.info("Processing configurations of provider {}", (Object)p.getDisplayName());
        OpenIdParams oip = p.getOpenIdParams();
        String opHost = Optional.ofNullable(oip).map(OpenIdParams::getHost).orElse(null);
        OAuthParams oap = p.getOAuthParams();
        if (oap == null) {
            logger.warn("OAuth properties were missing for this provider!");
            oap = new OAuthParams();
        }
        if (opHost == null) {
            return oap;
        }
        logger.info("Issuing a configuration request to OP {}", (Object)opHost);
        OIDCProviderMetadata opMetadata = OIDCProviderMetadata.resolve((Issuer)new Issuer(opHost), (int)3000, (int)3000);
        this.fillMissingEndpoints(oap, opMetadata);
        Pair<String, String> clientCreds = new Pair<String, String>((Object)oap.getClientId(), (Object)oap.getClientSecret());
        boolean bl = credsMissing = clientCreds.getFirst() == null || clientCreds.getSecond() == null;
        if (credsMissing && oip.isUseDCR()) {
            String key = KEY_PREFIX + opHost;
            if (oip.isUseCachedClient()) {
                clientCreds = this.retrieveCredsFromCache(key, opHost);
            }
            if (clientCreds == null) {
                clientCreds = this.registerClient(opMetadata.getRegistrationEndpointURI(), oap.getRedirectUri(), oap.getScopes(), key);
            } else {
                logger.info("Using the client credentials already present in cache or configuration");
            }
            oap.setClientId((String)clientCreds.getFirst());
            oap.setClientSecret((String)clientCreds.getSecond());
        }
        return oap;
    }

    private void fillMissingEndpoints(OAuthParams oap, OIDCProviderMetadata opMetadata) {
        String s = oap.getAuthzEndpoint();
        if (s == null) {
            logger.info("Grabbing authorization endpoint from OP configuration document");
            oap.setAuthzEndpoint(opMetadata.getAuthorizationEndpointURI().toString());
        }
        if ((s = oap.getTokenEndpoint()) == null) {
            logger.info("Grabbing token endpoint from OP configuration document");
            oap.setTokenEndpoint(opMetadata.getTokenEndpointURI().toString());
        }
        if ((s = oap.getUserInfoEndpoint()) == null) {
            logger.info("Grabbing userInfo endpoint from OP configuration document");
            oap.setUserInfoEndpoint(opMetadata.getUserInfoEndpointURI().toString());
        }
        if ((s = oap.getRedirectUri()) == null) {
            logger.info("Using Agama's default redirect uri");
            oap.setRedirectUri(NetworkUtils.makeRedirectUri());
        }
    }

    private Pair<String, String> retrieveCredsFromCache(String key, String opHost) {
        CacheService cache = (CacheService)CdiUtil.bean(CacheService.class);
        try {
            logger.info("Parsing client creds from cache...");
            return Optional.ofNullable(cache.get(key)).orElse(null);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.info("Removing entry from cache");
            cache.remove(key);
            return null;
        }
    }

    private void storeCredentials(String key, Pair<String, String> creds, Long expSeconds) {
        CacheService cache = (CacheService)CdiUtil.bean(CacheService.class);
        try {
            logger.info("Writing SimpleOAuthParams instance to cache...");
            cache.put(expSeconds.intValue() - 1, key, creds);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Pair<String, String> registerClient(URI registrationURI, String redirectUri, List<String> scopes, String key) throws Exception {
        if (registrationURI == null) {
            String msg = "Unable to determine client registration endpoint URI.";
            logger.error(msg + " OP does not support dynamic client registration?");
            throw new IOException(msg);
        }
        logger.info("Sending a client registration request to {}", (Object)registrationURI);
        OIDCClientMetadata clMetadata = this.makeClientMetadata(redirectUri, scopes);
        OIDCClientRegistrationRequest regRequest = new OIDCClientRegistrationRequest(registrationURI, clMetadata, null);
        ClientRegistrationResponse response = OIDCClientRegistrationResponseParser.parse((HTTPResponse)this.getRegistrationResponse(regRequest));
        if (!response.indicatesSuccess()) {
            throw CodeGrantUtil.exFromError(((ClientRegistrationErrorResponse)ClientRegistrationErrorResponse.class.cast(response)).getErrorObject());
        }
        OIDCClientInformation clientInfo = ((OIDCClientInformationResponse)OIDCClientInformationResponse.class.cast(response)).getOIDCClientInformation();
        this.checkScopes((ClientMetadata)clientInfo.getOIDCMetadata(), scopes);
        String clId = clientInfo.getID().getValue();
        Secret secret = clientInfo.getSecret();
        Date expd = secret.getExpirationDate();
        boolean notExpiring = expd == null;
        logger.debug("Client ID is {}. Expiring {}", (Object)clId, notExpiring ? "NEVER" : expd);
        long expSeconds = notExpiring ? Integer.MAX_VALUE : (expd.getTime() - System.currentTimeMillis()) / 1000L;
        Pair creds = new Pair((Object)clId, (Object)secret.getValue());
        this.storeCredentials(key, (Pair<String, String>)creds, expSeconds);
        return creds;
    }

    private OIDCClientMetadata makeClientMetadata(String redirectUri, List<String> scopes) {
        logger.debug("Building client metadata");
        OIDCClientMetadata clientMetadata = new OIDCClientMetadata();
        clientMetadata.applyDefaults();
        clientMetadata.setResponseTypes(Collections.singleton(ResponseType.CODE));
        clientMetadata.setScope(new Scope(scopes.toArray(new String[0])));
        clientMetadata.setRedirectionURI(URI.create(redirectUri));
        clientMetadata.setName(KEY_PREFIX + System.currentTimeMillis());
        return clientMetadata;
    }

    private HTTPResponse getRegistrationResponse(OIDCClientRegistrationRequest request) throws Exception {
        Object first;
        JSONArray list;
        boolean nullify;
        HTTPResponse response = request.toHTTPRequest().send();
        String property = "backchannel_logout_uri";
        JSONObject json = response.getBodyAsJSONObject();
        Object blu = json.get((Object)property);
        boolean bl = nullify = blu != null;
        if (!nullify || String.class.isInstance(blu)) {
            return response;
        }
        if (JSONArray.class.isInstance(blu) && !(list = (JSONArray)blu).isEmpty() && String.class.isInstance(first = list.get(0))) {
            nullify = false;
            logger.debug("Setting {} to {}", (Object)property, (Object)first.toString());
            json.put((Object)property, (Object)first.toString());
        }
        if (nullify) {
            logger.debug("Nullifying {}", (Object)property);
            json.put((Object)property, null);
        }
        response.setBody(json.toString());
        return response;
    }

    private void checkScopes(ClientMetadata clientMetadata, List<String> originalScopes) {
        Set originalScopesSet;
        Set scopes = clientMetadata.getScope().toStringList().stream().collect(Collectors.toSet());
        if (!scopes.equals(originalScopesSet = originalScopes.stream().collect(Collectors.toSet()))) {
            logger.warn("Scopes differ!. Original: {}; scopes now: {}", originalScopesSet, scopes);
        }
    }

    private ConfigProcessor() {
    }

    static {
        logger = LoggerFactory.getLogger(ConfigProcessor.class);
    }
}

