/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);

    public static String makeRedirectUri() {
        return NetworkUtils.urlBeforeContextPath() + "/jans-auth/fl/callback";
    }

    public static HTTPResponse sendGet(String url, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> parameters) throws IOException {
        HTTPRequest request = new HTTPRequest(HTTPRequest.Method.GET, new URL(url));
        if (headers != null) {
            headers.forEach((k, v) -> request.setHeader(k, v.toArray(new String[0])));
        }
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder query = new StringBuilder("");
            for (String key : parameters.keySet()) {
                List values = (List)parameters.get((Object)key);
                if (values == null || values.isEmpty()) continue;
                String delim = "&" + URLEncoder.encode(key, StandardCharsets.UTF_8) + "=";
                query.append(delim.substring(1));
                query.append(values.stream().map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8)).collect(Collectors.joining(delim)));
            }
            request.setQuery(query.toString());
        }
        return request.send();
    }

    public static Map<String, Object> mapFromGetRequest(String url, MultivaluedMap<String, String> headers, MultivaluedMap<String, String> parameters, boolean ensureOKStatus) throws IOException, ParseException {
        HTTPResponse response = NetworkUtils.sendGet(url, headers, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Request to url {}\nHeaders: {}; Parameters: {}\nResponse (status code {}): {}", new Object[]{url, headers, parameters, response.getStatusCode(), response.getContent()});
        }
        if (ensureOKStatus) {
            response.ensureStatusCode(new int[]{Response.Status.OK.getStatusCode()});
        }
        return response.getContentAsJSONObject();
    }

    public static Map<String, Object> mapFromGetRequestWithToken(String url, String bearerToken) throws IOException, ParseException {
        MultivaluedHashMap headers = new MultivaluedHashMap(Collections.singletonMap("Authorization", "Bearer " + bearerToken));
        return NetworkUtils.mapFromGetRequest(url, (MultivaluedMap<String, String>)headers, null, true);
    }

    public static String urlBeforeContextPath() {
        HttpServletRequest req = (HttpServletRequest)CdiUtil.bean(HttpServletRequest.class);
        return req.getScheme() + "://" + req.getServerName();
    }

    private NetworkUtils() {
    }
}

