/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.bioid;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.casa.conf.OIDCClientSettings;
import io.jans.casa.misc.Utils;
import io.jans.casa.model.ApplicationConfiguration;
import io.jans.casa.plugins.bioid.BioIdPersonModel;
import io.jans.casa.service.IPersistenceService;
import io.jans.model.user.authenticator.UserAuthenticator;
import io.jans.model.user.authenticator.UserAuthenticatorList;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioIdService {
    private static BioIdService SINGLE_INSTANCE = null;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int TIMEOUT = 5000;
    private static ObjectMapper mapper;
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
    private OIDCClientSettings cls;
    private String BIOID_TYPE = "bioid";

    private BioIdService() {
        mapper = new ObjectMapper();
        this.cls = ((ApplicationConfiguration)this.persistenceService.get(ApplicationConfiguration.class, "ou=casa,ou=configuration,o=jans")).getSettings().getOidcSettings().getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BioIdService getInstance() {
        if (SINGLE_INSTANCE != null) return SINGLE_INSTANCE;
        Class<BioIdService> clazz = BioIdService.class;
        synchronized (BioIdService.class) {
            SINGLE_INSTANCE = new BioIdService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SINGLE_INSTANCE;
        }
    }

    public OIDCClientSettings getCasaClient() {
        return this.cls;
    }

    public String generateBioIdCode(byte seedLength) {
        byte[] seed = new byte[seedLength];
        new SecureRandom().nextBytes(seed);
        String dictionary = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        StringBuilder result = new StringBuilder();
        for (byte value : seed) {
            result.append(dictionary.charAt(Math.abs(value) % dictionary.length()));
        }
        return result.toString();
    }

    public Map<String, Object> getBioIdCode(String userId) {
        try {
            BioIdPersonModel user = (BioIdPersonModel)((Object)this.persistenceService.get(BioIdPersonModel.class, this.persistenceService.getPersonDn(userId)));
            UserAuthenticatorList authenticatorList = user.getAuthenticatorList();
            for (UserAuthenticator authenticator : authenticatorList.getAuthenticators()) {
                if (!authenticator.getId().equals(this.BIOID_TYPE)) continue;
                return authenticator.getCustom();
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public void setBioIdCode(String userId, Map<String, Object> bioIdCode) {
        try {
            BioIdPersonModel user = (BioIdPersonModel)((Object)this.persistenceService.get(BioIdPersonModel.class, this.persistenceService.getPersonDn(userId)));
            this.cleanOldAuthenticators(user);
            UserAuthenticator authenticator = new UserAuthenticator(this.BIOID_TYPE, this.BIOID_TYPE);
            authenticator.setCustom(bioIdCode);
            UserAuthenticatorList authenticatorList = user.getAuthenticatorList();
            if (authenticatorList == null) {
                user.setAuthenticatorList(new UserAuthenticatorList());
            }
            user.getAuthenticatorList().addAuthenticator(authenticator);
            this.persistenceService.modify((Object)user);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private void cleanOldAuthenticators(BioIdPersonModel user) {
        try {
            UserAuthenticatorList authenticatorList = user.getAuthenticatorList();
            if (authenticatorList == null) {
                return;
            }
            Iterator it = authenticatorList.getAuthenticators().iterator();
            while (it.hasNext()) {
                UserAuthenticator authenticator = (UserAuthenticator)it.next();
                if (!this.BIOID_TYPE.equals(authenticator.getType())) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }
}

