/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.certauthn.extension;

import io.jans.casa.credential.BasicCredential;
import io.jans.casa.extension.AuthnMethod;
import io.jans.casa.plugins.certauthn.service.CertService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class CertAuthnMethod
implements AuthnMethod {
    private CertService certService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CertAuthnMethod() {
        this.certService = CertService.getInstance();
    }

    public String getUINameKey() {
        return "usrcert.cert_label";
    }

    public String getPanelTitleKey() {
        return "usrcert.cert_title";
    }

    public String getPanelTextKey() {
        return "usrcert.cert_text";
    }

    public String getPanelButtonKey() {
        return "usrcert.cert_manage";
    }

    public String getPageUrl() {
        return "cert-detail.zul";
    }

    public String getAcr() {
        return "io.jans.casa.authn.cert";
    }

    public void reloadConfiguration() {
        this.certService.reloadConfiguration();
    }

    public List<BasicCredential> getEnrolledCreds(String id) {
        try {
            return this.certService.getUserCerts(id).stream().map(cert -> new BasicCredential(cert.getFormattedName(), -1L)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public int getTotalUserCreds(String id) {
        return this.getEnrolledCreds(id).size();
    }
}

