/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model.scim2.util;

import io.jans.scim.model.scim2.AttributeDefinition;
import io.jans.scim.model.scim2.BaseScimResource;
import io.jans.scim.model.scim2.TokenResource;
import io.jans.scim.model.scim2.annotations.Attribute;
import io.jans.scim.model.scim2.annotations.StoreReference;
import io.jans.scim.model.scim2.annotations.Validator;
import io.jans.scim.model.scim2.extensions.Extension;
import io.jans.scim.model.scim2.fido.Fido2DeviceResource;
import io.jans.scim.model.scim2.group.GroupResource;
import io.jans.scim.model.scim2.provider.config.ServiceProviderConfig;
import io.jans.scim.model.scim2.provider.resourcetypes.ResourceType;
import io.jans.scim.model.scim2.provider.schema.SchemaResource;
import io.jans.scim.model.scim2.user.UserResource;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.type.NullType;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntrospectUtil {
    private static Logger log = LogManager.getLogger(IntrospectUtil.class);
    public static List<Class<? extends BaseScimResource>> resourceClasses = List.of(UserResource.class, GroupResource.class, Fido2DeviceResource.class, TokenResource.class, ServiceProviderConfig.class, ResourceType.class, SchemaResource.class);
    private static List<String> requiredAttrsNames;
    private static List<String> defaultAttrsNames;
    private static List<String> alwaysAttrsNames;
    private static List<String> neverAttrsNames;
    private static List<String> requestAttrsNames;
    private static List<String> validableAttrsNames;
    private static List<String> canonicalizedAttrsNames;
    public static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> defaultCoreAttrs;
    public static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> requestCoreAttrs;
    public static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> alwaysCoreAttrs;
    public static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> neverCoreAttrs;
    public static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> requiredCoreAttrs;
    public static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> validableCoreAttrs;
    public static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> canonicalCoreAttrs;
    public static Map<Class<? extends BaseScimResource>, SortedSet<String>> allAttrs;
    public static Map<Class<? extends BaseScimResource>, Map<String, String>> storeRefs;

    private IntrospectUtil() {
    }

    private static Field findField(Class<?> cls, String fieldName) {
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public static Field findFieldFromPath(Class<?> initcls, String path) {
        String prop;
        Class<?> cls = initcls;
        Field f = null;
        String[] stringArray = path.split("\\.");
        int n = stringArray.length;
        for (int i = 0; i < n && (f = IntrospectUtil.findField(cls, prop = stringArray[i])) != null; ++i) {
            Attribute attrAnnot;
            cls = f.getType();
            if (!IntrospectUtil.isCollection(cls) || (attrAnnot = f.getAnnotation(Attribute.class)) == null) continue;
            cls = attrAnnot.multiValueClass();
        }
        return f;
    }

    public static Map<String, Object> strObjMap(Object obj) {
        return (Map)obj;
    }

    public static <T extends Annotation> T getFieldAnnotation(String path, Class resourceClass, Class<T> annotationClass) {
        Field f = IntrospectUtil.findFieldFromPath(resourceClass, path);
        return f == null ? null : (T)f.getAnnotation(annotationClass);
    }

    public static List<Object> getAttributeValues(BaseScimResource bean, final List<Method> getters) {
        final ArrayList<Object> results = new ArrayList<Object>();
        class TraversalClass {
            TraversalClass() {
            }

            void traverse(Object value, int index) {
                try {
                    if (value != null && index < getters.size()) {
                        if (IntrospectUtil.isCollection(value.getClass())) {
                            Collection collection = (Collection)value;
                            if (collection.isEmpty()) {
                                this.traverse(null, index);
                            } else {
                                for (Object val : collection) {
                                    this.traverse(val, index);
                                }
                            }
                        } else {
                            Object val = ((Method)getters.get(index)).invoke(value, new Object[0]);
                            this.traverse(val, index + 1);
                        }
                    }
                    if (index == getters.size()) {
                        results.add(value);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        new TraversalClass().traverse(bean, 0);
        return results;
    }

    public static Method getSetter(String fieldName, Class clazz) throws Exception {
        PropertyDescriptor[] props;
        for (PropertyDescriptor p : props = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (!p.getName().equals(fieldName)) continue;
            return p.getWriteMethod();
        }
        return null;
    }

    public static Method getGetter(String fieldName, Class clazz) throws Exception {
        PropertyDescriptor[] props;
        for (PropertyDescriptor p : props = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (!p.getName().equals(fieldName)) continue;
            return p.getReadMethod();
        }
        return null;
    }

    public static boolean isCollection(Class clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static List<String> getPathsInExtension(Extension extension) {
        ArrayList<String> list = new ArrayList<String>();
        for (String attr : extension.getFields().keySet()) {
            list.add(extension.getUrn() + "." + attr);
        }
        return list;
    }

    private static Map<Class<? extends BaseScimResource>, Map<String, List<Method>>> newEmptyMap() {
        return new HashMap<Class<? extends BaseScimResource>, Map<String, List<Method>>>();
    }

    private static void resetAttrNames() {
        requiredAttrsNames = new ArrayList<String>();
        defaultAttrsNames = new ArrayList<String>();
        validableAttrsNames = new ArrayList<String>();
        canonicalizedAttrsNames = new ArrayList<String>();
        alwaysAttrsNames = new ArrayList<String>();
        neverAttrsNames = new ArrayList<String>();
        requestAttrsNames = new ArrayList<String>();
    }

    private static void resetMaps() {
        requiredCoreAttrs = IntrospectUtil.newEmptyMap();
        defaultCoreAttrs = IntrospectUtil.newEmptyMap();
        alwaysCoreAttrs = IntrospectUtil.newEmptyMap();
        neverCoreAttrs = IntrospectUtil.newEmptyMap();
        requestCoreAttrs = IntrospectUtil.newEmptyMap();
        validableCoreAttrs = IntrospectUtil.newEmptyMap();
        canonicalCoreAttrs = IntrospectUtil.newEmptyMap();
        allAttrs = new HashMap<Class<? extends BaseScimResource>, SortedSet<String>>();
        storeRefs = new HashMap<Class<? extends BaseScimResource>, Map<String, String>>();
    }

    private static void freezeMaps() {
        requiredCoreAttrs = Collections.unmodifiableMap(requiredCoreAttrs);
        defaultCoreAttrs = Collections.unmodifiableMap(defaultCoreAttrs);
        alwaysCoreAttrs = Collections.unmodifiableMap(alwaysCoreAttrs);
        neverCoreAttrs = Collections.unmodifiableMap(neverCoreAttrs);
        requestCoreAttrs = Collections.unmodifiableMap(requestCoreAttrs);
        validableCoreAttrs = Collections.unmodifiableMap(validableCoreAttrs);
        canonicalCoreAttrs = Collections.unmodifiableMap(canonicalCoreAttrs);
        allAttrs = Collections.unmodifiableMap(allAttrs);
        storeRefs = Collections.unmodifiableMap(storeRefs);
    }

    private static void traverseClassForNames(Class clazz, String prefix, List<Field> extraFields, boolean prune) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        fields.addAll(extraFields);
        for (Field f : fields) {
            Validator vAnnot;
            Attribute attrAnnot = f.getAnnotation(Attribute.class);
            if (attrAnnot == null) continue;
            Object name = f.getName();
            if (prefix.length() > 0) {
                name = prefix + "." + (String)name;
            }
            switch (attrAnnot.returned()) {
                case ALWAYS: {
                    alwaysAttrsNames.add((String)name);
                    break;
                }
                case DEFAULT: {
                    defaultAttrsNames.add((String)name);
                    break;
                }
                case NEVER: {
                    neverAttrsNames.add((String)name);
                    break;
                }
                case REQUEST: {
                    requestAttrsNames.add((String)name);
                }
            }
            if (attrAnnot.isRequired()) {
                requiredAttrsNames.add((String)name);
            }
            if (attrAnnot.canonicalValues().length > 0) {
                canonicalizedAttrsNames.add((String)name);
            }
            if ((vAnnot = f.getAnnotation(Validator.class)) != null) {
                validableAttrsNames.add((String)name);
            }
            if (prune || !attrAnnot.type().equals((Object)AttributeDefinition.Type.COMPLEX)) continue;
            Class<?> cls = attrAnnot.multiValueClass();
            if (cls.equals(NullType.class)) {
                cls = f.getType();
            }
            if (clazz.equals(cls)) {
                prune = true;
            }
            IntrospectUtil.traverseClassForNames(cls, (String)name, new ArrayList<Field>(), prune);
        }
    }

    private static Map<String, List<Method>> computeGettersMap(List<String> attrNames, Class baseClass) throws Exception {
        HashMap<String, List<Method>> map = new HashMap<String, List<Method>>();
        for (String attrName : attrNames) {
            ArrayList<Method> list = new ArrayList<Method>();
            Class clazz = baseClass;
            for (String prop : attrName.split("\\.")) {
                Method method = IntrospectUtil.getGetter(prop, clazz);
                list.add(method);
                if (IntrospectUtil.isCollection(method.getReturnType())) {
                    Field f = IntrospectUtil.findField(clazz, prop);
                    Attribute attrAnnot = f.getAnnotation(Attribute.class);
                    if (attrAnnot == null) continue;
                    clazz = attrAnnot.multiValueClass();
                    continue;
                }
                clazz = method.getReturnType();
            }
            map.put(attrName, list);
        }
        return map;
    }

    static {
        try {
            List<Field> basicFields = Arrays.asList(BaseScimResource.class.getDeclaredFields());
            IntrospectUtil.resetMaps();
            for (Class<? extends BaseScimResource> aClass : resourceClasses) {
                IntrospectUtil.resetAttrNames();
                IntrospectUtil.traverseClassForNames(aClass, "", basicFields, false);
                requiredCoreAttrs.put(aClass, IntrospectUtil.computeGettersMap(requiredAttrsNames, aClass));
                defaultCoreAttrs.put(aClass, IntrospectUtil.computeGettersMap(defaultAttrsNames, aClass));
                alwaysCoreAttrs.put(aClass, IntrospectUtil.computeGettersMap(alwaysAttrsNames, aClass));
                neverCoreAttrs.put(aClass, IntrospectUtil.computeGettersMap(neverAttrsNames, aClass));
                requestCoreAttrs.put(aClass, IntrospectUtil.computeGettersMap(requestAttrsNames, aClass));
                validableCoreAttrs.put(aClass, IntrospectUtil.computeGettersMap(validableAttrsNames, aClass));
                canonicalCoreAttrs.put(aClass, IntrospectUtil.computeGettersMap(canonicalizedAttrsNames, aClass));
                allAttrs.put(aClass, new TreeSet());
                allAttrs.get(aClass).addAll(alwaysAttrsNames);
                allAttrs.get(aClass).addAll(defaultAttrsNames);
                allAttrs.get(aClass).addAll(neverAttrsNames);
                allAttrs.get(aClass).addAll(requestAttrsNames);
            }
            for (Class<? extends BaseScimResource> cls : resourceClasses) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (String attrib : allAttrs.get(cls)) {
                    StoreReference annotation;
                    Field field = IntrospectUtil.findFieldFromPath(cls, attrib);
                    if (field == null || (annotation = field.getAnnotation(StoreReference.class)) == null) continue;
                    if (StringUtils.isNotEmpty((CharSequence)annotation.ref())) {
                        map.put(attrib, annotation.ref());
                        continue;
                    }
                    List<Class<? extends BaseScimResource>> clsList = Arrays.asList(annotation.resourceType());
                    int i = clsList.indexOf(cls);
                    if (i < 0 || i >= annotation.refs().length) continue;
                    map.put(attrib, annotation.refs()[i]);
                }
                storeRefs.put(cls, map);
            }
            IntrospectUtil.freezeMaps();
        }
        catch (Exception e) {
            log.fatal(e.getMessage(), (Throwable)e);
        }
    }
}

