/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.certauthn.vm;

import io.jans.casa.core.pojo.User;
import io.jans.casa.misc.Utils;
import io.jans.casa.plugins.certauthn.model.Certificate;
import io.jans.casa.plugins.certauthn.model.Reference;
import io.jans.casa.plugins.certauthn.service.CertService;
import io.jans.casa.service.ISessionContext;
import io.jans.casa.service.SndFactorAuthenticationUtils;
import io.jans.casa.ui.UIUtils;
import io.jans.service.cache.CacheProvider;
import io.jans.util.security.StringEncrypter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.Pair;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Messagebox;

public class CertAuthenticationSummaryVM {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @WireVariable
    private ISessionContext sessionContext;
    private CacheProvider cacheProvider;
    private String userId;
    private User user;
    private List<Certificate> certificates;
    private CertService certService;
    private SndFactorAuthenticationUtils sndFactorUtils;
    private StringEncrypter stringEncrypter;
    private SecureRandom random;

    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    @Init
    public void init() throws StringEncrypter.EncryptionException {
        this.user = this.sessionContext.getLoggedUser();
        this.userId = this.user.getId();
        this.random = new SecureRandom();
        this.certService = CertService.getInstance();
        this.certificates = this.certService.getUserCerts(this.userId);
        this.stringEncrypter = Utils.stringEncrypter();
        this.cacheProvider = (CacheProvider)Utils.managedBean(CacheProvider.class);
        this.sndFactorUtils = (SndFactorAuthenticationUtils)Utils.managedBean(SndFactorAuthenticationUtils.class);
        this.logger.debug("CertAuthenticationSummaryVM initialized");
    }

    public void redirect() throws StringEncrypter.EncryptionException {
        String key = ("" + this.random.nextDouble()).substring(2);
        String encKey = URLEncoder.encode(this.stringEncrypter.encrypt(key), StandardCharsets.UTF_8);
        int time = this.certService.getRoundTripMaxTime();
        Reference ref = new Reference(this.userId, true, System.currentTimeMillis() + 1000L * (long)time);
        this.cacheProvider.put(time, key, (Object)new JSONObject((Object)ref).toString());
        Executions.getCurrent().sendRedirect(this.certService.getCertPickupUrl() + "?ref=" + encKey);
    }

    public void delete(Certificate certificate) {
        String resetMessages = (String)this.sndFactorUtils.removalConflict("io.jans.casa.authn.cert", this.certificates.size(), this.user).getY();
        boolean reset = resetMessages != null;
        Pair<String, String> delMessages = this.getDeleteMessages(resetMessages);
        Messagebox.show((String)((String)delMessages.getY()), (String)((String)delMessages.getX()), (int)48, (String)(reset ? "z-messagebox-icon z-messagebox-exclamation" : "z-messagebox-icon z-messagebox-question"), event -> {
            if ("onYes".equals(event.getName())) {
                try {
                    String fingerprint = certificate.getFingerPrint();
                    boolean success = this.certService.removeFromUser(fingerprint, this.userId);
                    if (success) {
                        this.logger.info("Certificate {} removed from user account", (Object)fingerprint);
                        if (reset) {
                            this.sndFactorUtils.turn2faOff(this.user);
                        }
                        this.certificates.remove(certificate);
                        BindUtils.postNotifyChange((Object)this, (String)"certificates");
                    } else {
                        this.logger.error("Failure to remove certificate {} from user account", (Object)fingerprint);
                    }
                    UIUtils.showMessageUI((boolean)success);
                }
                catch (Exception e) {
                    UIUtils.showMessageUI((boolean)false);
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private Pair<String, String> getDeleteMessages(String msg) {
        StringBuilder text = new StringBuilder();
        if (msg != null) {
            text.append(msg).append("\n\n");
        }
        text.append(Labels.getLabel((String)"usercert.del_confirm"));
        if (msg != null) {
            text.append("\n");
        }
        return new Pair(null, (Object)text.toString());
    }
}

