/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model.scim2.provider.config;

import io.jans.scim.model.scim2.AttributeDefinition;
import io.jans.scim.model.scim2.annotations.Attribute;

public class AuthenticationScheme {
    @Attribute(description="The authentication scheme.", isRequired=true, canonicalValues={"oauth", "oauth2", "oauthbearertoken", "httpbasic", "httpdigest", "uma"}, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String type;
    @Attribute(description="The common authentication scheme name, e.g., HTTP Basic.", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String name;
    @Attribute(description="A description of the authentication scheme.", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String description;
    @Attribute(description="An HTTP-addressable URL pointing to the authentication scheme's specification.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String specUri;
    @Attribute(description="An HTTP-addressable URL pointing to the authentication scheme's usage documentation.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String documentationUri;
    @Attribute(description="Whether it's the preferred authentication scheme for service usage", mutability=AttributeDefinition.Mutability.READ_ONLY, type=AttributeDefinition.Type.BOOLEAN)
    private boolean primary;

    public AuthenticationScheme() {
    }

    public AuthenticationScheme(String name, String description, String specUri, String documentationUri, String type, boolean primary) {
        this.name = name;
        this.description = description;
        this.specUri = specUri;
        this.documentationUri = documentationUri;
        this.type = type;
        this.primary = primary;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSpecUri() {
        return this.specUri;
    }

    public String getDocumentationUri() {
        return this.documentationUri;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSpecUri(String specUri) {
        this.specUri = specUri;
    }

    public void setDocumentationUri(String documentationUri) {
        this.documentationUri = documentationUri;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public static AuthenticationScheme createBasic(boolean primary) {
        return new AuthenticationScheme("Http Basic", "The HTTP Basic Access Authentication scheme. This scheme is not considered to be a secure method of user authentication (unless used in conjunction with some external secure system such as SSL), as the user name and password are passed over the network as cleartext.", "http://www.ietf.org/rfc/rfc2617.txt", "http://en.wikipedia.org/wiki/Basic_access_authentication", "httpbasic", primary);
    }

    public static AuthenticationScheme createOAuth2(boolean primary) {
        return new AuthenticationScheme("OAuth 2.0", "OAuth2 Bearer Token Authentication Scheme.", "http://tools.ietf.org/html/rfc6749", "http://tools.ietf.org/html/rfc6749", "oauth2", primary);
    }
}

