/*
 * Decompiled with CFR 0.152.
 */
package io.jans.scim.model.scim2.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.scim.model.scim2.AttributeDefinition;
import io.jans.scim.model.scim2.annotations.Attribute;
import io.jans.scim.model.scim2.annotations.StoreReference;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Group {
    @Attribute(description="The identifier of the User's group.", isRequired=true, mutability=AttributeDefinition.Mutability.READ_ONLY)
    @StoreReference(ref="memberOf")
    private String value;
    @Attribute(description="The URI of the corresponding Group resource to which the user belongs", referenceTypes={"User", "Group"}, mutability=AttributeDefinition.Mutability.READ_ONLY, type=AttributeDefinition.Type.REFERENCE)
    @JsonProperty(value="$ref")
    private String ref;
    @Attribute(description="A human readable name, primarily used for display purposes.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String display;
    @Attribute(description="A label indicating the attribute's function; e.g., 'direct' or 'indirect'.", canonicalValues={"direct", "indirect"}, mutability=AttributeDefinition.Mutability.READ_ONLY)
    private String type;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getType() {
        return this.type;
    }

    @JsonProperty
    public void setType(String type) {
        this.type = type;
    }

    public void setType(Type type) {
        this.setType(type.name().toLowerCase());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.display == null ? other.display != null : !this.display.equals(other.display));
    }

    public static enum Type {
        DIRECT,
        INDIRECT;

    }
}

