/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.certauthn.vm;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.model.util.CertUtils;
import io.jans.casa.core.pojo.User;
import io.jans.casa.misc.Utils;
import io.jans.casa.misc.WebUtils;
import io.jans.casa.plugins.certauthn.model.Minion;
import io.jans.casa.plugins.certauthn.model.Reference;
import io.jans.casa.plugins.certauthn.service.CertService;
import io.jans.casa.plugins.certauthn.service.UserCertificateMatch;
import io.jans.casa.service.IPersistenceService;
import io.jans.casa.service.SndFactorAuthenticationUtils;
import io.jans.service.cache.CacheProvider;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;

public class CertAuthnVM {
    public static final String RND_KEY = "ref";
    private static final String CERT_HEADER = "X-ClientCert";
    private static final String AGAMA_CB = "/jans-auth/fl/callback";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String key;
    private String messageKey;
    private String flowCallbackUrl;
    private boolean present;
    private boolean parsed;
    private boolean valid;
    private boolean enroll;
    private UserCertificateMatch userCertMatch;
    private CertService certService;
    private CacheProvider cacheProvider;

    public String getMessageKey() {
        return this.messageKey;
    }

    public boolean isEnroll() {
        return this.enroll;
    }

    public String getFlowCallbackUrl() {
        return this.flowCallbackUrl;
    }

    @Init
    public void init() {
        try {
            this.logger.info("Loading certificate validation page...");
            this.messageKey = "general.error.general";
            this.flowCallbackUrl = ((IPersistenceService)Utils.managedBean(IPersistenceService.class)).getIssuerUrl() + AGAMA_CB;
            this.cacheProvider = (CacheProvider)Utils.managedBean(CacheProvider.class);
            this.certService = CertService.getInstance();
            if (!this.certService.isHasValidProperties()) {
                this.logger.warn("Configuration errors detected. Please check the log file and plugin documentation");
                this.messageKey = "usrcert.config_problems";
                return;
            }
            String encKey = WebUtils.getQueryParam((String)RND_KEY);
            if (Utils.isEmpty((String)encKey)) {
                this.logger.warn("Expected parameter '{}' not specified in URL.", (Object)RND_KEY);
                return;
            }
            this.key = URLDecoder.decode(Utils.stringEncrypter().decrypt(encKey), StandardCharsets.UTF_8);
            Reference ref = this.getReference(this.key);
            if (ref == null) {
                this.logger.warn("Expired or missing cache entry. Check if roundTripMaxTime property is too low");
                return;
            }
            String userId = ref.getUserId();
            this.enroll = ref.isEnroll();
            if (userId == null) {
                this.logger.warn("UserId missing in cache entry");
                return;
            }
            X509Certificate userCert = this.processCert(WebUtils.getRequestHeader((String)CERT_HEADER));
            this.userCertMatch = this.valid ? this.certService.processMatch(userCert, userId, this.enroll) : null;
            boolean success = UserCertificateMatch.SUCCESS.equals((Object)this.userCertMatch);
            this.computeMessageKey();
            String outcome = "";
            if (!success) {
                outcome = Labels.getLabel((String)this.messageKey);
                this.logger.error("Cert processing failure. Reason: {}", (Object)outcome);
            }
            if (!this.enroll) {
                Long timeLeft = (ref.getExpiresAt() - System.currentTimeMillis()) / 1000L;
                if (timeLeft <= 0L) {
                    this.logger.warn("Expired cache entry");
                    return;
                }
                this.cacheProvider.put(timeLeft.intValue(), this.key, (Object)outcome);
                if (success) {
                    this.logger.info("Redirecting for completion of authentication flow");
                    WebUtils.execRedirect((String)this.flowCallbackUrl, (boolean)false);
                }
                return;
            }
            if (success) {
                IPersistenceService ps = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
                Minion p = (Minion)((Object)ps.get(Minion.class, ps.getPersonDn(userId)));
                User user = new User();
                user.setUserName(p.getUid());
                user.setId(p.getInum());
                user.setPreferredMethod(p.getPreferredMethod());
                ((SndFactorAuthenticationUtils)Utils.managedBean(SndFactorAuthenticationUtils.class)).notifyEnrollment(user, "io.jans.casa.authn.cert");
            }
        }
        catch (Exception e) {
            this.messageKey = "general.error.general";
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private X509Certificate processCert(String clientCertString) {
        X509Certificate clientCert = null;
        try {
            if (Utils.isEmpty((String)clientCertString) || clientCertString.equals("(null)")) {
                this.logger.warn("No data in header '{}'", (Object)CERT_HEADER);
            } else {
                this.present = true;
                clientCert = CertUtils.x509CertificateFromPem((String)clientCertString);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (clientCert == null) {
            this.logger.warn("No client certificate was found. Probably the user hit the Cancel button in the browser prompt");
        } else {
            this.parsed = true;
            this.valid = this.certService.validate(clientCert);
        }
        return clientCert;
    }

    private Reference getReference(String k) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String str = Optional.ofNullable(this.cacheProvider.get(k)).map(Object::toString).orElse(null);
        if (str == null) {
            return null;
        }
        return (Reference)mapper.readValue(str, Reference.class);
    }

    private void computeMessageKey() {
        this.messageKey = !this.present ? "usrcert.not_selected" : (!this.parsed ? "usrcert.unparsable" : (!this.valid ? "usrcert.not_valid" : "usrcert.match_" + this.userCertMatch.name()));
    }
}

