/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.branding;

import io.jans.casa.misc.Utils;
import io.jans.casa.plugins.branding.BrandingOption;
import io.jans.casa.plugins.branding.CssSnippetHandler;
import io.jans.casa.service.IBrandingManager;
import io.jans.casa.ui.UIUtils;
import io.jans.util.Pair;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.image.Image;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Messagebox;

public class CustomBrandingViewModel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IBrandingManager assetsService;
    private BrandingOption previouslySelected;
    private BrandingOption brandingOption;
    private CssSnippetHandler snippetHandler;
    private boolean uiOverrideButtonColors;
    private Pair<String, byte[]> logo;
    private Pair<String, byte[]> favicon;

    public String getBrandingOption() {
        return this.brandingOption.toString();
    }

    public CssSnippetHandler getSnippetHandler() {
        return this.snippetHandler;
    }

    public boolean isUiOverrideButtonColors() {
        return this.uiOverrideButtonColors;
    }

    public Pair<String, byte[]> getLogo() {
        return this.logo;
    }

    public Pair<String, byte[]> getFavicon() {
        return this.favicon;
    }

    @Init
    public void init() {
        this.logger.debug("Initializing ViewModel");
        this.assetsService = (IBrandingManager)Utils.managedBean(IBrandingManager.class);
        this.brandingOption = Utils.isNotEmpty((String)this.assetsService.getPrefix()) ? BrandingOption.EXTERNAL_PATH : (Utils.isNotEmpty((String)this.assetsService.getExtraCss()) ? BrandingOption.EXTRA_CSS : BrandingOption.NONE);
        this.changeBranding(this.brandingOption.toString());
    }

    @NotifyChange(value={"brandingOption", "logo", "favicon", "snippetHandler", "uiOverrideButtonColors"})
    public void changeBranding(String option) {
        this.logger.info("Branding option changed to {}", (Object)option);
        this.previouslySelected = this.brandingOption;
        this.brandingOption = BrandingOption.valueOf(option);
        if (this.brandingOption.equals((Object)BrandingOption.EXTRA_CSS)) {
            this.snippetHandler = new CssSnippetHandler(this.assetsService.getExtraCss(), Labels.getLabel((String)"adm.branding_footer"));
            this.uiOverrideButtonColors = this.snippetHandler.getPrimaryButtonColor() != null;
            this.logo = new Pair((Object)(this.assetsService.getLogoUrl() + this.randomSuffix()), null);
            this.favicon = new Pair((Object)(this.assetsService.getFaviconUrl() + this.randomSuffix()), null);
        }
    }

    @NotifyChange(value={"logo"})
    public void logoUploaded(Media media) {
        this.logger.trace("Logo file has been uploaded");
        this.processUpload(this.logo, media);
    }

    @NotifyChange(value={"favicon"})
    public void faviconUploaded(Media media) {
        this.logger.trace("Favicon file has been uploaded");
        this.processUpload(this.favicon, media);
    }

    public void save() {
        try {
            switch (this.brandingOption) {
                case NONE: {
                    this.assetsService.factoryReset();
                    UIUtils.showMessageUI((boolean)true);
                    break;
                }
                case EXTERNAL_PATH: {
                    String brandingPath = IBrandingManager.CUSTOM_FILEPATH;
                    if (!Files.isDirectory(Paths.get(brandingPath, "images"), new LinkOption[0]) || !Files.isDirectory(Paths.get(brandingPath, "styles", "gluu"), new LinkOption[0])) {
                        Messagebox.show((String)Labels.getLabel((String)"branding.no_subdirs", (Object[])new String[]{brandingPath}), null, (int)48, (String)"z-messagebox-icon z-messagebox-question", event -> {
                            if ("onYes".equals(event.getName())) {
                                this.useExternalAssets();
                            } else {
                                this.changeBranding(this.previouslySelected.toString());
                                BindUtils.postNotifyChange((Object)this, (String)"brandingOption");
                            }
                        });
                        break;
                    }
                    this.useExternalAssets();
                    break;
                }
                case EXTRA_CSS: {
                    if (this.favicon.getSecond() != null) {
                        this.assetsService.setFaviconContent((byte[])this.favicon.getSecond());
                    }
                    if (this.logo.getSecond() != null) {
                        this.assetsService.setLogoContent((byte[])this.logo.getSecond());
                    }
                    this.assetsService.useExtraCss(this.snippetHandler.getSnippet(this.uiOverrideButtonColors));
                    Messagebox.show((String)Labels.getLabel((String)"adm.branding_changed"), null, (int)1, (String)"z-messagebox-icon z-messagebox-information");
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            UIUtils.showMessageUI((boolean)false, (String)e.getMessage());
        }
    }

    @NotifyChange(value={"snippetHandler", "uiOverrideButtonColors"})
    public void buttonColorChanging(boolean override) throws Exception {
        this.uiOverrideButtonColors = override;
        if (override) {
            this.snippetHandler.assignMissingButtonColors();
        }
    }

    private String processImageMedia(String name, byte[] data) {
        String dataUri = null;
        try {
            dataUri = Utils.getImageDataUriEncoding((byte[])data, (String)name);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            UIUtils.showMessageUI((boolean)false);
        }
        return dataUri;
    }

    private void processUpload(Pair<String, byte[]> pair, Media media) {
        if (media instanceof Image) {
            this.logger.info("Processing blob {}", (Object)media.getName());
            pair.setFirst((Object)this.processImageMedia(media.getName(), media.getByteData()));
            pair.setSecond((Object)media.getByteData());
        } else {
            UIUtils.showMessageUI((boolean)false, (String)Labels.getLabel((String)"branding.quick_noimg"));
        }
    }

    private void useExternalAssets() {
        try {
            this.assetsService.useExternalAssets();
            Messagebox.show((String)Labels.getLabel((String)"adm.branding_changed"), null, (int)1, (String)"z-messagebox-icon z-messagebox-information");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            UIUtils.showMessageUI((boolean)false, (String)e.getMessage());
        }
    }

    private String randomSuffix() {
        return "?" + Math.random();
    }
}

