/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.branding;

import io.jans.casa.misc.Utils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssSnippetHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String HEADER_SELECTOR = "cust-header";
    private static final String PRIMARY_BUTTON_SELECTOR = "cust-primary-button";
    private static final String SECONDARY_BUTTON_SELECTOR = "cust-cancel-button";
    private static final String TERTIARY_BUTTON_SELECTOR = "cust-misc-button";
    private static final String FOOTER_SELECTOR = "cust-footer-msg-rule";
    private static final String PRIMARY_BUTTON_DEF_COLOR = "#FF80CC";
    private static final String SECONDARY_BUTTON_DEF_COLOR = "#96CCFF";
    private static final String TERTIARY_BUTTON_DEF_COLOR = "#9EEBCF";
    private static final String HEADER_DEF_COLOR = "#FBF1A9";
    private String headerColor;
    private String primaryButtonColor;
    private String secondaryButtonColor;
    private String tertiaryButtonColor;
    private String footerInnerHtml;

    CssSnippetHandler(String str, String defaultFooterHtml) {
        if (str != null) {
            this.headerColor = this.getMatchingString(HEADER_SELECTOR, "\\s*background-color\\s*:\\s*([^;]+)", str);
            this.primaryButtonColor = this.getMatchingString(PRIMARY_BUTTON_SELECTOR, "\\s*background-color\\s*:\\s*([^;]+)", str);
            this.secondaryButtonColor = this.getMatchingString(SECONDARY_BUTTON_SELECTOR, "\\s*background-color\\s*:\\s*([^;]+)", str);
            this.tertiaryButtonColor = this.getMatchingString(TERTIARY_BUTTON_SELECTOR, "\\s*background-color\\s*:\\s*([^;]+)", str);
            this.footerInnerHtml = this.getMatchingString(FOOTER_SELECTOR, "\\s*content\\s*:\\s*([^;]+)", str);
            if (this.footerInnerHtml != null) {
                this.footerInnerHtml = this.footerInnerHtml.substring(1, this.footerInnerHtml.length() - 1);
            }
        }
        this.footerInnerHtml = Optional.ofNullable(this.footerInnerHtml).orElse(defaultFooterHtml);
        this.assignMissingHeaderColors();
    }

    private String getMatchingString(String selector, String subregexp, String cssString) {
        String match = null;
        try {
            String regexp = "\\." + selector + "\\s*\\{([^\\}]+)\\}";
            Matcher m = Pattern.compile(regexp).matcher(cssString);
            if (m.find() && Utils.isNotEmpty((String)(match = m.group(1))) && (m = Pattern.compile(subregexp).matcher(match)).find()) {
                match = m.group(1);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return match;
    }

    private String toned(String color, boolean lighter) {
        Object cl = lighter ? Integer.toString(Math.min(255, Integer.parseInt(color, 16) + 16), 16) : Integer.toString(Math.max(0, Integer.parseInt(color, 16) - 16), 16);
        cl = (String)cl + "0";
        return ((String)cl).substring(0, 2);
    }

    private String getColorFrom(String hexaColor, boolean lighter) {
        try {
            String r = this.toned(hexaColor.substring(1, 3), lighter);
            String g = this.toned(hexaColor.substring(3, 5), lighter);
            String b = this.toned(hexaColor.substring(5, 7), lighter);
            hexaColor = String.format("#%s%s%s", r, g, b);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return hexaColor;
    }

    private String getSnippetForButton(String selector, String color) {
        Object snip = "";
        snip = (String)snip + String.format(".%s{ background-color : %s; border-color: %s }\n", selector, color, color);
        String tone = this.getColorFrom(color, true);
        snip = (String)snip + String.format(".%s{ background-color : %s; border-color: %s }\n", selector + ":disabled", tone, tone);
        snip = (String)snip + String.format(".%s{ background-color : %s; border-color: %s }\n", selector + ":disabled:hover", tone, tone);
        tone = this.getColorFrom(color, false);
        snip = (String)snip + String.format(".%s{ background-color : %s; border-color: %s }\n", selector + ":hover", tone, tone);
        snip = (String)snip + String.format(".%s{ background-color : %s; border-color: %s }\n", selector + ":focus", tone, tone);
        tone = this.getColorFrom(tone, false);
        snip = (String)snip + String.format(".%s{ background-color : %s; border-color: %s }\n", selector + ":focus:active", tone, tone);
        return snip;
    }

    private void assignMissingHeaderColors() {
        if (this.headerColor == null) {
            this.headerColor = HEADER_DEF_COLOR;
        }
    }

    String getSnippet(boolean includeButtons) {
        Object snip = "";
        snip = (String)snip + String.format(".%s{ background-color : %s; }\n", HEADER_SELECTOR, this.headerColor);
        snip = (String)snip + String.format(".%s{ content: '%s'; }\n", FOOTER_SELECTOR, this.footerInnerHtml.replaceAll("\"", "\\\"").replaceAll("'", "\\\\'"));
        if (includeButtons) {
            snip = (String)snip + this.getSnippetForButton(PRIMARY_BUTTON_SELECTOR, this.primaryButtonColor);
            snip = (String)snip + this.getSnippetForButton(SECONDARY_BUTTON_SELECTOR, this.secondaryButtonColor);
            snip = (String)snip + this.getSnippetForButton(TERTIARY_BUTTON_SELECTOR, this.tertiaryButtonColor);
        }
        this.logger.debug("Generated CSS snippet is {}", snip);
        return snip;
    }

    void assignMissingButtonColors() {
        if (this.primaryButtonColor == null) {
            this.primaryButtonColor = PRIMARY_BUTTON_DEF_COLOR;
        }
        if (this.secondaryButtonColor == null) {
            this.secondaryButtonColor = SECONDARY_BUTTON_DEF_COLOR;
        }
        if (this.tertiaryButtonColor == null) {
            this.tertiaryButtonColor = TERTIARY_BUTTON_DEF_COLOR;
        }
    }

    public String getHeaderColor() {
        return this.headerColor;
    }

    public String getPrimaryButtonColor() {
        return this.primaryButtonColor;
    }

    public String getSecondaryButtonColor() {
        return this.secondaryButtonColor;
    }

    public String getTertiaryButtonColor() {
        return this.tertiaryButtonColor;
    }

    public String getFooterInnerHtml() {
        return this.footerInnerHtml;
    }

    public void setHeaderColor(String headerColor) {
        this.headerColor = headerColor;
    }

    public void setPrimaryButtonColor(String primaryButtonColor) {
        this.primaryButtonColor = primaryButtonColor;
    }

    public void setSecondaryButtonColor(String secondaryButtonColor) {
        this.secondaryButtonColor = secondaryButtonColor;
    }

    public void setTertiaryButtonColor(String tertiaryButtonColor) {
        this.tertiaryButtonColor = tertiaryButtonColor;
    }

    public void setFooterInnerHtml(String footerInnerHtml) {
        this.footerInnerHtml = footerInnerHtml;
    }
}

