/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.strongauthn.rest;

import io.jans.casa.conf.Basic2FASettings;
import io.jans.casa.misc.Utils;
import io.jans.casa.plugins.strongauthn.conf.Configuration;
import io.jans.casa.plugins.strongauthn.conf.EnforcementPolicy;
import io.jans.casa.plugins.strongauthn.conf.TrustedDevicesSettings;
import io.jans.casa.plugins.strongauthn.service.StrongAuthSettingsService;
import io.jans.casa.rest.ProtectedApi;
import io.jans.casa.service.settings.IPluginSettingsHandler;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config")
@ProtectedApi(scopes={"https://jans.io/casa.config"})
public class StrongAuthnSettingsWS {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static StrongAuthSettingsService service = StrongAuthSettingsService.instance();
    private IPluginSettingsHandler<Configuration> settingsHandler = service.getSettingsHandler();

    @GET
    @Produces(value={"application/json"})
    public Response retrieve() {
        Response.Status httpStatus;
        String json = null;
        this.logger.trace("StrongAuthnSettingsWS retrieve operation called");
        try {
            json = Utils.jsonFromObject((Object)this.settingsHandler.getSettings());
            httpStatus = Response.Status.OK;
        }
        catch (Exception e) {
            json = e.getMessage();
            this.logger.error(json, (Throwable)e);
            httpStatus = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)httpStatus).entity((Object)json).build();
    }

    @POST
    @Path(value="basic")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response setBasicConfig(Basic2FASettings settings) {
        Response.Status httpStatus;
        String json = null;
        Configuration cfg = (Configuration)this.settingsHandler.getSettings();
        Basic2FASettings value = cfg.getBasic2FASettings();
        this.logger.trace("StrongAuthnSettingsWS setBasicConfig operation called");
        try {
            httpStatus = Response.Status.BAD_REQUEST;
            if (settings == null) {
                json = "Empty payload";
                this.logger.warn(json);
            } else if (settings.getMinCreds() < 1) {
                json = "Minimum number of credentials expected to be greater than zero";
                this.logger.warn(json);
            } else if (!settings.isAutoEnable() && !settings.isAllowSelfEnableDisable()) {
                json = "Cannot prevent users to turn 2FA on/off when there is no 2FA auto-enablement";
                this.logger.warn(json);
            } else {
                cfg.setBasic2FASettings(settings);
                this.settingsHandler.setSettings((Object)cfg);
                this.settingsHandler.save();
                httpStatus = Response.Status.OK;
            }
        }
        catch (Exception e) {
            cfg.setBasic2FASettings(value);
            this.settingsHandler.setSettings((Object)cfg);
            json = e.getMessage();
            this.logger.error(json, (Throwable)e);
            httpStatus = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)httpStatus).entity((Object)json).build();
    }

    @POST
    @Path(value="enforcement-policies")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response setEnforcementPolicies(List<EnforcementPolicy> policies) {
        Response.Status httpStatus;
        String json = null;
        Configuration cfg = (Configuration)this.settingsHandler.getSettings();
        List value = cfg.getEnforcement2FA();
        this.logger.trace("StrongAuthnSettingsWS setEnforcementPolicies operation called");
        try {
            httpStatus = Response.Status.BAD_REQUEST;
            if (policies == null) {
                json = "Empty payload";
                this.logger.warn(json);
            } else if (policies.size() == 1 || policies.size() == 2 && policies.contains(EnforcementPolicy.LOCATION_UNKNOWN) && policies.contains(EnforcementPolicy.DEVICE_UNKNOWN)) {
                cfg.setEnforcement2FA(policies);
                this.settingsHandler.setSettings((Object)cfg);
                this.settingsHandler.save();
                httpStatus = Response.Status.OK;
            } else {
                json = String.format("Unacceptable combination of policies %s", policies);
                this.logger.warn(json);
            }
        }
        catch (Exception e) {
            cfg.setEnforcement2FA(value);
            this.settingsHandler.setSettings((Object)cfg);
            json = e.getMessage();
            this.logger.error(json, (Throwable)e);
            httpStatus = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)httpStatus).entity((Object)json).build();
    }

    @POST
    @Path(value="trusted-devices")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response setTrustedDevices(TrustedDevicesSettings settings) {
        Response.Status httpStatus;
        String json = null;
        Configuration cfg = (Configuration)this.settingsHandler.getSettings();
        TrustedDevicesSettings value = cfg.getTrustedDevicesSettings();
        this.logger.trace("StrongAuthnSettingsWS setTrustedDevices operation called");
        try {
            httpStatus = Response.Status.BAD_REQUEST;
            if (settings == null) {
                json = "Empty payload";
                this.logger.warn(json);
            } else {
                int lexp = Optional.ofNullable(settings.getLocationExpirationDays()).orElse(0);
                int dexp = Optional.ofNullable(settings.getDeviceExpirationDays()).orElse(0);
                if (lexp > 0 && dexp > 0) {
                    cfg.setTrustedDevicesSettings(settings);
                    this.settingsHandler.setSettings((Object)cfg);
                    this.settingsHandler.save();
                    httpStatus = Response.Status.OK;
                } else {
                    json = "One or more of the provided expiration values are invalid";
                    this.logger.warn(json);
                }
            }
        }
        catch (Exception e) {
            cfg.setTrustedDevicesSettings(value);
            this.settingsHandler.setSettings((Object)cfg);
            json = e.getMessage();
            this.logger.error(json, (Throwable)e);
            httpStatus = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)httpStatus).entity((Object)json).build();
    }
}

