/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.strongauthn.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.casa.core.model.PersonPreferences;
import io.jans.casa.misc.Utils;
import io.jans.casa.plugins.strongauthn.conf.Configuration;
import io.jans.casa.plugins.strongauthn.conf.EnforcementPolicy;
import io.jans.casa.plugins.strongauthn.model.TrustedDevice;
import io.jans.casa.plugins.strongauthn.model.TrustedDeviceComparator;
import io.jans.casa.service.IPersistenceService;
import io.jans.casa.service.settings.IPluginSettingsHandler;
import io.jans.casa.service.settings.IPluginSettingsHandlerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.Pair;

public class StrongAuthSettingsService {
    private Logger logger;
    private IPersistenceService persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
    private ObjectMapper mapper = new ObjectMapper();
    private IPluginSettingsHandler<Configuration> settingsHandler;
    private static StrongAuthSettingsService instance;

    private StrongAuthSettingsService(String pluginId) throws Exception {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.settingsHandler = ((IPluginSettingsHandlerFactory)Utils.managedBean(IPluginSettingsHandlerFactory.class)).getHandler(pluginId, Configuration.class);
    }

    public static StrongAuthSettingsService instance() {
        return instance;
    }

    public IPluginSettingsHandler<Configuration> getSettingsHandler() {
        return this.settingsHandler;
    }

    public static StrongAuthSettingsService instance(String pluginId) throws Exception {
        if (instance == null && pluginId != null) {
            instance = new StrongAuthSettingsService(pluginId);
        }
        return instance;
    }

    public Pair<Set<String>, List<TrustedDevice>> get2FAPolicyData(String userId) {
        HashSet list = new HashSet();
        List trustedDevices = new ArrayList();
        try {
            String trustedDevicesInfo;
            PersonPreferences person = this.personPreferencesInstance(userId);
            String policy = person.getStrongAuthPolicy();
            if (Utils.isNotEmpty((String)policy)) {
                Stream.of(policy.split(",\\s*")).forEach(str -> {
                    try {
                        EnforcementPolicy.valueOf((String)str);
                        list.add(str);
                    }
                    catch (Exception e) {
                        this.logger.error("The policy '{}' is not recognized", str);
                    }
                });
            }
            if (Utils.isNotEmpty((String)person.getTrustedDevices()) && Utils.isNotEmpty((String)(trustedDevicesInfo = Utils.stringEncrypter().decrypt(person.getTrustedDevices())))) {
                trustedDevices = (List)this.mapper.readValue(trustedDevicesInfo, (TypeReference)new TypeReference<List<TrustedDevice>>(){});
                trustedDevices.forEach(TrustedDevice::sortOriginsDescending);
                TrustedDeviceComparator comparator = new TrustedDeviceComparator(true);
                trustedDevices.sort((first, second) -> comparator.compare((TrustedDevice)second, (TrustedDevice)first));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return new Pair(list, trustedDevices);
    }

    public boolean update2FAPolicies(String userId, Set<String> policies) {
        boolean updated = false;
        String str = policies.stream().reduce("", (partial, next) -> partial + ", " + next);
        try {
            PersonPreferences person = this.personPreferencesInstance(userId);
            person.setStrongAuthPolicy(str.substring(2));
            updated = this.persistenceService.modify((Object)person);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return updated;
    }

    public boolean deleteTrustedDevice(String userId, List<TrustedDevice> devices, int index) {
        boolean updated = false;
        ArrayList<TrustedDevice> copyOfDevices = new ArrayList<TrustedDevice>(devices);
        try {
            copyOfDevices.remove(index);
            String updatedJson = Utils.stringEncrypter().encrypt(this.mapper.writeValueAsString(copyOfDevices));
            PersonPreferences person = this.personPreferencesInstance(userId);
            person.setTrustedDevices(updatedJson);
            if (this.persistenceService.modify((Object)person)) {
                devices.remove(index);
                updated = true;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return updated;
    }

    private PersonPreferences personPreferencesInstance(String id) {
        return (PersonPreferences)this.persistenceService.get(PersonPreferences.class, this.persistenceService.getPersonDn(id));
    }
}

