/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.strongauthn;

import io.jans.casa.conf.Basic2FASettings;
import io.jans.casa.core.ITrackable;
import io.jans.casa.plugins.strongauthn.conf.Configuration;
import io.jans.casa.plugins.strongauthn.conf.EnforcementPolicy;
import io.jans.casa.plugins.strongauthn.service.StrongAuthSettingsService;
import io.jans.casa.plugins.strongauthn.service.TrustedDevicesSweeper;
import io.jans.casa.service.settings.IPluginSettingsHandler;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongAuthnSettingsPlugin
extends Plugin
implements ITrackable {
    public static final int TRUSTED_DEVICE_EXPIRATION_DAYS = 30;
    public static final int TRUSTED_LOCATION_EXPIRATION_DAYS = 15;
    private static final int ONE_DAY = (int)TimeUnit.DAYS.toSeconds(1L);
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IPluginSettingsHandler<Configuration> settingsHandler;
    private Scheduler scheduler;
    private JobKey jobKey;

    public StrongAuthnSettingsPlugin(PluginWrapper wrapper) throws Exception {
        super(wrapper);
        this.settingsHandler = StrongAuthSettingsService.instance(wrapper.getPluginId()).getSettingsHandler();
        this.scheduler = StdSchedulerFactory.getDefaultScheduler();
    }

    public void start() {
        if (this.settingsHandler.getSettings() == null) {
            try {
                this.logger.info("Initializing missing 2FA settings");
                Configuration conf = new Configuration();
                conf.setBasic2FASettings(new Basic2FASettings());
                conf.setEnforcement2FA(Collections.singletonList(EnforcementPolicy.EVERY_LOGIN));
                this.settingsHandler.setSettings((Object)conf);
                this.settingsHandler.save();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.jobKey = this.initTimer(10);
    }

    public void stop() {
        try {
            if (this.jobKey != null) {
                this.logger.info("Removing trusted devices sweeper job");
                this.scheduler.deleteJob(this.jobKey);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void delete() {
        try {
            this.logger.warn("Flushing strong authentication settings...");
            this.settingsHandler.setSettings(null);
            this.settingsHandler.save();
            this.logger.info("Done.");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private JobKey initTimer(int gap) {
        try {
            if (!this.scheduler.isStarted()) {
                this.scheduler.start();
            }
            Class<TrustedDevicesSweeper> cls = TrustedDevicesSweeper.class;
            String name = cls.getSimpleName();
            String group = ((Object)((Object)this)).getClass().getSimpleName();
            this.logger.info("Scheduling timer {}", (Object)name);
            JobDetail job = JobBuilder.newJob(cls).withIdentity("job_" + name, group).build();
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + name, group).startAt(new Date(System.currentTimeMillis() + (long)(gap * 1000))).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(ONE_DAY).repeatForever()).build();
            this.scheduler.scheduleJob(job, (Trigger)trigger);
            return job.getKey();
        }
        catch (SchedulerException e) {
            this.logger.warn("Device sweeping won't be available");
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

