/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.strongauthn.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.casa.core.model.PersonPreferences;
import io.jans.casa.misc.Utils;
import io.jans.casa.plugins.strongauthn.conf.Configuration;
import io.jans.casa.plugins.strongauthn.conf.TrustedDevicesSettings;
import io.jans.casa.plugins.strongauthn.model.TrustedDevice;
import io.jans.casa.plugins.strongauthn.model.TrustedOrigin;
import io.jans.casa.plugins.strongauthn.service.StrongAuthSettingsService;
import io.jans.casa.service.IPersistenceService;
import io.jans.orm.search.filter.Filter;
import io.jans.service.cache.CacheInterface;
import io.jans.util.security.StringEncrypter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedDevicesSweeper
implements Job {
    private static final int QUASI_DAY = (int)(TimeUnit.DAYS.toSeconds(1L) - TimeUnit.HOURS.toSeconds(1L));
    private final String ACTIVE_INSTANCE_PRESENCE = this.getClass().getName() + "_activeInstanceSet";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPersistenceService persistenceService;
    private StringEncrypter stringEncrypter;
    private CacheInterface storeService;
    private long locationExpiration;
    private long deviceExpiration;
    private ObjectMapper mapper;

    public TrustedDevicesSweeper() {
        Configuration settings = (Configuration)StrongAuthSettingsService.instance().getSettingsHandler().getSettings();
        Optional<TrustedDevicesSettings> tsettings = Optional.ofNullable(settings.getTrustedDevicesSettings());
        this.locationExpiration = TimeUnit.DAYS.toMillis(tsettings.map(TrustedDevicesSettings::getLocationExpirationDays).orElse(15).intValue());
        this.deviceExpiration = TimeUnit.DAYS.toMillis(tsettings.map(TrustedDevicesSettings::getDeviceExpirationDays).orElse(30).intValue());
        try {
            this.mapper = new ObjectMapper();
            this.persistenceService = (IPersistenceService)Utils.managedBean(IPersistenceService.class);
            this.storeService = (CacheInterface)Utils.managedBean(CacheInterface.class);
            this.stringEncrypter = Utils.stringEncrypter();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.warn("Device sweeping will not be available");
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.stringEncrypter == null) {
            return;
        }
        if (this.storeService.get(this.ACTIVE_INSTANCE_PRESENCE) != null) {
            return;
        }
        this.storeService.put(QUASI_DAY, this.ACTIVE_INSTANCE_PRESENCE, (Object)true);
        this.logger.info("TrustedDevicesSweeper. Running timer job");
        long now = System.currentTimeMillis();
        List<PersonPreferences> people = this.getPeopleTrustedDevices();
        for (PersonPreferences person : people) {
            String jsonStr = null;
            try {
                String trustedDevicesInfo = this.stringEncrypter.decrypt(person.getTrustedDevices());
                List list = (List)this.mapper.readValue(trustedDevicesInfo, (TypeReference)new TypeReference<List<TrustedDevice>>(){});
                if (!this.removeExpiredData(list, now)) continue;
                if (list.size() > 0) {
                    jsonStr = this.mapper.writeValueAsString((Object)list);
                    this.updateTrustedDevices(person, this.stringEncrypter.encrypt(jsonStr));
                    continue;
                }
                this.updateTrustedDevices(person, null);
            }
            catch (Exception e) {
                if (jsonStr == null) {
                    this.updateTrustedDevices(person, null);
                }
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean removeExpiredData(List<TrustedDevice> list, long time) {
        boolean changed = false;
        ArrayList<Integer> deviceIndexes = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            TrustedDevice device = list.get(i);
            List<TrustedOrigin> origins = device.getOrigins();
            if (origins != null) {
                ArrayList<Integer> origIndexes = new ArrayList<Integer>();
                for (int j = 0; j < origins.size(); ++j) {
                    long timeStamp = origins.get(j).getTimestamp();
                    if (time - timeStamp <= this.locationExpiration) continue;
                    origIndexes.add(0, j);
                }
                origIndexes.forEach(ind -> origins.remove((int)ind));
                boolean bl = changed = origIndexes.size() > 0;
            }
            if (device.getAddedOn() <= 0L || time - device.getAddedOn() <= this.deviceExpiration) continue;
            deviceIndexes.add(0, i);
            changed = true;
        }
        deviceIndexes.forEach(ind -> list.remove((int)ind));
        return changed;
    }

    private List<PersonPreferences> getPeopleTrustedDevices() {
        List<Object> list = new ArrayList<PersonPreferences>();
        try {
            list = this.persistenceService.find(PersonPreferences.class, this.persistenceService.getPeopleDn(), Filter.createPresenceFilter((String)"jansTrustedDevices"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private void updateTrustedDevices(PersonPreferences person, String value) {
        String uid = person.getUid();
        this.logger.trace("TrustedDevicesSweeper. Cleaning expired trusted devices for user '{}'", (Object)uid);
        person.setTrustedDevices(value);
        this.persistenceService.modify((Object)person);
    }
}

