/*
 * Decompiled with CFR 0.152.
 */
package io.jans.casa.plugins.strongauthn.vm;

import io.jans.casa.conf.Basic2FASettings;
import io.jans.casa.core.pojo.User;
import io.jans.casa.misc.Utils;
import io.jans.casa.plugins.strongauthn.conf.Configuration;
import io.jans.casa.plugins.strongauthn.conf.EnforcementPolicy;
import io.jans.casa.plugins.strongauthn.conf.TrustedDevicesSettings;
import io.jans.casa.plugins.strongauthn.service.StrongAuthSettingsService;
import io.jans.casa.service.ISessionContext;
import io.jans.casa.service.settings.IPluginSettingsHandler;
import io.jans.casa.ui.UIUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.Pair;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Messagebox;

public class StrongAuthViewModel {
    private static final Pair<Integer, Integer> BOUNDS_MINCREDS_2FA = new Pair((Object)1, (Object)3);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPluginSettingsHandler<Configuration> settingsHandler;
    private Configuration settings;
    private User user;
    private int minCreds2FA;
    private List<Integer> minCredsList;
    private Set<String> enforcementPolicies;
    private int locationExpiration;
    private int deviceExpiration;
    private boolean autoEnable;
    private boolean hideSwitch;
    private boolean selectPreferred;

    public int getLocationExpiration() {
        return this.locationExpiration;
    }

    public int getDeviceExpiration() {
        return this.deviceExpiration;
    }

    public List<Integer> getMinCredsList() {
        return this.minCredsList;
    }

    public int getMinCreds2FA() {
        return this.minCreds2FA;
    }

    public Set<String> getEnforcementPolicies() {
        return this.enforcementPolicies;
    }

    public boolean isAutoEnable() {
        return this.autoEnable;
    }

    public boolean isHideSwitch() {
        return this.hideSwitch;
    }

    public boolean isSelectPreferred() {
        return this.selectPreferred;
    }

    public void setLocationExpiration(int locationExpiration) {
        this.locationExpiration = locationExpiration;
    }

    public void setDeviceExpiration(int deviceExpiration) {
        this.deviceExpiration = deviceExpiration;
    }

    public void setHideSwitch(boolean hideSwitch) {
        this.hideSwitch = hideSwitch;
    }

    public void setSelectPreferred(boolean selectPreferred) {
        this.selectPreferred = selectPreferred;
    }

    @Init
    public void init() {
        this.logger.debug("Initializing ViewModel");
        this.settingsHandler = StrongAuthSettingsService.instance().getSettingsHandler();
        this.settings = (Configuration)this.settingsHandler.getSettings();
        this.user = ((ISessionContext)Utils.managedBean(ISessionContext.class)).getLoggedUser();
        this.reloadConfig();
    }

    @NotifyChange(value={"autoEnable", "hideSwitch"})
    public void checkAutoEnable(boolean checked) {
        this.autoEnable = checked;
        if (!checked) {
            this.hideSwitch = false;
        }
    }

    @NotifyChange(value={"enforcementPolicies", "deviceExpiration", "locationExpiration"})
    public void checkPolicy(boolean checked, String policy) {
        this.logger.trace("Policy '{}' {}", (Object)policy, (Object)(checked ? "checked" : "unchecked"));
        if (checked) {
            this.enforcementPolicies.add(policy);
        } else {
            this.enforcementPolicies.remove(policy);
            if (this.settings.getTrustedDevicesSettings() != null && (EnforcementPolicy.LOCATION_UNKNOWN.toString().equals(policy) || EnforcementPolicy.CUSTOM.toString().equals(policy))) {
                this.deviceExpiration = this.settings.getTrustedDevicesSettings().getDeviceExpirationDays();
            }
            if (this.settings.getTrustedDevicesSettings() != null && (EnforcementPolicy.DEVICE_UNKNOWN.toString().equals(policy) || EnforcementPolicy.CUSTOM.toString().equals(policy))) {
                this.locationExpiration = this.settings.getTrustedDevicesSettings().getLocationExpirationDays();
            }
        }
        if (this.enforcementPolicies.contains(EnforcementPolicy.EVERY_LOGIN.toString())) {
            this.enforcementPolicies = Stream.of(EnforcementPolicy.EVERY_LOGIN.toString()).collect(Collectors.toSet());
        } else if (this.enforcementPolicies.contains(EnforcementPolicy.CUSTOM.toString())) {
            this.enforcementPolicies = Stream.of(EnforcementPolicy.CUSTOM.toString()).collect(Collectors.toSet());
        }
        this.logger.trace("Newer enforcement policies: {}", (Object)this.enforcementPolicies.toString());
    }

    public void change2FASettings(Integer val) {
        if ((val = Integer.valueOf(val + (Integer)BOUNDS_MINCREDS_2FA.getX())) == 1) {
            this.promptBefore2FAProceed(Labels.getLabel((String)"adm.strongauth_warning_one"), val);
        } else if (val > this.minCreds2FA) {
            this.promptBefore2FAProceed(Labels.getLabel((String)"adm.strongauth_warning_up", (Object[])new Integer[]{this.minCreds2FA}), val);
        } else {
            this.processUpdate(val);
        }
    }

    private void reloadConfig() {
        Optional<TrustedDevicesSettings> opt = Optional.ofNullable(this.settings.getTrustedDevicesSettings());
        this.locationExpiration = opt.map(TrustedDevicesSettings::getLocationExpirationDays).orElse(15);
        this.deviceExpiration = opt.map(TrustedDevicesSettings::getDeviceExpirationDays).orElse(30);
        Basic2FASettings b2s = this.settings.getBasic2FASettings();
        this.minCreds2FA = b2s.getMinCreds();
        this.autoEnable = b2s.isAutoEnable();
        this.hideSwitch = !b2s.isAllowSelfEnableDisable();
        this.selectPreferred = b2s.isAllowSelectPreferred();
        this.enforcementPolicies = this.settings.getEnforcement2FA().stream().map(Enum::toString).collect(Collectors.toSet());
        this.logger.trace("Minimum creds for 2FA: {}", (Object)this.minCreds2FA);
        this.logger.trace("Current enforcement policies: {}", (Object)this.enforcementPolicies.toString());
        if (this.minCredsList == null) {
            this.minCredsList = new ArrayList<Integer>();
            for (int i = ((Integer)BOUNDS_MINCREDS_2FA.getX()).intValue(); i <= (Integer)BOUNDS_MINCREDS_2FA.getY(); ++i) {
                this.minCredsList.add(i);
            }
        }
    }

    private void promptBefore2FAProceed(String message, int newval) {
        Messagebox.show((String)message, null, (int)48, (String)"z-messagebox-icon z-messagebox-exclamation", event -> {
            if ("onYes".equals(event.getName())) {
                this.processUpdate(newval);
            } else {
                this.reloadConfig();
                BindUtils.postNotifyChange((Object)this, (String[])new String[]{"minCreds2FA", "enforcementPolicies"});
            }
        });
    }

    private void processUpdate(int newval) {
        if (this.locationExpiration > 0 && this.deviceExpiration > 0) {
            this.logger.trace("Updating settings");
            this.update2FASettings(newval, this.enforcementPolicies.stream().map(EnforcementPolicy::valueOf).collect(Collectors.toList()));
            this.reloadConfig();
        } else {
            UIUtils.showMessageUI((boolean)false, (String)Labels.getLabel((String)"adm.strongauth_exp_invalid"));
        }
    }

    private void update2FASettings(int minCreds, List<EnforcementPolicy> policies) {
        TrustedDevicesSettings tsettings = new TrustedDevicesSettings();
        tsettings.setDeviceExpirationDays(Integer.valueOf(this.deviceExpiration));
        tsettings.setLocationExpirationDays(Integer.valueOf(this.locationExpiration));
        this.settings.setTrustedDevicesSettings(tsettings);
        this.settings.setEnforcement2FA(policies);
        Basic2FASettings b2s = this.settings.getBasic2FASettings();
        b2s.setMinCreds(Integer.valueOf(minCreds));
        b2s.setAutoEnable(this.autoEnable);
        b2s.setAllowSelfEnableDisable(!this.hideSwitch);
        b2s.setAllowSelectPreferred(this.selectPreferred);
        this.updateMainSettings(Labels.getLabel((String)"adm.methods_change_success"));
    }

    private boolean updateMainSettings(String sucessMessage) {
        boolean success = false;
        try {
            this.logger.info("Updating global configuration settings");
            this.settingsHandler.setSettings((Object)this.settings);
            this.settingsHandler.save();
            Messagebox.show((String)sucessMessage, null, (int)1, (String)"z-messagebox-icon z-messagebox-information");
            success = true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            UIUtils.showMessageUI((boolean)false, (String)Labels.getLabel((String)"adm.conffile_error_update"));
        }
        this.logActionDetails(Labels.getLabel((String)"adm.strongauth_action"), success);
        return success;
    }

    void logActionDetails(String action, boolean success) {
        this.logger.debug("{}: result {} - performed by user '{}'", new Object[]{action, success ? "OK" : "FAILED", this.user.getUserName()});
    }
}

