/*
 * Decompiled with CFR 0.152.
 */
package io.jans.cedarling.binding.wrapper;

import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import uniffi.cedarling_uniffi.AuthorizeException;
import uniffi.cedarling_uniffi.AuthorizeResult;
import uniffi.cedarling_uniffi.Cedarling;
import uniffi.cedarling_uniffi.CedarlingException;
import uniffi.cedarling_uniffi.EntityData;
import uniffi.cedarling_uniffi.EntityException;
import uniffi.cedarling_uniffi.LogException;
import uniffi.cedarling_uniffi.MultiIssuerAuthorizeResult;
import uniffi.cedarling_uniffi.TokenInput;

public class CedarlingAdapter
implements AutoCloseable {
    Cedarling cedarling;

    public void loadFromJson(String bootstrapConfigJson) throws CedarlingException {
        this.cedarling = Cedarling.Companion.loadFromJson(bootstrapConfigJson);
    }

    public void loadFromFile(String path) throws CedarlingException {
        this.cedarling = Cedarling.Companion.loadFromFile(path);
    }

    public AuthorizeResult authorize(Map<String, String> tokens, String action, JSONObject resource, JSONObject context) throws AuthorizeException, EntityException {
        EntityData resourceObj = EntityData.Companion.fromJson(resource.toString());
        return this.cedarling.authorize(tokens, action, resourceObj, context.toString());
    }

    public AuthorizeResult authorizeUnsigned(List<EntityData> principals, String action, JSONObject resource, JSONObject context) throws AuthorizeException, EntityException {
        EntityData resourceObj = EntityData.Companion.fromJson(resource.toString());
        return this.cedarling.authorizeUnsigned(principals, action, resourceObj, context.toString());
    }

    public MultiIssuerAuthorizeResult authorizeMultiIssuer(List<TokenInput> tokens, String action, JSONObject resource, JSONObject context) throws AuthorizeException, EntityException {
        EntityData resourceObj = EntityData.Companion.fromJson(resource.toString());
        String contextStr = context != null ? context.toString() : null;
        return this.cedarling.authorizeMultiIssuer(tokens, action, resourceObj, contextStr);
    }

    public String getLogById(String id) throws LogException {
        return this.cedarling.getLogById(id);
    }

    public List<String> getLogIds() {
        return this.cedarling.getLogIds();
    }

    public List<String> getLogsByRequestId(String requestId) throws LogException {
        return this.cedarling.getLogsByRequestId(requestId);
    }

    public List<String> getLogsByRequestIdAndTag(String requestId, String tag) throws LogException {
        return this.cedarling.getLogsByRequestIdAndTag(requestId, tag);
    }

    public List<String> getLogsByTag(String tag) throws LogException {
        return this.cedarling.getLogsByTag(tag);
    }

    public List<String> popLogs() throws LogException {
        return this.cedarling.popLogs();
    }

    @Override
    public void close() {
        this.cedarling.close();
    }

    public Cedarling getCedarling() {
        return this.cedarling;
    }
}

