/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.ClientAssertionType;
import io.jans.as.model.util.QueryBuilder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class ClientAuthnRequest
extends BaseRequest {
    private static final Logger LOG = Logger.getLogger(ClientAuthnRequest.class);
    private SignatureAlgorithm algorithm;
    private String sharedKey;
    private String audience;
    private AbstractCryptoProvider cryptoProvider;
    private String keyId;

    public AbstractCryptoProvider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(SignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public void appendClientAuthnToQuery(QueryBuilder builder) {
        if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            builder.append("client_id", this.getAuthUsername());
            builder.append("client_secret", this.getAuthPassword());
        } else if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || this.getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            builder.append("client_assertion_type", ClientAssertionType.JWT_BEARER.toString());
            builder.append("client_assertion", this.getClientAssertion());
        }
    }

    public SignatureAlgorithm getFallbackAlgorithm() {
        return StringUtils.isBlank((CharSequence)this.keyId) ? SignatureAlgorithm.HS256 : SignatureAlgorithm.RS256;
    }

    public String getClientAssertion() {
        if (this.cryptoProvider == null) {
            LOG.error((Object)"Crypto provider is not specified");
            return null;
        }
        if (this.algorithm == null) {
            this.algorithm = this.getFallbackAlgorithm();
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        Date issuedAt = calendar.getTime();
        calendar.add(12, 5);
        Date expirationTime = calendar.getTime();
        Jwt clientAssertion = new Jwt();
        clientAssertion.getHeader().setType(JwtType.JWT);
        clientAssertion.getHeader().setAlgorithm(this.algorithm);
        if (StringUtils.isNotBlank((CharSequence)this.keyId)) {
            clientAssertion.getHeader().setKeyId(this.keyId);
        }
        clientAssertion.getClaims().setIssuer(this.getAuthUsername());
        clientAssertion.getClaims().setSubjectIdentifier(this.getAuthUsername());
        clientAssertion.getClaims().setAudience(this.audience);
        clientAssertion.getClaims().setJwtId(UUID.randomUUID());
        clientAssertion.getClaims().setExpirationTime(expirationTime);
        clientAssertion.getClaims().setIssuedAt(issuedAt);
        try {
            if (this.sharedKey == null) {
                this.sharedKey = this.getAuthPassword();
            }
            String signature = this.cryptoProvider.sign(clientAssertion.getSigningInput(), this.keyId, this.sharedKey, this.algorithm);
            clientAssertion.setEncodedSignature(signature);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return clientAssertion.toString();
    }
}

