/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenIdConfigurationResponse
extends BaseResponse
implements Serializable {
    private String issuer;
    private String authorizationEndpoint;
    private String authorizationChallengeEndpoint;
    private String statusListEndpoint;
    private String accessEvaluationV1Endpoint;
    private String tokenEndpoint;
    private String revocationEndpoint;
    private String sessionRevocationEndpoint;
    private String globalTokenRevocationEndpoint;
    private String userInfoEndpoint;
    private String clientInfoEndpoint;
    private String checkSessionIFrame;
    private String endSessionEndpoint;
    private String jwksUri;
    private String archivedJwksUri;
    private String registrationEndpoint;
    private String introspectionEndpoint;
    private String parEndpoint;
    private Boolean requirePar;
    private String deviceAuthzEndpoint;
    private List<String> scopesSupported;
    private List<String> responseTypesSupported;
    private List<String> responseModesSupported;
    private List<String> promptValuesSupported;
    private List<String> grantTypesSupported;
    private List<String> acrValuesSupported;
    private List<String> authorizationDetailsTypesSupported;
    private List<String> subjectTypesSupported;
    private List<String> authorizationSigningAlgValuesSupported;
    private List<String> authorizationEncryptionAlgValuesSupported;
    private List<String> authorizationEncryptionEncValuesSupported;
    private List<String> userInfoSigningAlgValuesSupported;
    private List<String> userInfoEncryptionAlgValuesSupported;
    private List<String> userInfoEncryptionEncValuesSupported;
    private List<String> idTokenSigningAlgValuesSupported;
    private List<String> idTokenEncryptionAlgValuesSupported;
    private List<String> idTokenEncryptionEncValuesSupported;
    private List<String> accessTokenSigningAlgValuesSupported;
    private List<String> requestObjectSigningAlgValuesSupported;
    private List<String> requestObjectEncryptionAlgValuesSupported;
    private List<String> requestObjectEncryptionEncValuesSupported;
    private List<String> tokenEndpointAuthMethodsSupported;
    private List<String> tokenEndpointAuthSigningAlgValuesSupported;
    private List<String> dpopSigningAlgValuesSupported;
    private List<String> displayValuesSupported;
    private List<String> claimTypesSupported;
    private List<String> claimsSupported;
    private List<String> idTokenTokenBindingCnfValuesSupported;
    private String serviceDocumentation;
    private List<String> claimsLocalesSupported;
    private List<String> uiLocalesSupported;
    private Boolean claimsParameterSupported;
    private Boolean requestParameterSupported;
    private Boolean requestUriParameterSupported;
    private Boolean requireRequestUriRegistration;
    private Boolean tlsClientCertificateBoundAccessTokens;
    private Boolean frontChannelLogoutSupported;
    private Boolean frontChannelLogoutSessionSupported;
    private Boolean backchannelLogoutSupported;
    private Boolean backchannelLogoutSessionSupported;
    private String opPolicyUri;
    private String opTosUri;
    private Map<String, List<String>> scopeToClaimsMapping = new HashMap<String, List<String>>();
    private Map<String, Serializable> mltsAliases = new HashMap<String, Serializable>();
    private Map<String, String> acrMappings = new HashMap<String, String>();
    private String backchannelAuthenticationEndpoint;
    private List<String> backchannelTokenDeliveryModesSupported;
    private List<String> backchannelAuthenticationRequestSigningAlgValuesSupported;
    private Boolean backchannelUserCodeParameterSupported;
    private String ssaEndpoint;

    public OpenIdConfigurationResponse() {
    }

    public OpenIdConfigurationResponse(int status) {
        super(status);
        this.scopesSupported = new ArrayList<String>();
        this.responseTypesSupported = new ArrayList<String>();
        this.responseModesSupported = new ArrayList<String>();
        this.promptValuesSupported = new ArrayList<String>();
        this.grantTypesSupported = new ArrayList<String>();
        this.acrValuesSupported = new ArrayList<String>();
        this.authorizationDetailsTypesSupported = new ArrayList<String>();
        this.subjectTypesSupported = new ArrayList<String>();
        this.authorizationSigningAlgValuesSupported = new ArrayList<String>();
        this.authorizationEncryptionAlgValuesSupported = new ArrayList<String>();
        this.authorizationEncryptionEncValuesSupported = new ArrayList<String>();
        this.userInfoSigningAlgValuesSupported = new ArrayList<String>();
        this.userInfoEncryptionAlgValuesSupported = new ArrayList<String>();
        this.userInfoEncryptionEncValuesSupported = new ArrayList<String>();
        this.idTokenSigningAlgValuesSupported = new ArrayList<String>();
        this.idTokenEncryptionAlgValuesSupported = new ArrayList<String>();
        this.idTokenEncryptionEncValuesSupported = new ArrayList<String>();
        this.accessTokenSigningAlgValuesSupported = new ArrayList<String>();
        this.requestObjectSigningAlgValuesSupported = new ArrayList<String>();
        this.requestObjectEncryptionAlgValuesSupported = new ArrayList<String>();
        this.requestObjectEncryptionEncValuesSupported = new ArrayList<String>();
        this.tokenEndpointAuthMethodsSupported = new ArrayList<String>();
        this.tokenEndpointAuthSigningAlgValuesSupported = new ArrayList<String>();
        this.dpopSigningAlgValuesSupported = new ArrayList<String>();
        this.displayValuesSupported = new ArrayList<String>();
        this.claimTypesSupported = new ArrayList<String>();
        this.claimsSupported = new ArrayList<String>();
        this.idTokenTokenBindingCnfValuesSupported = new ArrayList<String>();
        this.claimsLocalesSupported = new ArrayList<String>();
        this.uiLocalesSupported = new ArrayList<String>();
        this.backchannelTokenDeliveryModesSupported = new ArrayList<String>();
        this.backchannelAuthenticationRequestSigningAlgValuesSupported = new ArrayList<String>();
    }

    public static Map<String, List<String>> parseScopeToClaimsMapping(String scopeToClaimsJson) throws JSONException {
        return OpenIdConfigurationResponse.parseScopeToClaimsMapping(new JSONArray(scopeToClaimsJson));
    }

    public static Map<String, List<String>> parseScopeToClaimsMapping(JSONArray jsonArray) throws JSONException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                String scope = obj.names().getString(0);
                JSONArray claimsArray = obj.getJSONArray(scope);
                ArrayList<String> claimsList = new ArrayList<String>();
                for (int j = 0; j < claimsArray.length(); ++j) {
                    String claim = claimsArray.getString(j);
                    if (!StringUtils.isNotBlank((CharSequence)claim)) continue;
                    claimsList.add(claim);
                }
                map.put(scope, claimsList);
            }
        }
        return map;
    }

    public Map<String, List<String>> getScopeToClaimsMapping() {
        return this.scopeToClaimsMapping;
    }

    public void setScopeToClaimsMapping(Map<String, List<String>> scopeToClaimsMapping) {
        this.scopeToClaimsMapping = scopeToClaimsMapping;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getAuthorizationChallengeEndpoint() {
        return this.authorizationChallengeEndpoint;
    }

    public void setAuthorizationChallengeEndpoint(String authorizationChallengeEndpoint) {
        this.authorizationChallengeEndpoint = authorizationChallengeEndpoint;
    }

    public String getStatusListEndpoint() {
        return this.statusListEndpoint;
    }

    public void setStatusListEndpoint(String statusListEndpoint) {
        this.statusListEndpoint = statusListEndpoint;
    }

    public String getAccessEvaluationV1Endpoint() {
        return this.accessEvaluationV1Endpoint;
    }

    public OpenIdConfigurationResponse setAccessEvaluationV1Endpoint(String accessEvaluationV1Endpoint) {
        this.accessEvaluationV1Endpoint = accessEvaluationV1Endpoint;
        return this;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getSessionRevocationEndpoint() {
        return this.sessionRevocationEndpoint;
    }

    public void setSessionRevocationEndpoint(String sessionRevocationEndpoint) {
        this.sessionRevocationEndpoint = sessionRevocationEndpoint;
    }

    public String getGlobalTokenRevocationEndpoint() {
        return this.globalTokenRevocationEndpoint;
    }

    public void setGlobalTokenRevocationEndpoint(String globalTokenRevocationEndpoint) {
        this.globalTokenRevocationEndpoint = globalTokenRevocationEndpoint;
    }

    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getClientInfoEndpoint() {
        return this.clientInfoEndpoint;
    }

    public void setClientInfoEndpoint(String clientInfoEndpoint) {
        this.clientInfoEndpoint = clientInfoEndpoint;
    }

    public String getCheckSessionIFrame() {
        return this.checkSessionIFrame;
    }

    public void setCheckSessionIFrame(String checkSessionIFrame) {
        this.checkSessionIFrame = checkSessionIFrame;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getArchivedJwksUri() {
        return this.archivedJwksUri;
    }

    public void setArchivedJwksUri(String archivedJwksUri) {
        this.archivedJwksUri = archivedJwksUri;
    }

    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public void setRegistrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpoint(String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public String getParEndpoint() {
        return this.parEndpoint;
    }

    public void setParEndpoint(String parEndpoint) {
        this.parEndpoint = parEndpoint;
    }

    public Boolean getRequirePar() {
        return this.requirePar;
    }

    public void setRequirePar(Boolean requirePar) {
        this.requirePar = requirePar;
    }

    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public void setScopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public void setResponseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public List<String> getPromptValuesSupported() {
        return this.promptValuesSupported;
    }

    public void setPromptValuesSupported(List<String> promptValuesSupported) {
        this.promptValuesSupported = promptValuesSupported;
    }

    public List<String> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    public void setResponseModesSupported(List<String> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    public void setGrantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    public List<String> getAcrValuesSupported() {
        return this.acrValuesSupported;
    }

    public void setAcrValuesSupported(List<String> acrValuesSupported) {
        this.acrValuesSupported = acrValuesSupported;
    }

    public List<String> getAuthorizationDetailsTypesSupported() {
        return this.authorizationDetailsTypesSupported;
    }

    public void setAuthorizationDetailsTypesSupported(List<String> authorizationDetailsTypesSupported) {
        this.authorizationDetailsTypesSupported = authorizationDetailsTypesSupported;
    }

    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public List<String> getAuthorizationSigningAlgValuesSupported() {
        return this.authorizationSigningAlgValuesSupported;
    }

    public void setAuthorizationSigningAlgValuesSupported(List<String> authorizationSigningAlgValuesSupported) {
        this.authorizationSigningAlgValuesSupported = authorizationSigningAlgValuesSupported;
    }

    public List<String> getAuthorizationEncryptionAlgValuesSupported() {
        return this.authorizationEncryptionAlgValuesSupported;
    }

    public void setAuthorizationEncryptionAlgValuesSupported(List<String> authorizationEncryptionAlgValuesSupported) {
        this.authorizationEncryptionAlgValuesSupported = authorizationEncryptionAlgValuesSupported;
    }

    public List<String> getAuthorizationEncryptionEncValuesSupported() {
        return this.authorizationEncryptionEncValuesSupported;
    }

    public void setAuthorizationEncryptionEncValuesSupported(List<String> authorizationEncryptionEncValuesSupported) {
        this.authorizationEncryptionEncValuesSupported = authorizationEncryptionEncValuesSupported;
    }

    public List<String> getUserInfoSigningAlgValuesSupported() {
        return this.userInfoSigningAlgValuesSupported;
    }

    public void setUserInfoSigningAlgValuesSupported(List<String> userInfoSigningAlgValuesSupported) {
        this.userInfoSigningAlgValuesSupported = userInfoSigningAlgValuesSupported;
    }

    public List<String> getUserInfoEncryptionAlgValuesSupported() {
        return this.userInfoEncryptionAlgValuesSupported;
    }

    public void setUserInfoEncryptionAlgValuesSupported(List<String> userInfoEncryptionAlgValuesSupported) {
        this.userInfoEncryptionAlgValuesSupported = userInfoEncryptionAlgValuesSupported;
    }

    public List<String> getUserInfoEncryptionEncValuesSupported() {
        return this.userInfoEncryptionEncValuesSupported;
    }

    public void setUserInfoEncryptionEncValuesSupported(List<String> userInfoEncryptionEncValuesSupported) {
        this.userInfoEncryptionEncValuesSupported = userInfoEncryptionEncValuesSupported;
    }

    public List<String> getAccessTokenSigningAlgValuesSupported() {
        if (this.accessTokenSigningAlgValuesSupported == null) {
            this.accessTokenSigningAlgValuesSupported = new ArrayList<String>();
        }
        return this.accessTokenSigningAlgValuesSupported;
    }

    public void setAccessTokenSigningAlgValuesSupported(List<String> accessTokenSigningAlgValuesSupported) {
        this.accessTokenSigningAlgValuesSupported = accessTokenSigningAlgValuesSupported;
    }

    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    public List<String> getIdTokenEncryptionAlgValuesSupported() {
        return this.idTokenEncryptionAlgValuesSupported;
    }

    public void setIdTokenEncryptionAlgValuesSupported(List<String> idTokenEncryptionAlgValuesSupported) {
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
    }

    public List<String> getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    public void setIdTokenEncryptionEncValuesSupported(List<String> idTokenEncryptionEncValuesSupported) {
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
    }

    public List<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    public void setRequestObjectSigningAlgValuesSupported(List<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }

    public List<String> getRequestObjectEncryptionAlgValuesSupported() {
        return this.requestObjectEncryptionAlgValuesSupported;
    }

    public void setRequestObjectEncryptionAlgValuesSupported(List<String> requestObjectEncryptionAlgValuesSupported) {
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
    }

    public List<String> getRequestObjectEncryptionEncValuesSupported() {
        return this.requestObjectEncryptionEncValuesSupported;
    }

    public void setRequestObjectEncryptionEncValuesSupported(List<String> requestObjectEncryptionEncValuesSupported) {
        this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
    }

    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    public void setTokenEndpointAuthMethodsSupported(List<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    public List<String> getTokenEndpointAuthSigningAlgValuesSupported() {
        return this.tokenEndpointAuthSigningAlgValuesSupported;
    }

    public void setTokenEndpointAuthSigningAlgValuesSupported(List<String> tokenEndpointAuthSigningAlgValuesSupported) {
        this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
    }

    public List<String> getDpopSigningAlgValuesSupported() {
        return this.dpopSigningAlgValuesSupported;
    }

    public void setDpopSigningAlgValuesSupported(List<String> dpopSigningAlgValuesSupported) {
        this.dpopSigningAlgValuesSupported = dpopSigningAlgValuesSupported;
    }

    public List<String> getDisplayValuesSupported() {
        return this.displayValuesSupported;
    }

    public void setDisplayValuesSupported(List<String> displayValuesSupported) {
        this.displayValuesSupported = displayValuesSupported;
    }

    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    public void setClaimTypesSupported(List<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    public void setClaimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public List<String> getIdTokenTokenBindingCnfValuesSupported() {
        return this.idTokenTokenBindingCnfValuesSupported;
    }

    public void setIdTokenTokenBindingCnfValuesSupported(List<String> idTokenTokenBindingCnfValuesSupported) {
        this.idTokenTokenBindingCnfValuesSupported = idTokenTokenBindingCnfValuesSupported;
    }

    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public void setServiceDocumentation(String serviceDocumentation) {
        this.serviceDocumentation = serviceDocumentation;
    }

    public List<String> getClaimsLocalesSupported() {
        return this.claimsLocalesSupported;
    }

    public void setClaimsLocalesSupported(List<String> claimsLocalesSupported) {
        this.claimsLocalesSupported = claimsLocalesSupported;
    }

    public List<String> getUiLocalesSupported() {
        return this.uiLocalesSupported;
    }

    public void setUiLocalesSupported(List<String> uiLocalesSupported) {
        this.uiLocalesSupported = uiLocalesSupported;
    }

    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    public void setClaimsParameterSupported(Boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    public void setRequestParameterSupported(Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    public Boolean getRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    public void setRequestUriParameterSupported(Boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
    }

    public Boolean getRequireRequestUriRegistration() {
        return this.requireRequestUriRegistration;
    }

    public void setRequireRequestUriRegistration(Boolean requireRequestUriRegistration) {
        this.requireRequestUriRegistration = requireRequestUriRegistration;
    }

    public String getOpPolicyUri() {
        return this.opPolicyUri;
    }

    public void setOpPolicyUri(String opPolicyUri) {
        this.opPolicyUri = opPolicyUri;
    }

    public String getOpTosUri() {
        return this.opTosUri;
    }

    public void setOpTosUri(String opTosUri) {
        this.opTosUri = opTosUri;
    }

    public Boolean getFrontChannelLogoutSupported() {
        return this.frontChannelLogoutSupported;
    }

    public void setFrontChannelLogoutSupported(Boolean frontChannelLogoutSupported) {
        this.frontChannelLogoutSupported = frontChannelLogoutSupported;
    }

    public Boolean getBackchannelLogoutSupported() {
        return this.backchannelLogoutSupported;
    }

    public void setBackchannelLogoutSupported(Boolean backchannelLogoutSupported) {
        this.backchannelLogoutSupported = backchannelLogoutSupported;
    }

    public Boolean getBackchannelLogoutSessionSupported() {
        return this.backchannelLogoutSessionSupported;
    }

    public void setBackchannelLogoutSessionSupported(Boolean backchannelLogoutSessionSupported) {
        this.backchannelLogoutSessionSupported = backchannelLogoutSessionSupported;
    }

    public Boolean getTlsClientCertificateBoundAccessTokens() {
        return this.tlsClientCertificateBoundAccessTokens;
    }

    public void setTlsClientCertificateBoundAccessTokens(Boolean tlsClientCertificateBoundAccessTokens) {
        this.tlsClientCertificateBoundAccessTokens = tlsClientCertificateBoundAccessTokens;
    }

    public Boolean getFrontChannelLogoutSessionSupported() {
        return this.frontChannelLogoutSessionSupported;
    }

    public void setFrontChannelLogoutSessionSupported(Boolean frontChannelLogoutSessionSupported) {
        this.frontChannelLogoutSessionSupported = frontChannelLogoutSessionSupported;
    }

    public String getBackchannelAuthenticationEndpoint() {
        return this.backchannelAuthenticationEndpoint;
    }

    public void setBackchannelAuthenticationEndpoint(String backchannelAuthenticationEndpoint) {
        this.backchannelAuthenticationEndpoint = backchannelAuthenticationEndpoint;
    }

    public List<String> getBackchannelTokenDeliveryModesSupported() {
        return this.backchannelTokenDeliveryModesSupported;
    }

    public void setBackchannelTokenDeliveryModesSupported(List<String> backchannelTokenDeliveryModesSupported) {
        this.backchannelTokenDeliveryModesSupported = backchannelTokenDeliveryModesSupported;
    }

    public List<String> getBackchannelAuthenticationRequestSigningAlgValuesSupported() {
        return this.backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    public void setBackchannelAuthenticationRequestSigningAlgValuesSupported(List<String> backchannelAuthenticationRequestSigningAlgValuesSupported) {
        this.backchannelAuthenticationRequestSigningAlgValuesSupported = backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    public Boolean getBackchannelUserCodeParameterSupported() {
        return this.backchannelUserCodeParameterSupported;
    }

    public void setBackchannelUserCodeParameterSupported(Boolean backchannelUserCodeParameterSupported) {
        this.backchannelUserCodeParameterSupported = backchannelUserCodeParameterSupported;
    }

    public String getDeviceAuthzEndpoint() {
        return this.deviceAuthzEndpoint;
    }

    public void setDeviceAuthzEndpoint(String deviceAuthzEndpoint) {
        this.deviceAuthzEndpoint = deviceAuthzEndpoint;
    }

    public Map<String, Serializable> getMltsAliases() {
        return this.mltsAliases;
    }

    public void setMltsAliases(Map<String, Serializable> mltsAliases) {
        this.mltsAliases = mltsAliases;
    }

    public Map<String, String> getAcrMappings() {
        return this.acrMappings;
    }

    public void setAcrMappings(Map<String, String> acrMappings) {
        this.acrMappings = acrMappings;
    }

    public String getSsaEndpoint() {
        return this.ssaEndpoint;
    }

    public void setSsaEndpoint(String ssaEndpoint) {
        this.ssaEndpoint = ssaEndpoint;
    }

    public String toString() {
        return "OpenIdConfigurationResponse{issuer='" + this.issuer + "', authorizationEndpoint='" + this.authorizationEndpoint + "', authorizationChallengeEndpoint='" + this.authorizationChallengeEndpoint + "', statusListEndpoint='" + this.statusListEndpoint + "', accessEvaluationV1Endpoint='" + this.accessEvaluationV1Endpoint + "', tokenEndpoint='" + this.tokenEndpoint + "', revocationEndpoint='" + this.revocationEndpoint + "', userInfoEndpoint='" + this.userInfoEndpoint + "', clientInfoEndpoint='" + this.clientInfoEndpoint + "', checkSessionIFrame='" + this.checkSessionIFrame + "', endSessionEndpoint='" + this.endSessionEndpoint + "', jwksUri='" + this.jwksUri + "', archivedJwksUri='" + this.archivedJwksUri + "', registrationEndpoint='" + this.registrationEndpoint + "', introspectionEndpoint='" + this.introspectionEndpoint + "', deviceAuthzEndpoint='" + this.deviceAuthzEndpoint + "', scopesSupported=" + this.scopesSupported + ", responseTypesSupported=" + this.responseTypesSupported + ", responseModesSupported=" + this.responseModesSupported + ", promptValuesSupported=" + this.promptValuesSupported + ", grantTypesSupported=" + this.grantTypesSupported + ", acrValuesSupported=" + this.acrValuesSupported + ", authorizationDetailsTypesSupported=" + this.authorizationDetailsTypesSupported + ", subjectTypesSupported=" + this.subjectTypesSupported + ", authorizationSigningAlgValuesSupported=" + this.authorizationSigningAlgValuesSupported + ", authorizationEncryptionAlgValuesSupported=" + this.authorizationEncryptionAlgValuesSupported + ", authorizationEncryptionEncValuesSupported=" + this.authorizationEncryptionEncValuesSupported + ", userInfoSigningAlgValuesSupported=" + this.userInfoSigningAlgValuesSupported + ", userInfoEncryptionAlgValuesSupported=" + this.userInfoEncryptionAlgValuesSupported + ", userInfoEncryptionEncValuesSupported=" + this.userInfoEncryptionEncValuesSupported + ", idTokenSigningAlgValuesSupported=" + this.idTokenSigningAlgValuesSupported + ", idTokenEncryptionAlgValuesSupported=" + this.idTokenEncryptionAlgValuesSupported + ", idTokenEncryptionEncValuesSupported=" + this.idTokenEncryptionEncValuesSupported + ", accessTokenSigningAlgValuesSupported=" + this.accessTokenSigningAlgValuesSupported + ", requestObjectSigningAlgValuesSupported=" + this.requestObjectSigningAlgValuesSupported + ", requestObjectEncryptionAlgValuesSupported=" + this.requestObjectEncryptionAlgValuesSupported + ", requestObjectEncryptionEncValuesSupported=" + this.requestObjectEncryptionEncValuesSupported + ", tokenEndpointAuthMethodsSupported=" + this.tokenEndpointAuthMethodsSupported + ", tokenEndpointAuthSigningAlgValuesSupported=" + this.tokenEndpointAuthSigningAlgValuesSupported + ", displayValuesSupported=" + this.displayValuesSupported + ", claimTypesSupported=" + this.claimTypesSupported + ", claimsSupported=" + this.claimsSupported + ", idTokenTokenBindingCnfValuesSupported=" + this.idTokenTokenBindingCnfValuesSupported + ", serviceDocumentation='" + this.serviceDocumentation + "', claimsLocalesSupported=" + this.claimsLocalesSupported + ", uiLocalesSupported=" + this.uiLocalesSupported + ", claimsParameterSupported=" + this.claimsParameterSupported + ", requestParameterSupported=" + this.requestParameterSupported + ", requestUriParameterSupported=" + this.requestUriParameterSupported + ", tlsClientCertificateBoundAccessTokens=" + this.tlsClientCertificateBoundAccessTokens + ", frontChannelLogoutSupported=" + this.frontChannelLogoutSupported + ", frontChannelLogoutSessionSupported=" + this.frontChannelLogoutSessionSupported + ", backchannelLogoutSupported=" + this.backchannelLogoutSupported + ", backchannelLogoutSessionSupported=" + this.backchannelLogoutSessionSupported + ", requireRequestUriRegistration=" + this.requireRequestUriRegistration + ", opPolicyUri='" + this.opPolicyUri + "', opTosUri='" + this.opTosUri + "', scopeToClaimsMapping=" + this.scopeToClaimsMapping + "', backchannelAuthenticationEndpoint=" + this.backchannelAuthenticationEndpoint + "', backchannelTokenDeliveryModesSupported=" + this.backchannelTokenDeliveryModesSupported + "', backchannelAuthenticationRequestSigningAlgValuesSupported=" + this.backchannelAuthenticationRequestSigningAlgValuesSupported + "', backchannelUserCodeParameterSupported=" + this.backchannelUserCodeParameterSupported + "', mltsAliases=" + this.mltsAliases + "', acrMappings=" + this.acrMappings + "', ssaEndpoint=" + this.ssaEndpoint + "'}";
    }
}

