/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.TokenRevocationRequest;
import io.jans.as.client.TokenRevocationResponse;
import io.jans.as.model.common.TokenTypeHint;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TokenRevocationClient
extends BaseClient<TokenRevocationRequest, TokenRevocationResponse> {
    private static final Logger LOG = Logger.getLogger(TokenRevocationClient.class);

    public TokenRevocationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenRevocationResponse execTokenRevocation(String clientId, String clientSecret, String token) {
        return this.execTokenRevocation(clientId, clientSecret, token, null);
    }

    public TokenRevocationResponse execTokenRevocation(String clientId, String clientSecret, String token, TokenTypeHint tokenTypeHint) {
        this.setRequest(new TokenRevocationRequest());
        ((TokenRevocationRequest)this.getRequest()).setToken(token);
        ((TokenRevocationRequest)this.getRequest()).setTokenTypeHint(tokenTypeHint);
        ((TokenRevocationRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRevocationRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenRevocationResponse exec() {
        this.initClient();
        if (StringUtils.isNotBlank((CharSequence)((TokenRevocationRequest)this.getRequest()).getToken())) {
            this.requestForm.param("token", ((TokenRevocationRequest)this.getRequest()).getToken());
        }
        if (((TokenRevocationRequest)this.getRequest()).getTokenTypeHint() != null) {
            this.requestForm.param("token_type_hint", ((TokenRevocationRequest)this.getRequest()).getTokenTypeHint().toString());
        }
        if (((TokenRevocationRequest)this.request).getAuthUsername() != null && !((TokenRevocationRequest)this.request).getAuthUsername().isEmpty()) {
            this.requestForm.param("client_id", ((TokenRevocationRequest)this.request).getAuthUsername());
        }
        Invocation.Builder clientRequest = this.webTarget.request();
        this.applyCookies(clientRequest);
        new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.request);
        clientRequest.header("Content-Type", (Object)((TokenRevocationRequest)this.request).getContentType());
        try {
            this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
            TokenRevocationResponse tokenResponse = new TokenRevocationResponse(this.clientResponse);
            this.setResponse(tokenResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (TokenRevocationResponse)this.getResponse();
    }
}

