/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ciba.fcm;

import io.jans.as.client.BaseResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseCloudMessagingResponse
extends BaseResponse {
    private static final Logger LOG = Logger.getLogger(FirebaseCloudMessagingResponse.class);
    private Long multicastId;
    private int success;
    private int failure;
    private List<Result> results;

    public FirebaseCloudMessagingResponse(Response clientResponse) {
        super(clientResponse);
        this.setHeaders((MultivaluedMap<String, Object>)clientResponse.getMetadata());
        this.injectDataFromJson(this.entity);
    }

    public void injectDataFromJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        try {
            JSONObject jsonObj = new JSONObject(json);
            if (jsonObj.has("multicast_id")) {
                this.multicastId = jsonObj.getLong("multicast_id");
            }
            if (jsonObj.has("success")) {
                this.success = jsonObj.getInt("success");
            }
            if (jsonObj.has("failure")) {
                this.failure = jsonObj.getInt("failure");
            }
            if (jsonObj.has("results")) {
                this.results = new ArrayList<Result>();
                JSONArray resultsJsonArray = jsonObj.getJSONArray("results");
                for (int i = 0; i < resultsJsonArray.length(); ++i) {
                    JSONObject resultJsonObject = resultsJsonArray.getJSONObject(i);
                    if (!resultJsonObject.has("message_id")) continue;
                    Result result = new Result(resultJsonObject.getString("message_id"));
                    this.results.add(result);
                }
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    class Result {
        private final String messageId;

        public Result(String messageId) {
            this.messageId = messageId;
        }
    }
}

