/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.util;

import io.jans.as.client.util.TestPropFile;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.jwk.KeyOpsType;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class KeyGeneratorContext {
    private TestPropFile testPropFile;
    private AbstractCryptoProvider cryptoProvider;
    private int keyLength;
    private int expirationDays;
    private int expirationHours;
    private Calendar expiration;
    private KeyOpsType keyOpsType;

    public void calculateExpiration() {
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, this.getExpirationDays());
        ((Calendar)calendar).add(10, this.getExpirationHours());
        this.expiration = calendar;
    }

    public long getExpirationForKeyOpsType(KeyOpsType keyOpsType) {
        if (this.expiration == null) {
            this.calculateExpiration();
        }
        if (keyOpsType == KeyOpsType.SSA) {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(1, 50);
            return calendar.getTimeInMillis();
        }
        return this.expiration.getTimeInMillis();
    }

    public KeyOpsType getKeyOpsType() {
        return this.keyOpsType;
    }

    public void setKeyOpsType(KeyOpsType keyOpsType) {
        this.keyOpsType = keyOpsType;
    }

    public Calendar getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Calendar expiration) {
        this.expiration = expiration;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLength) {
        this.keyLength = keyLength;
    }

    public TestPropFile getTestPropFile() {
        return this.testPropFile;
    }

    public void setTestPropFile(TestPropFile testPropFile) {
        this.testPropFile = testPropFile;
    }

    public AbstractCryptoProvider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public int getExpirationDays() {
        return this.expirationDays;
    }

    public void setExpirationDays(int expirationDays) {
        this.expirationDays = expirationDays;
    }

    public int getExpirationHours() {
        return this.expirationHours;
    }

    public void setExpirationHours(int expirationHours) {
        this.expirationHours = expirationHours;
    }
}

