/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseResponse;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.TokenType;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.model.util.QueryStringDecoder;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationResponse
extends BaseResponse {
    private static final Logger LOG = Logger.getLogger(AuthorizationResponse.class);
    private String code;
    private String accessToken;
    private TokenType tokenType;
    private Integer expiresIn;
    private String scope;
    private String idToken;
    private String state;
    private String sessionId;
    private String logoutStatusJwt;
    private String sid;
    private String deviceSecret;
    private Map<String, String> customParams;
    private ResponseMode responseMode;
    protected String response;
    protected String issuer;
    protected String audience;
    protected Integer exp;
    private AuthorizeErrorResponseType errorType;
    private String errorTypeString;
    private String errorDescription;
    private String errorUri;
    private String sharedKey;
    private PrivateKey privateKey;
    private String jwksUri;

    public AuthorizationResponse(Response clientResponse) {
        super(clientResponse);
        this.customParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)this.entity)) {
            try {
                JSONObject jsonObj = new JSONObject(this.entity);
                if (jsonObj.has("error")) {
                    this.errorTypeString = jsonObj.getString("error");
                    this.errorType = AuthorizeErrorResponseType.fromString((String)this.errorTypeString);
                }
                if (jsonObj.has("error_description")) {
                    this.errorDescription = jsonObj.getString("error_description");
                }
                if (jsonObj.has("error_uri")) {
                    this.errorUri = jsonObj.getString("error_uri");
                }
                if (jsonObj.has("state")) {
                    this.state = jsonObj.getString("state");
                }
                if (jsonObj.has("redirect")) {
                    this.location = jsonObj.getString("redirect");
                }
                if (jsonObj.has("authorization_code")) {
                    this.code = jsonObj.getString("authorization_code");
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.processLocation();
    }

    public AuthorizationResponse(String location) {
        this.location = location;
        this.customParams = new HashMap<String, String>();
        this.processLocation();
    }

    public AuthorizationResponse(String location, String sharedKey, PrivateKey privateKey, String jwksUri) {
        this.location = location;
        this.sharedKey = sharedKey;
        this.privateKey = privateKey;
        this.jwksUri = jwksUri;
        this.customParams = new HashMap<String, String>();
        this.processLocation();
    }

    private void processLocation() {
        block12: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)this.location)) break block12;
                Map params = null;
                int fragmentIndex = this.location.indexOf("#");
                if (fragmentIndex != -1) {
                    String fragment = this.location.substring(fragmentIndex + 1);
                    params = QueryStringDecoder.decode((String)fragment);
                    this.responseMode = params.containsKey("response") ? ResponseMode.FRAGMENT_JWT : ResponseMode.FRAGMENT;
                } else {
                    int queryStringIndex = this.location.indexOf("?");
                    if (queryStringIndex != -1) {
                        String queryString = this.location.substring(queryStringIndex + 1);
                        params = QueryStringDecoder.decode((String)queryString);
                        this.responseMode = params.containsKey("response") ? ResponseMode.QUERY_JWT : ResponseMode.QUERY;
                    }
                }
                if (params == null) break block12;
                if (params.containsKey("response")) {
                    this.response = (String)params.get("response");
                    params.remove("response");
                    String[] jwtParts = this.response.split("\\.");
                    if (jwtParts.length == 5) {
                        byte[] sharedSymmetricKey = this.sharedKey != null ? this.sharedKey.getBytes(StandardCharsets.UTF_8) : null;
                        Jwe jwe = Jwe.parse((String)this.response, (PrivateKey)this.privateKey, (byte[])sharedSymmetricKey);
                        if (jwe != null) {
                            for (Map.Entry entry : jwe.getClaims().toMap().entrySet()) {
                                params.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                            }
                        }
                    } else {
                        AuthCryptoProvider cryptoProvider = new AuthCryptoProvider();
                        Jwt jwt = Jwt.parse((String)this.response);
                        boolean signatureVerified = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), JwtUtil.getJSONWebKeys((String)this.jwksUri), this.sharedKey, jwt.getHeader().getSignatureAlgorithm());
                        if (signatureVerified) {
                            for (Map.Entry entry : jwt.getClaims().toMap().entrySet()) {
                                params.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
                            }
                        }
                    }
                }
                this.loadParams(params);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void loadParams(Map<String, String> params) throws UnsupportedEncodingException {
        if (params.containsKey("code")) {
            this.code = params.get("code");
            params.remove("code");
        }
        if (params.containsKey("session_id")) {
            this.sessionId = params.get("session_id");
            params.remove("session_id");
        }
        if (params.containsKey("logout_status_jwt")) {
            this.logoutStatusJwt = params.get("logout_status_jwt");
            params.remove("logout_status_jwt");
        }
        if (params.containsKey("sid")) {
            this.sid = params.get("sid");
            params.remove("sid");
        }
        if (params.containsKey("device_secret")) {
            this.deviceSecret = params.get("device_secret");
            params.remove("device_secret");
        }
        if (params.containsKey("access_token")) {
            this.accessToken = params.get("access_token");
            params.remove("access_token");
        }
        if (params.containsKey("token_type")) {
            this.tokenType = TokenType.fromString((String)params.get("token_type"));
            params.remove("token_type");
        }
        if (params.containsKey("expires_in")) {
            this.expiresIn = Integer.parseInt(params.get("expires_in"));
            params.remove("expires_in");
        }
        if (params.containsKey("scope")) {
            this.scope = URLDecoder.decode(params.get("scope"), "UTF-8");
            params.remove("scope");
        }
        if (params.containsKey("id_token")) {
            this.idToken = params.get("id_token");
            params.remove("id_token");
        }
        if (params.containsKey("state")) {
            this.state = params.get("state");
            params.remove("state");
        }
        if (params.containsKey("iss")) {
            this.issuer = params.get("iss");
            params.remove("iss");
        }
        if (params.containsKey("aud")) {
            this.audience = params.get("aud");
            params.remove("aud");
        }
        if (params.containsKey("exp")) {
            this.exp = Integer.parseInt(params.get("exp"));
        }
        if (params.containsKey("error")) {
            this.errorType = AuthorizeErrorResponseType.fromString((String)params.get("error"));
            params.remove("error");
        }
        if (params.containsKey("error_description")) {
            this.errorDescription = URLDecoder.decode(params.get("error_description"), "UTF-8");
            params.remove("error_description");
        }
        if (params.containsKey("error_uri")) {
            this.errorUri = URLDecoder.decode(params.get("error_uri"), "UTF-8");
            params.remove("error_uri");
        }
        for (String key : params.keySet()) {
            this.getCustomParams().put(key, params.get(key));
        }
    }

    public String getErrorTypeString() {
        return this.errorTypeString;
    }

    public void setErrorTypeString(String errorTypeString) {
        this.errorTypeString = errorTypeString;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getDeviceSecret() {
        return this.deviceSecret;
    }

    public void setDeviceSecret(String deviceSecret) {
        this.deviceSecret = deviceSecret;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getLogoutStatusJwt() {
        return this.logoutStatusJwt;
    }

    public AuthorizationResponse setLogoutStatusJwt(String logoutStatusJwt) {
        this.logoutStatusJwt = logoutStatusJwt;
        return this;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public Integer getExp() {
        return this.exp;
    }

    public void setExp(Integer exp) {
        this.exp = exp;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AuthorizeErrorResponseType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(AuthorizeErrorResponseType errorType) {
        this.errorType = errorType;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }
}

