/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.UserInfoRequest;
import io.jans.as.client.UserInfoResponse;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.common.AuthorizationMethod;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.util.JwtUtil;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfoClient
extends BaseClient<UserInfoRequest, UserInfoResponse> {
    private static final Logger LOG = Logger.getLogger(UserInfoClient.class);
    private String sharedKey;
    private PrivateKey privateKey;
    private String jwksUri;

    public UserInfoClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (((UserInfoRequest)this.request).getAuthorizationMethod() == null || ((UserInfoRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((UserInfoRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
            return "GET";
        }
        return "POST";
    }

    public UserInfoResponse execUserInfo(String accessToken) {
        this.setRequest(new UserInfoRequest(accessToken));
        return this.exec();
    }

    public UserInfoResponse exec() {
        this.initClient();
        Invocation.Builder clientRequest = this.prepareAuthorizatedClientRequest(((UserInfoRequest)this.getRequest()).getAuthorizationMethod(), ((UserInfoRequest)this.getRequest()).getAccessToken());
        try {
            if (((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.URL_QUERY_PARAMETER) {
                this.clientResponse = clientRequest.buildGet().invoke();
            } else if (((UserInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
            }
            this.setResponse(new UserInfoResponse(this.clientResponse));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Status code: " + this.clientResponse.getStatus()));
            }
            ((UserInfoResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            this.parseEntity(((UserInfoResponse)this.getResponse()).getEntity());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (UserInfoResponse)this.getResponse();
    }

    private void parseEntity(String entity) throws Exception {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return;
        }
        List contentType = (List)this.clientResponse.getHeaders().get((Object)"Content-Type");
        if (LOG.isDebugEnabled()) {
            if (contentType != null) {
                LOG.debug((Object)("Content types: " + contentType));
            }
            if (entity != null) {
                LOG.debug((Object)("Content in HEX: " + Hex.encodeHexString((byte[])entity.getBytes())));
            }
        }
        if (contentType != null && contentType.contains("application/jwt")) {
            String[] jwtParts = entity.split("\\.");
            if (jwtParts.length == 5) {
                byte[] sharedSymmetricKey = this.sharedKey != null ? this.sharedKey.getBytes(StandardCharsets.UTF_8) : null;
                Jwe jwe = Jwe.parse((String)entity, (PrivateKey)this.privateKey, (byte[])sharedSymmetricKey);
                ((UserInfoResponse)this.getResponse()).getClaimMap().putAll(jwe.getClaims().toMap());
            } else {
                this.parseJwt(entity);
            }
        } else {
            this.parseJson(entity);
        }
    }

    private void parseJwt(String entity) throws Exception {
        Jwt jwt = Jwt.parseSilently((String)entity);
        if (jwt == null) {
            return;
        }
        AuthCryptoProvider cryptoProvider = new AuthCryptoProvider();
        boolean signatureVerified = cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), JwtUtil.getJSONWebKeys((String)this.jwksUri), this.sharedKey, jwt.getHeader().getSignatureAlgorithm());
        if (signatureVerified) {
            ((UserInfoResponse)this.getResponse()).getClaimMap().putAll(jwt.getClaims().toMap());
        }
    }

    private void parseJson(String entity) {
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Iterator iterator = jsonObj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                ((UserInfoResponse)this.getResponse()).getClaimMap().put(key, ClientUtil.extractListByKeyOptString(jsonObj, key));
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }
}

