/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ssa.create;

import io.jans.as.client.BaseResponseWithErrors;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.model.ssa.SsaRequestParam;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SsaCreateResponse
extends BaseResponseWithErrors<SsaErrorResponseType> {
    private static final Logger LOG = Logger.getLogger(SsaCreateResponse.class);
    private String ssa;
    private String jti;

    public SsaCreateResponse() {
    }

    public SsaCreateResponse(Response clientResponse) {
        super(clientResponse);
    }

    @Override
    public SsaErrorResponseType fromString(String p_str) {
        return SsaErrorResponseType.fromString((String)p_str);
    }

    public void injectDataFromJson() {
        this.injectDataFromJson(this.entity);
    }

    @Override
    public void injectDataFromJson(String json) {
        if (StringUtils.isNotBlank((CharSequence)this.entity)) {
            try {
                JSONObject jsonObj = new JSONObject(this.entity);
                if (jsonObj.has(SsaRequestParam.SSA.getName())) {
                    JwtClaims jwtClaims;
                    this.ssa = jsonObj.getString(SsaRequestParam.SSA.getName());
                    if (StringUtils.isNotBlank((CharSequence)this.ssa) && (jwtClaims = Objects.requireNonNull(Jwt.parseSilently((String)this.ssa)).getClaims()).hasClaim(SsaRequestParam.JTI.getName())) {
                        this.jti = jwtClaims.getClaimAsString(SsaRequestParam.JTI.getName());
                    }
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getSsa() {
        return this.ssa;
    }

    public void setSsa(String ssa) {
        this.ssa = ssa;
    }

    public String getJti() {
        return this.jti;
    }

    public void setJti(String jti) {
        this.jti = jti;
    }
}

