/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.client.AccessEvaluationClientRequest;
import io.jans.as.client.AccessEvaluationClientResponse;
import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import org.apache.log4j.Logger;

public class AccessEvaluationClient
extends BaseClient<AccessEvaluationClientRequest, AccessEvaluationClientResponse> {
    private static final Logger LOG = Logger.getLogger(AccessEvaluationClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public AccessEvaluationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public AccessEvaluationClientResponse exec(AccessEvaluationClientRequest request) {
        this.setRequest(request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessEvaluationClientResponse exec() {
        this.initClient();
        Invocation.Builder clientRequest = this.webTarget.request();
        new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.request);
        clientRequest.header("Content-Type", (Object)((AccessEvaluationClientRequest)this.request).getContentType());
        try {
            String jsonString = MAPPER.writeValueAsString((Object)((AccessEvaluationClientRequest)this.request).getRequest());
            this.clientResponse = clientRequest.buildPost(Entity.json((Object)jsonString)).invoke();
            AccessEvaluationClientResponse response = new AccessEvaluationClientResponse(this.clientResponse);
            this.setResponse(response);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (AccessEvaluationClientResponse)this.getResponse();
    }
}

