/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseResponseWithErrors;
import io.jans.as.model.ciba.BackchannelAuthenticationErrorResponseType;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class BackchannelAuthenticationResponse
extends BaseResponseWithErrors<BackchannelAuthenticationErrorResponseType> {
    private static final Logger LOG = Logger.getLogger(BackchannelAuthenticationResponse.class);
    private String authReqId;
    private Integer expiresIn;
    private Integer interval;

    public BackchannelAuthenticationResponse() {
    }

    public BackchannelAuthenticationResponse(Response clientResponse) {
        super(clientResponse);
    }

    @Override
    public BackchannelAuthenticationErrorResponseType fromString(String p_str) {
        return BackchannelAuthenticationErrorResponseType.fromString((String)p_str);
    }

    public void injectDataFromJson() {
        this.injectDataFromJson(this.entity);
    }

    @Override
    public void injectDataFromJson(String json) {
        if (StringUtils.isNotBlank((CharSequence)this.entity)) {
            try {
                JSONObject jsonObj = new JSONObject(this.entity);
                if (jsonObj.has("auth_req_id")) {
                    this.setAuthReqId(jsonObj.getString("auth_req_id"));
                }
                if (jsonObj.has("expires_in")) {
                    this.setExpiresIn(jsonObj.getInt("expires_in"));
                }
                if (jsonObj.has("interval")) {
                    this.setInterval(jsonObj.getInt("interval"));
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }
}

