/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.AuthorizationRequest;
import io.jans.as.client.BaseRequest;
import io.jans.as.client.BaseResponse;
import io.jans.as.client.IsJsonRequest;
import io.jans.as.client.RegisterRequest;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.UserInfoRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.AuthorizationMethod;
import io.jans.as.model.common.HasParamName;
import io.jans.as.model.util.Util;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.plugins.interceptors.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;

public abstract class BaseClient<T extends BaseRequest, V extends BaseResponse> {
    private static final Logger LOG = Logger.getLogger(BaseClient.class);
    private String url;
    protected T request;
    protected V response;
    protected ResteasyClient resteasyClient = null;
    protected WebTarget webTarget = null;
    protected Form requestForm = new Form();
    protected Response clientResponse = null;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers = new HashMap<String, String>();
    protected ClientHttpEngine executor = null;

    protected BaseClient() {
    }

    protected BaseClient(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }

    public V getResponse() {
        return this.response;
    }

    public void setResponse(V response) {
        this.response = response;
    }

    public ClientHttpEngine getExecutor() {
        return this.executor;
    }

    public void setExecutor(ClientHttpEngine executor) {
        this.executor = executor;
    }

    protected void addReqParam(String key, HasParamName value) {
        if (value != null) {
            this.addReqParam(key, value.getParamName());
        }
    }

    protected void addReqParam(String key, String value) {
        if (Util.allNotBlank((String[])new String[]{key, value})) {
            if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
                this.requestForm.param(key, value);
            } else {
                this.webTarget = this.webTarget.queryParam(key, new Object[]{value});
            }
        }
    }

    public String getRequestAsString() {
        StringBuilder sb = new StringBuilder();
        try {
            URL theUrl = new URL(this.url);
            if (this.getHttpMethod().equals("POST") || this.getHttpMethod().equals("PUT") || this.getHttpMethod().equals("DELETE")) {
                sb.append(this.getHttpMethod()).append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (StringUtils.isNotBlank((CharSequence)((BaseRequest)this.request).getContentType())) {
                    sb.append("\n");
                    sb.append("Content-Type: ").append(((BaseRequest)this.request).getContentType());
                }
                if (StringUtils.isNotBlank((CharSequence)((BaseRequest)this.request).getMediaType())) {
                    sb.append("\n");
                    sb.append("Accept: ").append(((BaseRequest)this.request).getMediaType());
                }
                this.appendDpopHeader(sb);
                this.appendNoRedirectHeader(sb);
                if (((BaseRequest)this.request).getAuthorizationMethod() == null) {
                    if ((((BaseRequest)this.request).getAuthenticationMethod() == null || ((BaseRequest)this.request).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC) && ((BaseRequest)this.request).hasCredentials()) {
                        String encodedCredentials = ((BaseRequest)this.request).getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    }
                } else if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD && this.request instanceof UserInfoRequest) {
                    String accessToken = ((UserInfoRequest)this.request).getAccessToken();
                    sb.append("\n");
                    sb.append("Authorization: Bearer ").append(accessToken);
                }
                sb.append("\n");
                sb.append("\n");
                if (this.request instanceof RegisterRequest && ((RegisterRequest)this.request).hasJwtRequestAsString()) {
                    sb.append(((RegisterRequest)this.request).getJwtRequestAsString());
                } else if (this.request instanceof IsJsonRequest) {
                    sb.append(((IsJsonRequest)this.request).asJson());
                } else {
                    sb.append(((BaseRequest)this.request).getQueryString());
                }
            } else if (this.getHttpMethod().equals("GET")) {
                sb.append(this.getHttpMethod()).append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                if (StringUtils.isNotBlank((CharSequence)((BaseRequest)this.request).getQueryString())) {
                    sb.append("?").append(((BaseRequest)this.request).getQueryString());
                }
                sb.append(" HTTP/1.1");
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                if (StringUtils.isNotBlank((CharSequence)((BaseRequest)this.request).getContentType())) {
                    sb.append("\n");
                    sb.append("Content-Type: ").append(((BaseRequest)this.request).getContentType());
                }
                this.appendDpopHeader(sb);
                this.appendNoRedirectHeader(sb);
                if (((BaseRequest)this.request).getAuthorizationMethod() == null) {
                    if (((BaseRequest)this.request).hasCredentials()) {
                        String encodedCredentials = ((BaseRequest)this.request).getEncodedCredentials();
                        sb.append("\n");
                        sb.append("Authorization: Basic ").append(encodedCredentials);
                    } else if (this.request instanceof RegisterRequest) {
                        RegisterRequest r = (RegisterRequest)this.request;
                        String registrationAccessToken = r.getRegistrationAccessToken();
                        sb.append("\n");
                        sb.append("Authorization: Bearer ").append(registrationAccessToken);
                    }
                } else if (((BaseRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD && this.request instanceof UserInfoRequest) {
                    String accessToken = ((UserInfoRequest)this.request).getAccessToken();
                    sb.append("\n");
                    sb.append("Authorization: Bearer ").append(accessToken);
                }
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    private void appendDpopHeader(StringBuilder sb) {
        TokenRequest tokenRequest;
        if (this.request instanceof TokenRequest && (tokenRequest = (TokenRequest)this.request).getDpop() != null) {
            sb.append("\n");
            sb.append("DPoP: ").append(tokenRequest.getDpop().toString());
        }
    }

    private void appendNoRedirectHeader(StringBuilder sb) {
        AuthorizationRequest authorizationRequest;
        if (this.request instanceof AuthorizationRequest && (authorizationRequest = (AuthorizationRequest)this.request).isUseNoRedirectHeader()) {
            sb.append("\n");
            sb.append("X-Gluu-NoRedirect: true");
        }
    }

    public String getResponseAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.response != null) {
            sb.append("HTTP/1.1 ").append(((BaseResponse)this.response).getStatus());
            if (((BaseResponse)this.response).getHeaders() != null) {
                for (String key : ((BaseResponse)this.response).getHeaders().keySet()) {
                    sb.append("\n").append(key).append(": ").append(((List)((BaseResponse)this.response).getHeaders().get((Object)key)).get(0));
                }
            }
            if (((BaseResponse)this.response).getEntity() != null) {
                sb.append("\n");
                sb.append("\n");
                sb.append(((BaseResponse)this.response).getEntity());
            }
        }
        return sb.toString();
    }

    protected void initClient() {
        this.resteasyClient = this.executor == null ? (ResteasyClient)ClientBuilder.newClient() : ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(this.executor).build();
        ((Client)((Client)this.resteasyClient.register(AcceptEncodingGZIPFilter.class)).register(GZIPDecodingInterceptor.class)).register(GZIPEncodingInterceptor.class);
        this.webTarget = this.resteasyClient.target(this.getUrl());
    }

    protected void applyCookies(Invocation.Builder clientRequest) {
        for (Cookie cookie : this.cookies) {
            clientRequest.cookie(cookie);
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            clientRequest.header((String)entry.getKey(), entry.getValue());
        }
    }

    public void closeConnection() {
        try {
            if (this.clientResponse != null) {
                this.clientResponse.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public abstract String getHttpMethod();

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    protected Invocation.Builder prepareAuthorizatedClientRequest(AuthorizationMethod authorizationMethod, String accessToken) {
        Invocation.Builder clientRequest = null;
        if (authorizationMethod == null || authorizationMethod == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD) {
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                clientRequest = this.webTarget.request();
                clientRequest.header("Authorization", (Object)("Bearer " + accessToken));
            }
        } else if (authorizationMethod == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                this.requestForm.param("access_token", accessToken);
            }
        } else if (authorizationMethod == AuthorizationMethod.URL_QUERY_PARAMETER && StringUtils.isNotBlank((CharSequence)accessToken)) {
            this.addReqParam("access_token", accessToken);
        }
        if (clientRequest == null) {
            clientRequest = this.webTarget.request();
        }
        clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        return clientRequest;
    }
}

