/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseResponse;
import io.jans.as.model.error.IErrorType;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseResponseWithErrors<T extends IErrorType>
extends BaseResponse {
    private T errorType;
    private String errorDescription;
    private String errorUri;
    private Map<String, List<String>> claimMap;

    protected BaseResponseWithErrors() {
    }

    protected BaseResponseWithErrors(Response clientResponse) {
        super(clientResponse);
        this.claimMap = new HashMap<String, List<String>>();
        String entity = this.getEntity();
        if (StringUtils.isNotBlank((CharSequence)entity)) {
            this.injectErrorIfExistSilently(entity);
        }
    }

    public Map<String, List<String>> getClaimMap() {
        return this.claimMap;
    }

    public Map<String, String> getClaims() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.claimMap.entrySet()) {
            boolean hasValue = entry.getValue() != null && !entry.getValue().isEmpty();
            if (!hasValue) continue;
            result.put(entry.getKey(), entry.getValue().get(0));
        }
        return result;
    }

    public void setClaimMap(Map<String, List<String>> claims) {
        this.claimMap = claims;
    }

    public List<String> getClaim(String claimName) {
        if (this.claimMap.containsKey(claimName)) {
            return this.claimMap.get(claimName);
        }
        return null;
    }

    @Nullable
    public String getFirstClaim(@NotNull String claimName) {
        List<String> values = this.getClaim(claimName);
        return !values.isEmpty() ? values.get(0) : null;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public T getErrorType() {
        return this.errorType;
    }

    public void setErrorType(T errorType) {
        this.errorType = errorType;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public abstract T fromString(String var1);

    public void injectDataFromJson(String json) {
    }

    public void injectErrorIfExistSilently(JSONObject jsonObj) throws JSONException {
        if (jsonObj.has("error")) {
            this.errorType = this.fromString(jsonObj.getString("error"));
        }
        if (jsonObj.has("error_description")) {
            this.errorDescription = jsonObj.getString("error_description");
        }
        if (jsonObj.has("error_uri")) {
            this.errorUri = jsonObj.getString("error_uri");
        }
    }

    public void injectErrorIfExistSilently(String entity) {
        try {
            this.injectErrorIfExistSilently(new JSONObject(entity));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String toString() {
        return "BaseResponseWithErrors{claimMap=" + this.claimMap + "errorType=" + this.errorType + ", errorDescription='" + this.errorDescription + "', errorUri='" + this.errorUri + "'} " + super.toString();
    }
}

