/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.DeviceAuthzRequest;
import io.jans.as.client.DeviceAuthzResponse;
import io.jans.as.model.util.Util;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONObject;

public class DeviceAuthzClient
extends BaseClient<DeviceAuthzRequest, DeviceAuthzResponse> {
    private static final Logger LOG = Logger.getLogger(DeviceAuthzClient.class);

    public DeviceAuthzClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public DeviceAuthzResponse exec() {
        this.initClient();
        return this._exec();
    }

    @Deprecated
    public DeviceAuthzResponse exec(ClientHttpEngine engine) {
        this.resteasyClient = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(engine).build();
        this.webTarget = this.resteasyClient.target(this.getUrl());
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceAuthzResponse _exec() {
        try {
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            clientRequest.header("Content-Type", (Object)((DeviceAuthzRequest)this.request).getContentType());
            new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.getRequest());
            String scopesAsString = Util.listAsString(((DeviceAuthzRequest)this.getRequest()).getScopes());
            if (StringUtils.isNotBlank((CharSequence)scopesAsString)) {
                this.requestForm.param("scope", scopesAsString);
            }
            if (StringUtils.isNotBlank((CharSequence)((DeviceAuthzRequest)this.getRequest()).getClientId())) {
                this.requestForm.param("client_id", ((DeviceAuthzRequest)this.getRequest()).getClientId());
            }
            this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
            this.setResponse(new DeviceAuthzResponse(this.clientResponse));
            if (StringUtils.isNotBlank((CharSequence)((DeviceAuthzResponse)this.response).getEntity())) {
                JSONObject jsonObj = new JSONObject(((DeviceAuthzResponse)this.response).getEntity());
                if (jsonObj.has("user_code")) {
                    ((DeviceAuthzResponse)this.getResponse()).setUserCode(jsonObj.getString("user_code"));
                }
                if (jsonObj.has("device_code")) {
                    ((DeviceAuthzResponse)this.getResponse()).setDeviceCode(jsonObj.getString("device_code"));
                }
                if (jsonObj.has("interval")) {
                    ((DeviceAuthzResponse)this.getResponse()).setInterval(jsonObj.getInt("interval"));
                }
                if (jsonObj.has("verification_uri")) {
                    ((DeviceAuthzResponse)this.getResponse()).setVerificationUri(jsonObj.getString("verification_uri"));
                }
                if (jsonObj.has("verification_uri_complete")) {
                    ((DeviceAuthzResponse)this.getResponse()).setVerificationUriComplete(jsonObj.getString("verification_uri_complete"));
                }
                if (jsonObj.has("expires_in")) {
                    ((DeviceAuthzResponse)this.getResponse()).setExpiresIn(jsonObj.getInt("expires_in"));
                }
            }
            DeviceAuthzResponse deviceAuthzResponse = (DeviceAuthzResponse)this.getResponse();
            return deviceAuthzResponse;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            DeviceAuthzResponse deviceAuthzResponse = null;
            return deviceAuthzResponse;
        }
        finally {
            this.closeConnection();
        }
    }
}

