/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.EndSessionRequest;
import io.jans.as.client.EndSessionResponse;
import io.jans.as.model.session.EndSessionErrorResponseType;
import io.jans.as.model.util.QueryStringDecoder;
import io.jans.as.model.util.Util;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class EndSessionClient
extends BaseClient<EndSessionRequest, EndSessionResponse> {
    private static final Logger LOG = Logger.getLogger(EndSessionClient.class);

    public EndSessionClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public EndSessionResponse execEndSession(String idTokenHint, String postLogoutRedirectUri, String state) {
        this.setRequest(new EndSessionRequest(idTokenHint, postLogoutRedirectUri, state));
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndSessionResponse exec() {
        this.initClient();
        if (StringUtils.isNotBlank((CharSequence)((EndSessionRequest)this.getRequest()).getIdTokenHint())) {
            this.addReqParam("id_token_hint", ((EndSessionRequest)this.getRequest()).getIdTokenHint());
        }
        if (StringUtils.isNotBlank((CharSequence)((EndSessionRequest)this.getRequest()).getPostLogoutRedirectUri())) {
            this.addReqParam("post_logout_redirect_uri", ((EndSessionRequest)this.getRequest()).getPostLogoutRedirectUri());
        }
        if (StringUtils.isNotBlank((CharSequence)((EndSessionRequest)this.getRequest()).getState())) {
            this.addReqParam("state", ((EndSessionRequest)this.getRequest()).getState());
        }
        if (StringUtils.isNotBlank((CharSequence)((EndSessionRequest)this.getRequest()).getSid())) {
            this.addReqParam("sid", ((EndSessionRequest)this.getRequest()).getSid());
        }
        try {
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            clientRequest.accept(new String[]{"text/plain"});
            this.clientResponse = clientRequest.buildGet().invoke();
            int status = this.clientResponse.getStatus();
            this.setResponse(new EndSessionResponse(status));
            String entity = (String)this.clientResponse.readEntity(String.class);
            ((EndSessionResponse)this.getResponse()).setEntity(entity);
            ((EndSessionResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            if (this.clientResponse.getLocation() != null) {
                String queryString;
                Map params;
                String location = this.clientResponse.getLocation().toString();
                ((EndSessionResponse)this.getResponse()).setLocation(location);
                int queryStringIndex = location.indexOf("?");
                if (queryStringIndex != -1 && (params = QueryStringDecoder.decode((String)(queryString = location.substring(queryStringIndex + 1)))).containsKey("state")) {
                    ((EndSessionResponse)this.getResponse()).setState((String)params.get("state"));
                }
            }
            if (!Util.isNullOrEmpty((String)entity) && !entity.contains("<html>")) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("error")) {
                    ((EndSessionResponse)this.getResponse()).setErrorType(EndSessionErrorResponseType.fromString((String)jsonObj.getString("error")));
                }
                if (jsonObj.has("error_description")) {
                    ((EndSessionResponse)this.getResponse()).setErrorDescription(jsonObj.getString("error_description"));
                }
                if (jsonObj.has("error_uri")) {
                    ((EndSessionResponse)this.getResponse()).setErrorUri(jsonObj.getString("error_uri"));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (EndSessionResponse)this.getResponse();
    }
}

