/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseResponse;
import io.jans.as.model.crypto.PublicKey;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.ECDSAPublicKey;
import io.jans.as.model.crypto.signature.RSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeySelectionStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JwkResponse
extends BaseResponse {
    private JSONWebKeySet jwks;

    public JwkResponse(int status) {
        super(status);
    }

    public JSONWebKeySet getJwks() {
        return this.jwks;
    }

    public void setJwks(JSONWebKeySet jwks) {
        this.jwks = jwks;
    }

    @Deprecated
    public JSONWebKey getKeyValue(String keyId) {
        for (JSONWebKey JSONWebKey2 : this.jwks.getKeys()) {
            if (!JSONWebKey2.getKid().equals(keyId)) continue;
            return JSONWebKey2;
        }
        return null;
    }

    @Deprecated
    public PublicKey getPublicKey(String keyId) {
        RSAPublicKey publicKey = null;
        JSONWebKey JSONWebKey2 = this.getKeyValue(keyId);
        if (JSONWebKey2 != null) {
            switch (JSONWebKey2.getKty()) {
                case RSA: {
                    publicKey = new RSAPublicKey(JSONWebKey2.getN(), JSONWebKey2.getE());
                    break;
                }
                case EC: {
                    publicKey = new ECDSAPublicKey(SignatureAlgorithm.fromString((String)JSONWebKey2.getAlg().getParamName()), JSONWebKey2.getX(), JSONWebKey2.getY());
                    break;
                }
            }
        }
        return publicKey;
    }

    public List<JSONWebKey> getKeys(Algorithm algorithm) {
        ArrayList<JSONWebKey> jsonWebKeys = new ArrayList<JSONWebKey>();
        if (AlgorithmFamily.RSA.equals((Object)algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.jwks.getKeys()) {
                if (!jsonWebKey.getAlg().equals((Object)algorithm)) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        } else if (AlgorithmFamily.EC.equals((Object)algorithm.getFamily())) {
            for (JSONWebKey jsonWebKey : this.jwks.getKeys()) {
                if (!jsonWebKey.getAlg().equals((Object)algorithm)) continue;
                jsonWebKeys.add(jsonWebKey);
            }
        }
        Collections.sort(jsonWebKeys, KeySelectionStrategy.compareExp());
        return jsonWebKeys;
    }

    public String getKeyId(Algorithm algorithm) {
        List<JSONWebKey> jsonWebKeys = this.getKeys(algorithm);
        if (jsonWebKeys.size() > 0) {
            return jsonWebKeys.get(0).getKid();
        }
        return null;
    }
}

