/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.OpenIdConfigurationRequest;
import io.jans.as.client.OpenIdConfigurationResponse;
import io.jans.as.model.util.Util;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenIdConfigurationClient
extends BaseClient<OpenIdConfigurationRequest, OpenIdConfigurationResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConfigurationClient.class);
    private static final String MEDIA_TYPES = String.join((CharSequence)",", "text/plain", "application/json");

    public OpenIdConfigurationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConfigurationResponse execOpenIdConfiguration() {
        this.initClient();
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenIdConfigurationResponse exec() {
        this.setRequest(new OpenIdConfigurationRequest());
        String entity = null;
        try {
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            clientRequest.accept(new String[]{MEDIA_TYPES});
            this.clientResponse = clientRequest.buildGet().invoke();
            int status = this.clientResponse.getStatus();
            this.setResponse(new OpenIdConfigurationResponse(status));
            entity = (String)this.clientResponse.readEntity(String.class);
            ((OpenIdConfigurationResponse)this.getResponse()).setEntity(entity);
            ((OpenIdConfigurationResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            OpenIdConfigurationClient.parse(entity, (OpenIdConfigurationResponse)this.getResponse());
        }
        catch (JSONException e) {
            LOG.error((Object)"There is an error in the JSON response. Check if there is a syntax error in the JSON response or there is a wrong key", (Throwable)e);
            if (entity != null) {
                LOG.error((Object)("Invalid JSON: " + entity));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (OpenIdConfigurationResponse)this.getResponse();
    }

    public static void parse(String json, OpenIdConfigurationResponse response) {
        JSONObject acrMappings;
        JSONObject mtlsAliases;
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        JSONObject jsonObj = new JSONObject(json);
        response.setIssuer(jsonObj.optString("issuer", null));
        response.setAuthorizationEndpoint(jsonObj.optString("authorization_endpoint", null));
        response.setAuthorizationChallengeEndpoint(jsonObj.optString("authorization_challenge_endpoint", null));
        response.setStatusListEndpoint(jsonObj.optString("status_list_endpoint", null));
        response.setStatusListAggregationEndpoint(jsonObj.optString("status_list_aggregation_endpoint", null));
        response.setAccessEvaluationV1Endpoint(jsonObj.optString("access_evaluation_v1_endpoint", null));
        response.setTokenEndpoint(jsonObj.optString("token_endpoint", null));
        response.setRevocationEndpoint(jsonObj.optString("revocation_endpoint", null));
        response.setSessionRevocationEndpoint(jsonObj.optString("session_revocation_endpoint", null));
        response.setGlobalTokenRevocationEndpoint(jsonObj.optString("global_token_revocation_endpoint", null));
        response.setUserInfoEndpoint(jsonObj.optString("userinfo_endpoint", null));
        response.setClientInfoEndpoint(jsonObj.optString("clientinfo_endpoint", null));
        response.setCheckSessionIFrame(jsonObj.optString("check_session_iframe", null));
        response.setEndSessionEndpoint(jsonObj.optString("end_session_endpoint", null));
        response.setJwksUri(jsonObj.optString("jwks_uri", null));
        response.setArchivedJwksUri(jsonObj.optString("archived_jwks_uri", null));
        response.setRegistrationEndpoint(jsonObj.optString("registration_endpoint", null));
        response.setIntrospectionEndpoint(jsonObj.optString("introspection_endpoint", null));
        response.setParEndpoint(jsonObj.optString("pushed_authorization_request_endpoint", null));
        if (jsonObj.has("require_pushed_authorization_requests")) {
            response.setRequirePar(jsonObj.getBoolean("require_pushed_authorization_requests"));
        }
        response.setDeviceAuthzEndpoint(jsonObj.optString("device_authorization_endpoint", null));
        if (jsonObj.has("scope_to_claims_mapping")) {
            response.setScopeToClaimsMapping(OpenIdConfigurationResponse.parseScopeToClaimsMapping(jsonObj.getJSONArray("scope_to_claims_mapping")));
        }
        if (jsonObj.has("mtls_endpoint_aliases") && (mtlsAliases = jsonObj.optJSONObject("mtls_endpoint_aliases")) != null) {
            response.setMltsAliases(Util.toSerializableMap((Map)mtlsAliases.toMap()));
        }
        if (jsonObj.has("acr_mappings") && (acrMappings = jsonObj.optJSONObject("acr_mappings")) != null) {
            response.setAcrMappings(Util.toSerializableMapOfStrings((Map)acrMappings.toMap()));
        }
        Util.addToListIfHas(response.getScopesSupported(), (JSONObject)jsonObj, (String)"scopes_supported");
        Util.addToListIfHas(response.getResponseTypesSupported(), (JSONObject)jsonObj, (String)"response_types_supported");
        Util.addToListIfHas(response.getResponseModesSupported(), (JSONObject)jsonObj, (String)"response_modes_supported");
        Util.addToListIfHas(response.getPromptValuesSupported(), (JSONObject)jsonObj, (String)"prompt_values_supported");
        Util.addToListIfHas(response.getGrantTypesSupported(), (JSONObject)jsonObj, (String)"grant_types_supported");
        Util.addToListIfHas(response.getAcrValuesSupported(), (JSONObject)jsonObj, (String)"acr_values_supported");
        Util.addToListIfHas(response.getAuthorizationDetailsTypesSupported(), (JSONObject)jsonObj, (String)"authorization_details_types_supported");
        Util.addToListIfHas(response.getSubjectTypesSupported(), (JSONObject)jsonObj, (String)"subject_types_supported");
        Util.addToListIfHas(response.getAuthorizationSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"authorization_signing_alg_values_supported");
        Util.addToListIfHas(response.getAuthorizationEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"authorization_encryption_alg_values_supported");
        Util.addToListIfHas(response.getAuthorizationEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"authorization_encryption_enc_values_supported");
        Util.addToListIfHas(response.getUserInfoSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_signing_alg_values_supported");
        Util.addToListIfHas(response.getUserInfoEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_alg_values_supported");
        Util.addToListIfHas(response.getUserInfoEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_enc_values_supported");
        Util.addToListIfHas(response.getIdTokenSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_signing_alg_values_supported");
        Util.addToListIfHas(response.getIdTokenEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_alg_values_supported");
        Util.addToListIfHas(response.getIdTokenEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_enc_values_supported");
        Util.addToListIfHas(response.getAccessTokenSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"access_token_signing_alg_values_supported");
        Util.addToListIfHas(response.getRequestObjectSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_signing_alg_values_supported");
        Util.addToListIfHas(response.getRequestObjectEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_alg_values_supported");
        Util.addToListIfHas(response.getRequestObjectEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_enc_values_supported");
        Util.addToListIfHas(response.getTokenEndpointAuthMethodsSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_methods_supported");
        Util.addToListIfHas(response.getTokenEndpointAuthSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_signing_alg_values_supported");
        Util.addToListIfHas(response.getDpopSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"dpop_signing_alg_values_supported");
        Util.addToListIfHas(response.getDisplayValuesSupported(), (JSONObject)jsonObj, (String)"display_values_supported");
        Util.addToListIfHas(response.getClaimTypesSupported(), (JSONObject)jsonObj, (String)"claim_types_supported");
        Util.addToListIfHas(response.getClaimsSupported(), (JSONObject)jsonObj, (String)"claims_supported");
        response.setServiceDocumentation(jsonObj.optString("service_documentation", null));
        Util.addToListIfHas(response.getClaimsLocalesSupported(), (JSONObject)jsonObj, (String)"claims_locales_supported");
        Util.addToListIfHas(response.getUiLocalesSupported(), (JSONObject)jsonObj, (String)"ui_locales_supported");
        if (jsonObj.has("claims_parameter_supported")) {
            response.setClaimsParameterSupported(jsonObj.getBoolean("claims_parameter_supported"));
        }
        if (jsonObj.has("request_parameter_supported")) {
            response.setRequestParameterSupported(jsonObj.getBoolean("request_parameter_supported"));
        }
        if (jsonObj.has("request_uri_parameter_supported")) {
            response.setRequestUriParameterSupported(jsonObj.getBoolean("request_uri_parameter_supported"));
        }
        if (jsonObj.has("tls_client_certificate_bound_access_tokens")) {
            response.setTlsClientCertificateBoundAccessTokens(jsonObj.optBoolean("tls_client_certificate_bound_access_tokens"));
        }
        if (jsonObj.has("frontchannel_logout_supported")) {
            response.setFrontChannelLogoutSupported(jsonObj.getBoolean("frontchannel_logout_supported"));
        }
        if (jsonObj.has("frontchannel_logout_session_supported")) {
            response.setFrontChannelLogoutSessionSupported(jsonObj.getBoolean("frontchannel_logout_session_supported"));
        }
        response.setBackchannelLogoutSupported(jsonObj.optBoolean("backchannel_logout_supported"));
        if (jsonObj.has("backchannel_logout_session_supported")) {
            response.setBackchannelLogoutSessionSupported(jsonObj.optBoolean("backchannel_logout_session_supported"));
        }
        if (jsonObj.has("require_request_uri_registration")) {
            response.setRequireRequestUriRegistration(jsonObj.getBoolean("require_request_uri_registration"));
        }
        response.setOpPolicyUri(jsonObj.optString("op_policy_uri", null));
        response.setOpTosUri(jsonObj.optString("op_tos_uri", null));
        response.setBackchannelAuthenticationEndpoint(jsonObj.optString("backchannel_authentication_endpoint", null));
        Util.addToListIfHas(response.getBackchannelTokenDeliveryModesSupported(), (JSONObject)jsonObj, (String)"backchannel_token_delivery_modes_supported");
        Util.addToListIfHas(response.getBackchannelAuthenticationRequestSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"backchannel_authentication_request_signing_alg_values_supported");
        if (jsonObj.has("backchannel_user_code_parameter_supported")) {
            response.setBackchannelUserCodeParameterSupported(jsonObj.getBoolean("backchannel_user_code_parameter_supported"));
        }
        if (jsonObj.has("ssa_endpoint")) {
            response.setSsaEndpoint(jsonObj.optString("ssa_endpoint"));
        }
    }

    public static OpenIdConfigurationResponse parse(String json) {
        OpenIdConfigurationResponse response = new OpenIdConfigurationResponse();
        OpenIdConfigurationClient.parse(json, response);
        return response;
    }
}

