/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseRequest;
import io.jans.as.model.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

public class OpenIdConnectDiscoveryRequest
extends BaseRequest {
    private String resource;
    private String host;
    private String path;

    public OpenIdConnectDiscoveryRequest(String resource) throws URISyntaxException {
        this.resource = resource;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)resource)) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (((String)resource).startsWith("=") || ((String)resource).startsWith("@") || ((String)resource).startsWith("!")) {
            throw new UnsupportedOperationException("XRI is not supported");
        }
        if (((String)resource).contains("@")) {
            this.host = ((String)resource).substring(((String)resource).indexOf("@") + 1);
        } else {
            if (!((String)resource).contains("://")) {
                resource = "https://" + (String)resource;
            }
            URI uri = new URI((String)resource);
            this.host = uri.getHost();
            if (uri.getPort() != -1) {
                this.host = this.host + ":" + uri.getPort();
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)uri.getPath()) && !uri.getPath().equals(uri.getHost()) && !uri.getPath().equals("/")) {
                this.path = uri.getPath();
            }
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"resource", (Object)this.resource);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"rel", (Object)"http://openid.net/specs/connect/1.0/issuer");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

