/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.jans.as.client.BaseRequest;
import io.jans.as.client.model.SoftwareStatement;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.AsymmetricSignatureAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.json.JsonApplier;
import io.jans.as.model.register.ApplicationType;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.util.StringUtils;
import io.jans.orm.model.base.LocalizedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RegisterRequest
extends BaseRequest {
    private static final Logger log = Logger.getLogger(RegisterRequest.class);
    private String registrationAccessToken;
    private List<String> redirectUris;
    private List<String> claimsRedirectUris;
    private List<String> responseTypes;
    private List<GrantType> grantTypes;
    private ApplicationType applicationType;
    private List<String> contacts;
    private List<String> authorizationDetailsTypes;
    private final LocalizedString clientName;
    private final LocalizedString logoUri;
    private final LocalizedString clientUri;
    private final LocalizedString policyUri;
    private final LocalizedString tosUri;
    private String frontChannelLogoutUri;
    private Boolean frontChannelLogoutSessionRequired;
    private String backchannelLogoutUri;
    private Boolean backchannelLogoutSessionRequired;
    private String jwksUri;
    private String jwks;
    private String sectorIdentifierUri;
    private String idTokenTokenBindingCnf;
    private String tlsClientAuthSubjectDn;
    private Boolean allowSpontaneousScopes;
    private List<String> spontaneousScopes;
    private List<String> spontaneousScopeScriptDns;
    private List<String> updateTokenScriptDns;
    private List<String> logoutStatusJwtScriptDns;
    private List<String> parScriptDns;
    private List<String> txTokenScriptDns;
    private List<String> postAuthnScriptDns;
    private List<String> tokenExchangeScriptDns;
    private List<String> consentGatheringScriptDns;
    private List<String> introspectionScriptDns;
    private List<String> rptClaimsScriptDns;
    private List<String> ropcScriptDns;
    private Boolean runIntrospectionScriptBeforeJwtCreation;
    private Boolean keepClientAuthorizationAfterExpiration;
    private SubjectType subjectType;
    private String subjectIdentifierAttribute;
    private Boolean rptAsJwt;
    private Boolean accessTokenAsJwt;
    private Boolean requirePkce;
    private SignatureAlgorithm accessTokenSigningAlg;
    private SignatureAlgorithm authorizationSignedResponseAlg;
    private KeyEncryptionAlgorithm authorizationEncryptedResponseAlg;
    private BlockEncryptionAlgorithm authorizationEncryptedResponseEnc;
    private SignatureAlgorithm idTokenSignedResponseAlg;
    private KeyEncryptionAlgorithm idTokenEncryptedResponseAlg;
    private BlockEncryptionAlgorithm idTokenEncryptedResponseEnc;
    private SignatureAlgorithm userInfoSignedResponseAlg;
    private KeyEncryptionAlgorithm userInfoEncryptedResponseAlg;
    private BlockEncryptionAlgorithm userInfoEncryptedResponseEnc;
    private SignatureAlgorithm introspectionSignedResponseAlg;
    private KeyEncryptionAlgorithm introspectionEncryptedResponseAlg;
    private BlockEncryptionAlgorithm introspectionEncryptedResponseEnc;
    private SignatureAlgorithm txTokenSignedResponseAlg;
    private KeyEncryptionAlgorithm txTokenEncryptedResponseAlg;
    private BlockEncryptionAlgorithm txTokenEncryptedResponseEnc;
    private SignatureAlgorithm logoutStatusJwtSignedResponseAlg;
    private SignatureAlgorithm requestObjectSigningAlg;
    private KeyEncryptionAlgorithm requestObjectEncryptionAlg;
    private BlockEncryptionAlgorithm requestObjectEncryptionEnc;
    private AuthenticationMethod tokenEndpointAuthMethod;
    private List<AuthenticationMethod> additionalTokenEndpointAuthMethods;
    private SignatureAlgorithm tokenEndpointAuthSigningAlg;
    private Integer defaultMaxAge;
    private Integer lifetime;
    private List<String> defaultAcrValues;
    private Integer minimumAcrLevel;
    private Boolean minimumAcrLevelAutoresolve;
    private List<String> minimumAcrPriorityList;
    private String initiateLoginUri;
    private List<String> groups;
    private List<String> postLogoutRedirectUris;
    private List<String> requestUris;
    private List<String> authorizedOrigins;
    private Integer accessTokenLifetime;
    private Integer parLifetime;
    private Integer idTokenLifetime;
    private Integer txTokenLifetime;
    private Boolean requirePar;
    private Boolean dpopBoundAccessToken;
    private String softwareId;
    private String softwareVersion;
    private String softwareStatement;
    private String evidence;
    private Boolean defaultPromptLogin;
    private List<String> authorizedAcrValues;
    private BackchannelTokenDeliveryMode backchannelTokenDeliveryMode;
    private String backchannelClientNotificationEndpoint;
    private AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg;
    private Boolean backchannelUserCodeParameter;
    private List<String> additionalAudience;
    private String redirectUrisRegex;
    private List<String> scope;
    private List<String> claims;
    private final Map<String, String> customAttributes;
    private JSONObject jsonObject;
    private String httpMethod;
    private String jwtRequestAsString;

    public RegisterRequest() {
        this.setContentType("application/json");
        this.setMediaType("application/json");
        this.redirectUris = new ArrayList<String>();
        this.claimsRedirectUris = new ArrayList<String>();
        this.responseTypes = new ArrayList<String>();
        this.grantTypes = new ArrayList<GrantType>();
        this.contacts = new ArrayList<String>();
        this.authorizationDetailsTypes = new ArrayList<String>();
        this.defaultAcrValues = new ArrayList<String>();
        this.minimumAcrPriorityList = new ArrayList<String>();
        this.postLogoutRedirectUris = new ArrayList<String>();
        this.groups = new ArrayList<String>();
        this.requestUris = new ArrayList<String>();
        this.authorizedOrigins = new ArrayList<String>();
        this.scope = new ArrayList<String>();
        this.claims = new ArrayList<String>();
        this.customAttributes = new HashMap<String, String>();
        this.authorizedAcrValues = new ArrayList<String>();
        this.clientName = new LocalizedString();
        this.logoUri = new LocalizedString();
        this.clientUri = new LocalizedString();
        this.policyUri = new LocalizedString();
        this.tosUri = new LocalizedString();
        this.additionalAudience = new ArrayList<String>();
        this.spontaneousScopeScriptDns = new ArrayList<String>();
        this.updateTokenScriptDns = new ArrayList<String>();
        this.logoutStatusJwtScriptDns = new ArrayList<String>();
        this.parScriptDns = new ArrayList<String>();
        this.txTokenScriptDns = new ArrayList<String>();
        this.postAuthnScriptDns = new ArrayList<String>();
        this.tokenExchangeScriptDns = new ArrayList<String>();
        this.consentGatheringScriptDns = new ArrayList<String>();
        this.introspectionScriptDns = new ArrayList<String>();
        this.rptClaimsScriptDns = new ArrayList<String>();
        this.ropcScriptDns = new ArrayList<String>();
    }

    public RegisterRequest(ApplicationType applicationType, String clientName, List<String> redirectUris) {
        this();
        this.applicationType = applicationType;
        this.clientName.setValue(clientName);
        this.redirectUris = redirectUris;
    }

    public RegisterRequest(String registrationAccessToken) {
        this();
        this.registrationAccessToken = registrationAccessToken;
    }

    @Override
    public String getContentType() {
        if (this.hasJwtRequestAsString()) {
            return "application/jwt";
        }
        return super.getContentType();
    }

    public String getTlsClientAuthSubjectDn() {
        return this.tlsClientAuthSubjectDn;
    }

    public void setTlsClientAuthSubjectDn(String tlsClientAuthSubjectDn) {
        this.tlsClientAuthSubjectDn = tlsClientAuthSubjectDn;
    }

    public Boolean getAllowSpontaneousScopes() {
        return this.allowSpontaneousScopes;
    }

    public void setAllowSpontaneousScopes(Boolean allowSpontaneousScopes) {
        this.allowSpontaneousScopes = allowSpontaneousScopes;
    }

    public List<String> getSpontaneousScopes() {
        return this.spontaneousScopes;
    }

    public void setSpontaneousScopes(List<String> spontaneousScopes) {
        this.spontaneousScopes = spontaneousScopes;
    }

    public List<String> getAdditionalAudience() {
        return this.additionalAudience;
    }

    public void setAdditionalAudience(List<String> additionalAudience) {
        this.additionalAudience = additionalAudience;
    }

    public Boolean getRunIntrospectionScriptBeforeJwtCreation() {
        return this.runIntrospectionScriptBeforeJwtCreation;
    }

    public void setRunIntrospectionScriptBeforeJwtCreation(Boolean runIntrospectionScriptBeforeJwtCreation) {
        this.runIntrospectionScriptBeforeJwtCreation = runIntrospectionScriptBeforeJwtCreation;
    }

    public Boolean getKeepClientAuthorizationAfterExpiration() {
        return this.keepClientAuthorizationAfterExpiration;
    }

    public void setKeepClientAuthorizationAfterExpiration(Boolean keepClientAuthorizationAfterExpiration) {
        this.keepClientAuthorizationAfterExpiration = keepClientAuthorizationAfterExpiration;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public String getBackchannelLogoutUri() {
        return this.backchannelLogoutUri;
    }

    public void setBackchannelLogoutUri(String backchannelLogoutUri) {
        this.backchannelLogoutUri = backchannelLogoutUri;
    }

    public Boolean getBackchannelLogoutSessionRequired() {
        return this.backchannelLogoutSessionRequired;
    }

    public void setBackchannelLogoutSessionRequired(Boolean backchannelLogoutSessionRequired) {
        this.backchannelLogoutSessionRequired = backchannelLogoutSessionRequired;
    }

    public String getFrontChannelLogoutUri() {
        return this.frontChannelLogoutUri;
    }

    public void setFrontChannelLogoutUri(String logoutUri) {
        this.frontChannelLogoutUri = logoutUri;
    }

    public Boolean getFrontChannelLogoutSessionRequired() {
        return this.frontChannelLogoutSessionRequired;
    }

    public void setFrontChannelLogoutSessionRequired(Boolean frontChannelLogoutSessionRequired) {
        this.frontChannelLogoutSessionRequired = frontChannelLogoutSessionRequired;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public List<String> getClaimsRedirectUris() {
        return this.claimsRedirectUris;
    }

    public void setClaimsRedirectUris(List<String> claimsRedirectUris) {
        this.claimsRedirectUris = claimsRedirectUris;
    }

    public List<ResponseType> getResponseTypes() {
        HashSet types = Sets.newHashSet();
        this.responseTypes.forEach(s -> types.addAll(ResponseType.fromString((String)s, (String)" ")));
        return Lists.newArrayList((Iterable)types);
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = ResponseType.toStringList(responseTypes);
    }

    public List<String> getResponseTypesStrings() {
        return this.responseTypes;
    }

    public void setResponseTypesStrings(List<String> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public List<GrantType> getGrantTypes() {
        if (this.grantTypes == null) {
            this.grantTypes = new ArrayList<GrantType>();
        }
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String getIdTokenTokenBindingCnf() {
        return this.idTokenTokenBindingCnf;
    }

    public void setIdTokenTokenBindingCnf(String idTokenTokenBindingCnf) {
        this.idTokenTokenBindingCnf = idTokenTokenBindingCnf;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public List<String> getAuthorizationDetailsTypes() {
        return this.authorizationDetailsTypes;
    }

    public void setAuthorizationDetailsTypes(List<String> authorizationDetailsTypes) {
        this.authorizationDetailsTypes = authorizationDetailsTypes;
    }

    public String getClientName() {
        return this.clientName.getValue();
    }

    public String getClientName(String languageTag) {
        return this.clientName.getValue(languageTag);
    }

    public Set<String> getClientNameLanguageTags() {
        return this.clientName.getLanguageTags();
    }

    public void setClientName(String clientName) {
        this.clientName.setValue(clientName);
    }

    public void setClientName(String clientName, Locale locale) {
        this.clientName.setValue(clientName, locale);
    }

    public String getLogoUri() {
        return this.logoUri.getValue();
    }

    public String getLogoUri(String languageTag) {
        return this.logoUri.getValue(languageTag);
    }

    public Set<String> getLogoUriLanguageTags() {
        return this.logoUri.getLanguageTags();
    }

    public void setLogoUri(String logoUri) {
        this.logoUri.setValue(logoUri);
    }

    public void setLogoUri(String logoUri, Locale locale) {
        this.logoUri.setValue(logoUri, locale);
    }

    public String getClientUri() {
        return this.clientUri.getValue();
    }

    public Set<String> getClientUriLanguageTags() {
        return this.clientUri.getLanguageTags();
    }

    public String getClientUri(String languageTag) {
        return this.clientUri.getValue(languageTag);
    }

    public void setClientUri(String clientUri) {
        this.clientUri.setValue(clientUri);
    }

    public void setClientUri(String clientUri, Locale locale) {
        this.clientUri.setValue(clientUri, locale);
    }

    public String getPolicyUri() {
        return this.policyUri.getValue();
    }

    public String getPolicyUri(String languageTag) {
        return this.policyUri.getValue(languageTag);
    }

    public Set<String> getPolicyUriLanguageTags() {
        return this.policyUri.getLanguageTags();
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri.setValue(policyUri);
    }

    public void setPolicyUri(String policyUri, Locale locale) {
        this.policyUri.setValue(policyUri, locale);
    }

    public String getTosUri() {
        return this.tosUri.getValue();
    }

    public String getTosUri(String languageTag) {
        return this.tosUri.getValue(languageTag);
    }

    public Set<String> getTosUriLanguageTags() {
        return this.tosUri.getLanguageTags();
    }

    public void setTosUri(String tosUri) {
        this.tosUri.setValue(tosUri);
    }

    public void setTosUri(String tosUri, Locale locale) {
        this.tosUri.setValue(tosUri, locale);
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public String getSubjectIdentifierAttribute() {
        return this.subjectIdentifierAttribute;
    }

    public void setSubjectIdentifierAttribute(String subjectIdentifierAttribute) {
        this.subjectIdentifierAttribute = subjectIdentifierAttribute;
    }

    public Boolean getRptAsJwt() {
        return this.rptAsJwt;
    }

    public void setRptAsJwt(Boolean rptAsJwt) {
        this.rptAsJwt = rptAsJwt;
    }

    public Boolean getAccessTokenAsJwt() {
        return this.accessTokenAsJwt;
    }

    public void setAccessTokenAsJwt(Boolean accessTokenAsJwt) {
        this.accessTokenAsJwt = accessTokenAsJwt;
    }

    public Boolean getRequirePkce() {
        return this.requirePkce;
    }

    public void setRequirePkce(Boolean requirePkce) {
        this.requirePkce = requirePkce;
    }

    public SignatureAlgorithm getAccessTokenSigningAlg() {
        return this.accessTokenSigningAlg;
    }

    public void setAccessTokenSigningAlg(SignatureAlgorithm accessTokenSigningAlg) {
        this.accessTokenSigningAlg = accessTokenSigningAlg;
    }

    public SignatureAlgorithm getAuthorizationSignedResponseAlg() {
        return this.authorizationSignedResponseAlg;
    }

    public void setAuthorizationSignedResponseAlg(SignatureAlgorithm authorizationSignedResponseAlg) {
        this.authorizationSignedResponseAlg = authorizationSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getAuthorizationEncryptedResponseAlg() {
        return this.authorizationEncryptedResponseAlg;
    }

    public void setAuthorizationEncryptedResponseAlg(KeyEncryptionAlgorithm authorizationEncryptedResponseAlg) {
        this.authorizationEncryptedResponseAlg = authorizationEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getAuthorizationEncryptedResponseEnc() {
        return this.authorizationEncryptedResponseEnc;
    }

    public void setAuthorizationEncryptedResponseEnc(BlockEncryptionAlgorithm authorizationEncryptedResponseEnc) {
        this.authorizationEncryptedResponseEnc = authorizationEncryptedResponseEnc;
    }

    public SignatureAlgorithm getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(SignatureAlgorithm idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public SignatureAlgorithm getIntrospectionSignedResponseAlg() {
        return this.introspectionSignedResponseAlg;
    }

    public void setIntrospectionSignedResponseAlg(SignatureAlgorithm introspectionSignedResponseAlg) {
        this.introspectionSignedResponseAlg = introspectionSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getIntrospectionEncryptedResponseAlg() {
        return this.introspectionEncryptedResponseAlg;
    }

    public void setIntrospectionEncryptedResponseAlg(KeyEncryptionAlgorithm introspectionEncryptedResponseAlg) {
        this.introspectionEncryptedResponseAlg = introspectionEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getIntrospectionEncryptedResponseEnc() {
        return this.introspectionEncryptedResponseEnc;
    }

    public void setIntrospectionEncryptedResponseEnc(BlockEncryptionAlgorithm introspectionEncryptedResponseEnc) {
        this.introspectionEncryptedResponseEnc = introspectionEncryptedResponseEnc;
    }

    public SignatureAlgorithm getLogoutStatusJwtSignedResponseAlg() {
        return this.logoutStatusJwtSignedResponseAlg;
    }

    public RegisterRequest setLogoutStatusJwtSignedResponseAlg(SignatureAlgorithm logoutStatusJwtSignedResponseAlg) {
        this.logoutStatusJwtSignedResponseAlg = logoutStatusJwtSignedResponseAlg;
        return this;
    }

    public SignatureAlgorithm getTxTokenSignedResponseAlg() {
        return this.txTokenSignedResponseAlg;
    }

    public void setTxTokenSignedResponseAlg(SignatureAlgorithm txTokenSignedResponseAlg) {
        this.txTokenSignedResponseAlg = txTokenSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getTxTokenEncryptedResponseAlg() {
        return this.txTokenEncryptedResponseAlg;
    }

    public void setTxTokenEncryptedResponseAlg(KeyEncryptionAlgorithm txTokenEncryptedResponseAlg) {
        this.txTokenEncryptedResponseAlg = txTokenEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getTxTokenEncryptedResponseEnc() {
        return this.txTokenEncryptedResponseEnc;
    }

    public void setTxTokenEncryptedResponseEnc(BlockEncryptionAlgorithm txTokenEncryptedResponseEnc) {
        this.txTokenEncryptedResponseEnc = txTokenEncryptedResponseEnc;
    }

    public SignatureAlgorithm getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(SignatureAlgorithm userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public SignatureAlgorithm getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(SignatureAlgorithm requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public KeyEncryptionAlgorithm getRequestObjectEncryptionAlg() {
        return this.requestObjectEncryptionAlg;
    }

    public void setRequestObjectEncryptionAlg(KeyEncryptionAlgorithm requestObjectEncryptionAlg) {
        this.requestObjectEncryptionAlg = requestObjectEncryptionAlg;
    }

    public BlockEncryptionAlgorithm getRequestObjectEncryptionEnc() {
        return this.requestObjectEncryptionEnc;
    }

    public void setRequestObjectEncryptionEnc(BlockEncryptionAlgorithm requestObjectEncryptionEnc) {
        this.requestObjectEncryptionEnc = requestObjectEncryptionEnc;
    }

    public AuthenticationMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(AuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public List<AuthenticationMethod> getAdditionalTokenEndpointAuthMethods() {
        return this.additionalTokenEndpointAuthMethods;
    }

    public void setAdditionalTokenEndpointAuthMethods(List<AuthenticationMethod> additionalTokenEndpointAuthMethods) {
        this.additionalTokenEndpointAuthMethods = additionalTokenEndpointAuthMethods;
    }

    public SignatureAlgorithm getTokenEndpointAuthSigningAlg() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlg(SignatureAlgorithm tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public Integer getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Integer lifetime) {
        this.lifetime = lifetime;
    }

    public Integer getMinimumAcrLevel() {
        return this.minimumAcrLevel;
    }

    public void setMinimumAcrLevel(Integer minimumAcrLevel) {
        this.minimumAcrLevel = minimumAcrLevel;
    }

    public Boolean getMinimumAcrLevelAutoresolve() {
        return this.minimumAcrLevelAutoresolve;
    }

    public void setMinimumAcrLevelAutoresolve(Boolean minimumAcrLevelAutoresolve) {
        this.minimumAcrLevelAutoresolve = minimumAcrLevelAutoresolve;
    }

    public List<String> getMinimumAcrPriorityList() {
        return this.minimumAcrPriorityList;
    }

    public void setMinimumAcrPriorityList(List<String> minimumAcrPriorityList) {
        this.minimumAcrPriorityList = minimumAcrPriorityList;
    }

    public List<String> getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(List<String> defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public List<String> getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(List<String> requestUris) {
        this.requestUris = requestUris;
    }

    public List<String> getAuthorizedOrigins() {
        return this.authorizedOrigins;
    }

    public void setAuthorizedOrigins(List<String> authorizedOrigins) {
        this.authorizedOrigins = authorizedOrigins;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> claims) {
        this.claims = claims;
    }

    public Integer getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(Integer accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public Integer getParLifetime() {
        return this.parLifetime;
    }

    public void setParLifetime(Integer parLifetime) {
        this.parLifetime = parLifetime;
    }

    public Integer getIdTokenLifetime() {
        return this.idTokenLifetime;
    }

    public void setIdTokenLifetime(Integer idTokenLifetime) {
        this.idTokenLifetime = idTokenLifetime;
    }

    public Integer getTxTokenLifetime() {
        return this.txTokenLifetime;
    }

    public void setTxTokenLifetime(Integer txTokenLifetime) {
        this.txTokenLifetime = txTokenLifetime;
    }

    public Boolean getRequirePar() {
        return this.requirePar;
    }

    public void setRequirePar(Boolean requirePar) {
        this.requirePar = requirePar;
    }

    public Boolean getDpopBoundAccessToken() {
        return this.dpopBoundAccessToken;
    }

    public void setDpopBoundAccessToken(Boolean dpopBoundAccessToken) {
        this.dpopBoundAccessToken = dpopBoundAccessToken;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(String softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public void setEvidence(String evidence) {
        this.evidence = evidence;
    }

    public BackchannelTokenDeliveryMode getBackchannelTokenDeliveryMode() {
        return this.backchannelTokenDeliveryMode;
    }

    public void setBackchannelTokenDeliveryMode(BackchannelTokenDeliveryMode backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
    }

    public String getBackchannelClientNotificationEndpoint() {
        return this.backchannelClientNotificationEndpoint;
    }

    public void setBackchannelClientNotificationEndpoint(String backchannelClientNotificationEndpoint) {
        this.backchannelClientNotificationEndpoint = backchannelClientNotificationEndpoint;
    }

    public AsymmetricSignatureAlgorithm getBackchannelAuthenticationRequestSigningAlg() {
        return this.backchannelAuthenticationRequestSigningAlg;
    }

    public void setBackchannelAuthenticationRequestSigningAlg(AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg) {
        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
    }

    public Boolean getBackchannelUserCodeParameter() {
        return this.backchannelUserCodeParameter;
    }

    public void setBackchannelUserCodeParameter(Boolean backchannelUserCodeParameter) {
        this.backchannelUserCodeParameter = backchannelUserCodeParameter;
    }

    public Boolean getDefaultPromptLogin() {
        return this.defaultPromptLogin;
    }

    public void setDefaultPromptLogin(Boolean defaultPromptLogin) {
        this.defaultPromptLogin = defaultPromptLogin;
    }

    public List<String> getAuthorizedAcrValues() {
        return this.authorizedAcrValues;
    }

    public void setAuthorizedAcrValues(List<String> authorizedAcrValues) {
        this.authorizedAcrValues = authorizedAcrValues;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public List<String> getSpontaneousScopeScriptDns() {
        return this.spontaneousScopeScriptDns;
    }

    public void setSpontaneousScopeScriptDns(List<String> spontaneousScopeScriptDns) {
        this.spontaneousScopeScriptDns = spontaneousScopeScriptDns;
    }

    public List<String> getUpdateTokenScriptDns() {
        return this.updateTokenScriptDns;
    }

    public void setUpdateTokenScriptDns(List<String> updateTokenScriptDns) {
        this.updateTokenScriptDns = updateTokenScriptDns;
    }

    public List<String> getParScriptDns() {
        return this.parScriptDns;
    }

    public RegisterRequest setParScriptDns(List<String> parScriptDns) {
        this.parScriptDns = parScriptDns;
        return this;
    }

    public List<String> getTxTokenScriptDns() {
        return this.txTokenScriptDns;
    }

    public RegisterRequest setTxTokenScriptDns(List<String> txTokenScriptDns) {
        this.txTokenScriptDns = txTokenScriptDns;
        return this;
    }

    public List<String> getLogoutStatusJwtScriptDns() {
        return this.logoutStatusJwtScriptDns;
    }

    public RegisterRequest setLogoutStatusJwtScriptDns(List<String> logoutStatusJwtScriptDns) {
        this.logoutStatusJwtScriptDns = logoutStatusJwtScriptDns;
        return this;
    }

    public List<String> getPostAuthnScriptDns() {
        return this.postAuthnScriptDns;
    }

    public void setPostAuthnScriptDns(List<String> postAuthnScriptDns) {
        this.postAuthnScriptDns = postAuthnScriptDns;
    }

    public List<String> getTokenExchangeScriptDns() {
        return this.tokenExchangeScriptDns;
    }

    public RegisterRequest setTokenExchangeScriptDns(List<String> tokenExchangeScriptDns) {
        this.tokenExchangeScriptDns = tokenExchangeScriptDns;
        return this;
    }

    public List<String> getConsentGatheringScriptDns() {
        return this.consentGatheringScriptDns;
    }

    public void setConsentGatheringScriptDns(List<String> consentGatheringScriptDns) {
        this.consentGatheringScriptDns = consentGatheringScriptDns;
    }

    public List<String> getIntrospectionScriptDns() {
        return this.introspectionScriptDns;
    }

    public void setIntrospectionScriptDns(List<String> introspectionScriptDns) {
        this.introspectionScriptDns = introspectionScriptDns;
    }

    public List<String> getRptClaimsScriptDns() {
        return this.rptClaimsScriptDns;
    }

    public void setRptClaimsScriptDns(List<String> rptClaimsScriptDns) {
        this.rptClaimsScriptDns = rptClaimsScriptDns;
    }

    public List<String> getRopcScriptDns() {
        return this.ropcScriptDns;
    }

    public void setRopcScriptDns(List<String> ropcScriptDns) {
        this.ropcScriptDns = ropcScriptDns;
    }

    public Map<String, String> getCustomAttributes() {
        return Collections.unmodifiableMap(this.customAttributes);
    }

    public void addCustomAttribute(String name, String value) {
        if (RegisterRequestParam.isCustomParameterValid((String)name)) {
            this.customAttributes.put(name, value);
        }
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        JsonApplier.getInstance().apply((Object)this, parameters);
        this.clientName.addToMap(parameters, RegisterRequestParam.CLIENT_NAME.getName());
        this.clientName.addToMap(parameters, RegisterRequestParam.LOGO_URI.getName());
        this.clientName.addToMap(parameters, RegisterRequestParam.CLIENT_URI.getName());
        this.clientName.addToMap(parameters, RegisterRequestParam.POLICY_URI.getName());
        this.clientName.addToMap(parameters, RegisterRequestParam.TOS_URI.getName());
        this.getParameters((name, value) -> {
            parameters.put((String)name, value.toString());
            return null;
        });
        return parameters;
    }

    public static RegisterRequest fromJson(String json) throws JSONException {
        return RegisterRequest.fromJson(new JSONObject(json));
    }

    public static RegisterRequest fromJson(JSONObject requestObject) throws JSONException {
        RegisterRequest result = new RegisterRequest();
        JsonApplier.getInstance().apply(requestObject, (Object)result);
        result.setJsonObject(requestObject);
        result.setRequestUris(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.REQUEST_URIS.toString()));
        result.setAuthorizedOrigins(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.AUTHORIZED_ORIGINS.toString()));
        result.setClaimsRedirectUris(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString()));
        result.setInitiateLoginUri(requestObject.optString(RegisterRequestParam.INITIATE_LOGIN_URI.toString()));
        result.setPostLogoutRedirectUris(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString()));
        result.setGroups(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.GROUPS.toString()));
        result.setDefaultAcrValues(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.DEFAULT_ACR_VALUES.toString()));
        result.setMinimumAcrLevel(ClientUtil.integerOrNull(requestObject, RegisterRequestParam.MINIMUM_ACR_LEVEL.toString()));
        result.setMinimumAcrLevelAutoresolve(requestObject.optBoolean(RegisterRequestParam.MINIMUM_ACR_LEVEL_AUTORESOLVE.toString()));
        result.setMinimumAcrPriorityList(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.MINIMUM_ACR_PRIORITY_LIST.toString()));
        result.setFrontChannelLogoutUri(requestObject.optString(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString()));
        result.setFrontChannelLogoutSessionRequired(requestObject.optBoolean(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString()));
        result.setBackchannelLogoutUri(requestObject.optString(RegisterRequestParam.BACKCHANNEL_LOGOUT_URI.toString()));
        result.setBackchannelLogoutSessionRequired(requestObject.optBoolean(RegisterRequestParam.BACKCHANNEL_LOGOUT_SESSION_REQUIRED.toString()));
        result.setAccessTokenLifetime(ClientUtil.integerOrNull(requestObject, RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString()));
        result.setParLifetime(ClientUtil.integerOrNull(requestObject, RegisterRequestParam.PAR_LIFETIME.toString()));
        result.setIdTokenLifetime(ClientUtil.integerOrNull(requestObject, RegisterRequestParam.ID_TOKEN_LIFETIME.toString()));
        result.setTxTokenLifetime(ClientUtil.integerOrNull(requestObject, RegisterRequestParam.TX_TOKEN_LIFETIME.toString()));
        result.setRequirePar(ClientUtil.booleanOrNull(requestObject, RegisterRequestParam.REQUIRE_PAR.toString()));
        result.setDpopBoundAccessToken(ClientUtil.booleanOrNull(requestObject, RegisterRequestParam.DPOP_BOUND_ACCESS_TOKEN.toString()));
        result.setDefaultMaxAge(ClientUtil.integerOrNull(requestObject, RegisterRequestParam.DEFAULT_MAX_AGE.toString()));
        result.setLifetime(ClientUtil.integerOrNull(requestObject, RegisterRequestParam.LIFETIME.toString()));
        result.setTlsClientAuthSubjectDn(requestObject.optString(RegisterRequestParam.TLS_CLIENT_AUTH_SUBJECT_DN.toString()));
        result.setAllowSpontaneousScopes(requestObject.optBoolean(RegisterRequestParam.ALLOW_SPONTANEOUS_SCOPES.toString()));
        result.setSpontaneousScopes(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.SPONTANEOUS_SCOPES.toString()));
        result.setAdditionalAudience(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.ADDITIONAL_AUDIENCE.toString()));
        result.setSpontaneousScopeScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.SPONTANEOUS_SCOPE_SCRIPT_DNS.toString()));
        result.setUpdateTokenScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.UPDATE_TOKEN_SCRIPT_DNS.toString()));
        result.setLogoutStatusJwtScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.LOGOUT_STATUS_JWT_SCRIPT_DNS.toString()));
        result.setParScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.PAR_SCRIPT_DNS.toString()));
        result.setTxTokenScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.TX_TOKEN_SCRIPT_DNS.toString()));
        result.setPostAuthnScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.POST_AUTHN_SCRIPT_DNS.toString()));
        result.setTokenExchangeScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.TOKEN_EXCHANGE_SCRIPT_DNS.toString()));
        result.setConsentGatheringScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.CONSENT_GATHERING_SCRIPT_DNS.toString()));
        result.setIntrospectionScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.INTROSPECTION_SCRIPT_DNS.toString()));
        result.setRptClaimsScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.RPT_CLAIMS_SCRIPT_DNS.toString()));
        result.setRopcScriptDns(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.ROPC_SCRIPT_DNS.toString()));
        result.setRunIntrospectionScriptBeforeJwtCreation(requestObject.optBoolean(RegisterRequestParam.RUN_INTROSPECTION_SCRIPT_BEFORE_JWT_CREATION.toString()));
        result.setKeepClientAuthorizationAfterExpiration(requestObject.optBoolean(RegisterRequestParam.KEEP_CLIENT_AUTHORIZATION_AFTER_EXPIRATION.toString()));
        result.setRptAsJwt(requestObject.optBoolean(RegisterRequestParam.RPT_AS_JWT.toString()));
        result.setAccessTokenAsJwt(requestObject.optBoolean(RegisterRequestParam.ACCESS_TOKEN_AS_JWT.toString()));
        result.setRequirePkce(requestObject.optBoolean(RegisterRequestParam.REQUIRE_PKCE.toString()));
        result.setAccessTokenSigningAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.ACCESS_TOKEN_SIGNING_ALG.toString())));
        result.setAuthorizationSignedResponseAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.AUTHORIZATION_SIGNED_RESPONSE_ALG.toString())));
        result.setAuthorizationEncryptedResponseAlg(KeyEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.AUTHORIZATION_ENCRYPTED_RESPONSE_ALG.toString())));
        result.setAuthorizationEncryptedResponseEnc(BlockEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.AUTHORIZATION_ENCRYPTED_RESPONSE_ENC.toString())));
        result.setIdTokenSignedResponseAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString())));
        result.setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString())));
        result.setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString())));
        result.setUserInfoSignedResponseAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString())));
        result.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString())));
        result.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString())));
        result.setIntrospectionSignedResponseAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.INTROSPECTION_SIGNED_RESPONSE_ALG.toString())));
        result.setIntrospectionEncryptedResponseAlg(KeyEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.INTROSPECTION_ENCRYPTED_RESPONSE_ALG.toString())));
        result.setIntrospectionEncryptedResponseEnc(BlockEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.INTROSPECTION_ENCRYPTED_RESPONSE_ENC.toString())));
        result.setTxTokenSignedResponseAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.TX_TOKEN_SIGNED_RESPONSE_ALG.toString())));
        result.setTxTokenEncryptedResponseAlg(KeyEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.TX_TOKEN_ENCRYPTED_RESPONSE_ALG.toString())));
        result.setTxTokenEncryptedResponseEnc(BlockEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.TX_TOKEN_ENCRYPTED_RESPONSE_ENC.toString())));
        result.setLogoutStatusJwtSignedResponseAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.LOGOUT_STATUS_JWT_SIGNED_RESPONSE_ALG.toString())));
        result.setRequestObjectSigningAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString())));
        result.setRequestObjectEncryptionAlg(KeyEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString())));
        result.setRequestObjectEncryptionEnc(BlockEncryptionAlgorithm.fromName((String)requestObject.optString(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString())));
        result.setTokenEndpointAuthMethod(AuthenticationMethod.fromString((String)requestObject.optString(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())));
        result.setAdditionalTokenEndpointAuthMethods(AuthenticationMethod.fromList(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.ADDITIONAL_TOKEN_ENDPOINT_AUTH_METHODS.toString())));
        result.setTokenEndpointAuthSigningAlg(SignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString())));
        result.setRedirectUris(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.REDIRECT_URIS.toString()));
        result.setScope(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.SCOPE.toString()));
        result.setClaims(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.CLAIMS.toString()));
        result.setResponseTypesStrings(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.RESPONSE_TYPES.toString()));
        result.setGrantTypes(RegisterRequest.extractGrantTypes(requestObject));
        result.setApplicationType(ApplicationType.fromString((String)requestObject.optString(RegisterRequestParam.APPLICATION_TYPE.toString())));
        result.setContacts(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.CONTACTS.toString()));
        result.setAuthorizationDetailsTypes(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.AUTHORIZATION_DETAILS_TYPES.toString()));
        result.setIdTokenTokenBindingCnf(requestObject.optString(RegisterRequestParam.ID_TOKEN_TOKEN_BINDING_CNF.toString(), ""));
        LocalizedString.fromJson((JSONObject)requestObject, (String)RegisterRequestParam.CLIENT_NAME.getName(), (key, locale) -> {
            result.setClientName((String)key, (Locale)locale);
            return null;
        });
        LocalizedString.fromJson((JSONObject)requestObject, (String)RegisterRequestParam.LOGO_URI.getName(), (key, locale) -> {
            result.setLogoUri((String)key, (Locale)locale);
            return null;
        });
        LocalizedString.fromJson((JSONObject)requestObject, (String)RegisterRequestParam.CLIENT_URI.getName(), (key, locale) -> {
            result.setClientUri((String)key, (Locale)locale);
            return null;
        });
        LocalizedString.fromJson((JSONObject)requestObject, (String)RegisterRequestParam.POLICY_URI.getName(), (key, locale) -> {
            result.setPolicyUri((String)key, (Locale)locale);
            return null;
        });
        LocalizedString.fromJson((JSONObject)requestObject, (String)RegisterRequestParam.TOS_URI.getName(), (key, locale) -> {
            result.setTosUri((String)key, (Locale)locale);
            return null;
        });
        result.setJwksUri(requestObject.optString(RegisterRequestParam.JWKS_URI.toString()));
        result.setJwks(requestObject.optString(RegisterRequestParam.JWKS.toString()));
        result.setSectorIdentifierUri(requestObject.optString(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString()));
        result.setSubjectType(SubjectType.fromString((String)requestObject.optString(RegisterRequestParam.SUBJECT_TYPE.toString())));
        result.setSubjectIdentifierAttribute(requestObject.optString(RegisterRequestParam.PUBLIC_SUBJECT_IDENTIFIER_ATTRIBUTE.getName()));
        result.setSoftwareId(requestObject.optString(RegisterRequestParam.SOFTWARE_ID.toString()));
        result.setSoftwareVersion(requestObject.optString(RegisterRequestParam.SOFTWARE_VERSION.toString()));
        result.setSoftwareStatement(requestObject.optString(RegisterRequestParam.SOFTWARE_STATEMENT.toString()));
        result.setEvidence(requestObject.optString(RegisterRequestParam.EVIDENCE.toString()));
        result.setBackchannelTokenDeliveryMode(BackchannelTokenDeliveryMode.fromString((String)requestObject.optString(RegisterRequestParam.BACKCHANNEL_TOKEN_DELIVERY_MODE.toString())));
        result.setBackchannelClientNotificationEndpoint(requestObject.optString(RegisterRequestParam.BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT.toString()));
        result.setBackchannelAuthenticationRequestSigningAlg(AsymmetricSignatureAlgorithm.fromString((String)requestObject.optString(RegisterRequestParam.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.toString())));
        result.setBackchannelUserCodeParameter(ClientUtil.booleanOrNull(requestObject, RegisterRequestParam.BACKCHANNEL_USER_CODE_PARAMETER.toString()));
        result.setRedirectUrisRegex(requestObject.optString(RegisterRequestParam.REDIRECT_URIS_REGEX.toString()));
        result.setDefaultPromptLogin(requestObject.optBoolean(RegisterRequestParam.DEFAULT_PROMPT_LOGIN.getName()));
        result.setAuthorizedAcrValues(ClientUtil.extractListByKey(requestObject, RegisterRequestParam.AUTHORIZED_ACR_VALUES.getName()));
        return result;
    }

    public static List<GrantType> extractGrantTypes(JSONObject requestObject) {
        HashSet<GrantType> grantTypes = new HashSet<GrantType>();
        if (requestObject.has(RegisterRequestParam.GRANT_TYPES.toString())) {
            JSONArray grantTypesJsonArray = requestObject.getJSONArray(RegisterRequestParam.GRANT_TYPES.toString());
            for (int i = 0; i < grantTypesJsonArray.length(); ++i) {
                GrantType gt = GrantType.fromString((String)grantTypesJsonArray.getString(i));
                if (gt == null) continue;
                grantTypes.add(gt);
            }
        }
        return new ArrayList<GrantType>(grantTypes);
    }

    @Override
    public JSONObject getJSONParameters() throws JSONException {
        JSONObject parameters = new JSONObject();
        JsonApplier.getInstance().apply((Object)this, parameters);
        Map paramsMap = parameters.toMap();
        this.clientName.addToMap(paramsMap, RegisterRequestParam.CLIENT_NAME.getName());
        this.logoUri.addToMap(paramsMap, RegisterRequestParam.LOGO_URI.getName());
        this.clientUri.addToMap(paramsMap, RegisterRequestParam.CLIENT_URI.getName());
        this.policyUri.addToMap(paramsMap, RegisterRequestParam.POLICY_URI.getName());
        this.tosUri.addToMap(paramsMap, RegisterRequestParam.TOS_URI.getName());
        parameters.clear();
        paramsMap.forEach((arg_0, arg_1) -> ((JSONObject)parameters).put(arg_0, arg_1));
        this.getParameters((name, value) -> {
            parameters.put(name, value);
            return null;
        });
        return parameters;
    }

    public void getParameters(BiFunction<String, Object, Void> function) {
        if (this.redirectUris != null && !this.redirectUris.isEmpty()) {
            function.apply(RegisterRequestParam.REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.redirectUris));
        }
        if (this.claimsRedirectUris != null && !this.claimsRedirectUris.isEmpty()) {
            function.apply(RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.claimsRedirectUris));
        }
        if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
            function.apply(RegisterRequestParam.RESPONSE_TYPES.toString(), StringUtils.toJSONArray(this.responseTypes));
        }
        if (this.grantTypes != null && !this.grantTypes.isEmpty()) {
            function.apply(RegisterRequestParam.GRANT_TYPES.toString(), StringUtils.toJSONArray(this.grantTypes));
        }
        if (this.applicationType != null) {
            function.apply(RegisterRequestParam.APPLICATION_TYPE.toString(), this.applicationType.toString());
        }
        if (this.contacts != null && !this.contacts.isEmpty()) {
            function.apply(RegisterRequestParam.CONTACTS.toString(), StringUtils.toJSONArray(this.contacts));
        }
        if (this.authorizationDetailsTypes != null && !this.authorizationDetailsTypes.isEmpty()) {
            function.apply(RegisterRequestParam.AUTHORIZATION_DETAILS_TYPES.toString(), StringUtils.toJSONArray(this.authorizationDetailsTypes));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.jwksUri)) {
            function.apply(RegisterRequestParam.JWKS_URI.toString(), this.jwksUri);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.jwks)) {
            function.apply(RegisterRequestParam.JWKS.toString(), this.jwks);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.sectorIdentifierUri)) {
            function.apply(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), this.sectorIdentifierUri);
        }
        if (this.subjectType != null) {
            function.apply(RegisterRequestParam.SUBJECT_TYPE.toString(), this.subjectType.toString());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subjectIdentifierAttribute)) {
            function.apply(RegisterRequestParam.PUBLIC_SUBJECT_IDENTIFIER_ATTRIBUTE.getName(), this.subjectIdentifierAttribute);
        }
        if (this.rptAsJwt != null) {
            function.apply(RegisterRequestParam.RPT_AS_JWT.toString(), this.rptAsJwt.toString());
        }
        if (this.accessTokenAsJwt != null) {
            function.apply(RegisterRequestParam.ACCESS_TOKEN_AS_JWT.toString(), this.accessTokenAsJwt.toString());
        }
        if (this.requirePkce != null) {
            function.apply(RegisterRequestParam.REQUIRE_PKCE.toString(), this.requirePkce.toString());
        }
        if (this.accessTokenSigningAlg != null) {
            function.apply(RegisterRequestParam.ACCESS_TOKEN_SIGNING_ALG.toString(), this.accessTokenSigningAlg.toString());
        }
        if (this.authorizationSignedResponseAlg != null) {
            function.apply(RegisterRequestParam.AUTHORIZATION_SIGNED_RESPONSE_ALG.toString(), this.authorizationSignedResponseAlg.toString());
        }
        if (this.authorizationEncryptedResponseAlg != null) {
            function.apply(RegisterRequestParam.AUTHORIZATION_ENCRYPTED_RESPONSE_ALG.toString(), this.authorizationEncryptedResponseAlg.toString());
        }
        if (this.authorizationEncryptedResponseEnc != null) {
            function.apply(RegisterRequestParam.AUTHORIZATION_ENCRYPTED_RESPONSE_ENC.toString(), this.authorizationEncryptedResponseEnc.toString());
        }
        if (this.idTokenSignedResponseAlg != null) {
            function.apply(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), this.idTokenSignedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseAlg != null) {
            function.apply(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), this.idTokenEncryptedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseEnc != null) {
            function.apply(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), this.idTokenEncryptedResponseEnc.getName());
        }
        if (this.userInfoSignedResponseAlg != null) {
            function.apply(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), this.userInfoSignedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseAlg != null) {
            function.apply(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), this.userInfoEncryptedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseEnc != null) {
            function.apply(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), this.userInfoEncryptedResponseEnc.getName());
        }
        if (this.introspectionSignedResponseAlg != null) {
            function.apply(RegisterRequestParam.INTROSPECTION_SIGNED_RESPONSE_ALG.toString(), this.introspectionSignedResponseAlg.getName());
        }
        if (this.introspectionEncryptedResponseAlg != null) {
            function.apply(RegisterRequestParam.INTROSPECTION_ENCRYPTED_RESPONSE_ALG.toString(), this.introspectionEncryptedResponseAlg.getName());
        }
        if (this.introspectionEncryptedResponseEnc != null) {
            function.apply(RegisterRequestParam.INTROSPECTION_ENCRYPTED_RESPONSE_ENC.toString(), this.introspectionEncryptedResponseEnc.getName());
        }
        if (this.txTokenSignedResponseAlg != null) {
            function.apply(RegisterRequestParam.TX_TOKEN_SIGNED_RESPONSE_ALG.toString(), this.txTokenSignedResponseAlg.getName());
        }
        if (this.txTokenEncryptedResponseAlg != null) {
            function.apply(RegisterRequestParam.TX_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), this.txTokenEncryptedResponseAlg.getName());
        }
        if (this.txTokenEncryptedResponseEnc != null) {
            function.apply(RegisterRequestParam.TX_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), this.txTokenEncryptedResponseEnc.getName());
        }
        if (this.logoutStatusJwtSignedResponseAlg != null) {
            function.apply(RegisterRequestParam.LOGOUT_STATUS_JWT_SIGNED_RESPONSE_ALG.toString(), this.logoutStatusJwtSignedResponseAlg.getName());
        }
        if (this.requestObjectSigningAlg != null) {
            function.apply(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), this.requestObjectSigningAlg.getName());
        }
        if (this.requestObjectEncryptionAlg != null) {
            function.apply(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString(), this.requestObjectEncryptionAlg.getName());
        }
        if (this.requestObjectEncryptionEnc != null) {
            function.apply(RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString(), this.requestObjectEncryptionEnc.getName());
        }
        if (this.tokenEndpointAuthMethod != null) {
            function.apply(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), this.tokenEndpointAuthMethod.toString());
        }
        if (this.additionalTokenEndpointAuthMethods != null) {
            function.apply(RegisterRequestParam.ADDITIONAL_TOKEN_ENDPOINT_AUTH_METHODS.toString(), StringUtils.toJSONArray(this.additionalTokenEndpointAuthMethods.stream().map(AuthenticationMethod::toString).collect(Collectors.toList())));
        }
        if (this.tokenEndpointAuthSigningAlg != null) {
            function.apply(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString(), this.tokenEndpointAuthSigningAlg.toString());
        }
        if (this.defaultMaxAge != null) {
            function.apply(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), this.defaultMaxAge.toString());
        }
        if (this.lifetime != null) {
            function.apply(RegisterRequestParam.LIFETIME.toString(), this.lifetime.toString());
        }
        if (this.defaultAcrValues != null && !this.defaultAcrValues.isEmpty()) {
            function.apply(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), StringUtils.toJSONArray(this.defaultAcrValues));
        }
        if (this.minimumAcrLevel != null) {
            function.apply(RegisterRequestParam.MINIMUM_ACR_LEVEL.toString(), this.minimumAcrLevel.toString());
        }
        if (this.minimumAcrLevelAutoresolve != null) {
            function.apply(RegisterRequestParam.MINIMUM_ACR_LEVEL_AUTORESOLVE.toString(), this.minimumAcrLevelAutoresolve.toString());
        }
        if (this.minimumAcrPriorityList != null) {
            function.apply(RegisterRequestParam.MINIMUM_ACR_PRIORITY_LIST.toString(), StringUtils.toJSONArray(this.minimumAcrPriorityList));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.initiateLoginUri)) {
            function.apply(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), this.initiateLoginUri);
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            function.apply(RegisterRequestParam.GROUPS.toString(), StringUtils.toJSONArray(this.groups));
        }
        if (this.postLogoutRedirectUris != null && !this.postLogoutRedirectUris.isEmpty()) {
            function.apply(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.postLogoutRedirectUris));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.frontChannelLogoutUri)) {
            function.apply(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString(), this.frontChannelLogoutUri);
        }
        if (this.frontChannelLogoutSessionRequired != null) {
            function.apply(RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString(), this.frontChannelLogoutSessionRequired.toString());
        }
        if (this.backchannelLogoutUri != null && !this.backchannelLogoutUri.isEmpty()) {
            function.apply(RegisterRequestParam.BACKCHANNEL_LOGOUT_URI.toString(), this.backchannelLogoutUri);
        }
        if (this.backchannelLogoutSessionRequired != null) {
            function.apply(RegisterRequestParam.BACKCHANNEL_LOGOUT_SESSION_REQUIRED.toString(), this.backchannelLogoutSessionRequired.toString());
        }
        if (this.requestUris != null && !this.requestUris.isEmpty()) {
            function.apply(RegisterRequestParam.REQUEST_URIS.toString(), StringUtils.toJSONArray(this.requestUris));
        }
        if (this.authorizedOrigins != null && !this.authorizedOrigins.isEmpty()) {
            function.apply(RegisterRequestParam.AUTHORIZED_ORIGINS.toString(), StringUtils.toJSONArray(this.authorizedOrigins));
        }
        if (this.scope != null && !this.scope.isEmpty()) {
            function.apply(RegisterRequestParam.SCOPE.toString(), StringUtils.implode(this.scope, (String)" "));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.softwareId)) {
            function.apply(RegisterRequestParam.SOFTWARE_ID.toString(), this.softwareId);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.softwareVersion)) {
            function.apply(RegisterRequestParam.SOFTWARE_VERSION.toString(), this.softwareVersion);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.softwareStatement)) {
            function.apply(RegisterRequestParam.SOFTWARE_STATEMENT.toString(), this.softwareStatement);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.evidence)) {
            function.apply(RegisterRequestParam.EVIDENCE.toString(), this.evidence);
        }
        if (this.backchannelTokenDeliveryMode != null) {
            function.apply(RegisterRequestParam.BACKCHANNEL_TOKEN_DELIVERY_MODE.toString(), this.backchannelTokenDeliveryMode.toString());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.backchannelClientNotificationEndpoint)) {
            function.apply(RegisterRequestParam.BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT.toString(), this.backchannelClientNotificationEndpoint);
        }
        if (this.backchannelAuthenticationRequestSigningAlg != null) {
            function.apply(RegisterRequestParam.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.toString(), this.backchannelAuthenticationRequestSigningAlg.toString());
        }
        if (this.backchannelUserCodeParameter != null && this.backchannelUserCodeParameter.booleanValue()) {
            function.apply(RegisterRequestParam.BACKCHANNEL_USER_CODE_PARAMETER.toString(), this.backchannelUserCodeParameter.toString());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.idTokenTokenBindingCnf)) {
            function.apply(RegisterRequestParam.ID_TOKEN_TOKEN_BINDING_CNF.toString(), this.idTokenTokenBindingCnf);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.tlsClientAuthSubjectDn)) {
            function.apply(RegisterRequestParam.TLS_CLIENT_AUTH_SUBJECT_DN.toString(), this.tlsClientAuthSubjectDn);
        }
        if (this.allowSpontaneousScopes != null) {
            function.apply(RegisterRequestParam.ALLOW_SPONTANEOUS_SCOPES.toString(), this.allowSpontaneousScopes.toString());
        }
        if (this.spontaneousScopes != null && !this.spontaneousScopes.isEmpty()) {
            function.apply(RegisterRequestParam.SPONTANEOUS_SCOPES.toString(), StringUtils.implode(this.spontaneousScopes, (String)" "));
        }
        RegisterRequest.applyArray(function, RegisterRequestParam.ADDITIONAL_AUDIENCE, this.additionalAudience);
        RegisterRequest.applyArray(function, RegisterRequestParam.SPONTANEOUS_SCOPE_SCRIPT_DNS, this.spontaneousScopeScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.UPDATE_TOKEN_SCRIPT_DNS, this.updateTokenScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.LOGOUT_STATUS_JWT_SCRIPT_DNS, this.logoutStatusJwtScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.PAR_SCRIPT_DNS, this.parScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.TX_TOKEN_SCRIPT_DNS, this.txTokenScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.POST_AUTHN_SCRIPT_DNS, this.postAuthnScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.TOKEN_EXCHANGE_SCRIPT_DNS, this.tokenExchangeScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.CONSENT_GATHERING_SCRIPT_DNS, this.consentGatheringScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.INTROSPECTION_SCRIPT_DNS, this.introspectionScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.RPT_CLAIMS_SCRIPT_DNS, this.rptClaimsScriptDns);
        RegisterRequest.applyArray(function, RegisterRequestParam.ROPC_SCRIPT_DNS, this.ropcScriptDns);
        if (this.runIntrospectionScriptBeforeJwtCreation != null) {
            function.apply(RegisterRequestParam.RUN_INTROSPECTION_SCRIPT_BEFORE_JWT_CREATION.toString(), this.runIntrospectionScriptBeforeJwtCreation.toString());
        }
        if (this.keepClientAuthorizationAfterExpiration != null) {
            function.apply(RegisterRequestParam.KEEP_CLIENT_AUTHORIZATION_AFTER_EXPIRATION.toString(), this.keepClientAuthorizationAfterExpiration.toString());
        }
        if (this.claims != null && !this.claims.isEmpty()) {
            function.apply(RegisterRequestParam.CLAIMS.toString(), StringUtils.implode(this.claims, (String)" "));
        }
        if (this.accessTokenLifetime != null) {
            function.apply(RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString(), this.accessTokenLifetime.toString());
        }
        if (this.idTokenLifetime != null) {
            function.apply(RegisterRequestParam.ID_TOKEN_LIFETIME.toString(), this.idTokenLifetime.toString());
        }
        if (this.txTokenLifetime != null) {
            function.apply(RegisterRequestParam.TX_TOKEN_LIFETIME.toString(), this.txTokenLifetime.toString());
        }
        if (this.parLifetime != null) {
            function.apply(RegisterRequestParam.PAR_LIFETIME.toString(), this.parLifetime.toString());
        }
        if (this.requirePar != null) {
            function.apply(RegisterRequestParam.REQUIRE_PAR.toString(), this.requirePar.toString());
        }
        if (this.dpopBoundAccessToken != null) {
            function.apply(RegisterRequestParam.DPOP_BOUND_ACCESS_TOKEN.toString(), this.dpopBoundAccessToken.toString());
        }
        if (this.redirectUrisRegex != null) {
            function.apply(RegisterRequestParam.REDIRECT_URIS_REGEX.toString(), this.redirectUrisRegex);
        }
        if (this.defaultPromptLogin != null) {
            function.apply(RegisterRequestParam.DEFAULT_PROMPT_LOGIN.getName(), this.defaultPromptLogin);
        }
        if (this.authorizedAcrValues != null && !this.authorizedAcrValues.isEmpty()) {
            function.apply(RegisterRequestParam.AUTHORIZED_ACR_VALUES.toString(), StringUtils.toJSONArray(this.authorizedAcrValues));
        }
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!RegisterRequestParam.isCustomParameterValid((String)name) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) continue;
                function.apply(name, value);
            }
        }
    }

    private static void applyArray(BiFunction<String, Object, Void> function, RegisterRequestParam key, List<String> list) {
        if (list != null && !list.isEmpty()) {
            function.apply(key.toString(), StringUtils.toJSONArray(list));
        }
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public String getQueryString() {
        try {
            return ClientUtil.toPrettyJson(this.getJSONParameters()).replace("\\/", "/");
        }
        catch (JsonProcessingException | JSONException e) {
            log.error((Object)e.getMessage(), e);
            return null;
        }
    }

    public RegisterRequest sign(SignatureAlgorithm signatureAlgorithm, String kid, AuthCryptoProvider cryptoProvider) throws Exception {
        SoftwareStatement ssa = new SoftwareStatement(signatureAlgorithm, (AbstractCryptoProvider)cryptoProvider);
        ssa.setKeyId(kid);
        return this.sign(ssa);
    }

    public RegisterRequest signWithSharedKey(SignatureAlgorithm signatureAlgorithm, String sharedKey, AuthCryptoProvider cryptoProvider) throws Exception {
        return this.sign(new SoftwareStatement(signatureAlgorithm, sharedKey, (AbstractCryptoProvider)cryptoProvider));
    }

    private RegisterRequest sign(SoftwareStatement softwareStatement) throws Exception {
        softwareStatement.setClaims(this.getJSONParameters());
        this.jwtRequestAsString = softwareStatement.getEncodedJwt();
        return this;
    }

    public String getJwtRequestAsString() {
        return this.jwtRequestAsString;
    }

    public void setJwtRequestAsString(String jwtRequestAsString) {
        this.jwtRequestAsString = jwtRequestAsString;
    }

    public boolean hasJwtRequestAsString() {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.jwtRequestAsString);
    }

    public String getRedirectUrisRegex() {
        return this.redirectUrisRegex;
    }

    public void setRedirectUrisRegex(String redirectUrisRegex) {
        this.redirectUrisRegex = redirectUrisRegex;
    }
}

