/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.par;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.par.ParRequest;
import io.jans.as.client.par.ParResponse;
import io.jans.as.model.common.HasParamName;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import org.apache.log4j.Logger;

public class ParClient
extends BaseClient<ParRequest, ParResponse> {
    private static final Logger LOG = Logger.getLogger(ParClient.class);

    public ParClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public ParResponse exec() {
        try {
            ParResponse parResponse = this.exec_();
            return parResponse;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    private ParResponse exec_() throws Exception {
        this.initClient();
        String responseTypesAsString = ((ParRequest)this.getRequest()).getAuthorizationRequest().getResponseTypesAsString();
        String scopesAsString = ((ParRequest)this.getRequest()).getAuthorizationRequest().getScopesAsString();
        String promptsAsString = ((ParRequest)this.getRequest()).getAuthorizationRequest().getPromptsAsString();
        String uiLocalesAsString = ((ParRequest)this.getRequest()).getAuthorizationRequest().getUiLocalesAsString();
        String claimLocalesAsString = ((ParRequest)this.getRequest()).getAuthorizationRequest().getClaimsLocalesAsString();
        String acrValuesAsString = ((ParRequest)this.getRequest()).getAuthorizationRequest().getAcrValuesAsString();
        String claimsAsString = ((ParRequest)this.getRequest()).getAuthorizationRequest().getClaimsAsString();
        this.addReqParam("response_type", responseTypesAsString);
        this.addReqParam("client_id", ((ParRequest)this.getRequest()).getAuthorizationRequest().getClientId());
        this.addReqParam("scope", scopesAsString);
        this.addReqParam("redirect_uri", ((ParRequest)this.getRequest()).getAuthorizationRequest().getRedirectUri());
        this.addReqParam("state", ((ParRequest)this.getRequest()).getAuthorizationRequest().getState());
        this.addReqParam("nbf", ((ParRequest)this.getRequest()).getNbf() != null ? ((ParRequest)this.getRequest()).getNbf().toString() : null);
        this.addReqParam("nonce", ((ParRequest)this.getRequest()).getAuthorizationRequest().getNonce());
        this.addReqParam("display", (HasParamName)((ParRequest)this.getRequest()).getAuthorizationRequest().getDisplay());
        this.addReqParam("prompt", promptsAsString);
        if (((ParRequest)this.getRequest()).getAuthorizationRequest().getMaxAge() != null) {
            this.addReqParam("max_age", ((ParRequest)this.getRequest()).getAuthorizationRequest().getMaxAge().toString());
        }
        this.addReqParam("ui_locales", uiLocalesAsString);
        this.addReqParam("claims_locales", claimLocalesAsString);
        this.addReqParam("id_token_hint", ((ParRequest)this.getRequest()).getAuthorizationRequest().getIdTokenHint());
        this.addReqParam("authorization_details", ((ParRequest)this.getRequest()).getAuthorizationRequest().getAuthorizationDetails());
        this.addReqParam("login_hint", ((ParRequest)this.getRequest()).getAuthorizationRequest().getLoginHint());
        this.addReqParam("acr_values", acrValuesAsString);
        this.addReqParam("claims", claimsAsString);
        this.addReqParam("registration", ((ParRequest)this.getRequest()).getAuthorizationRequest().getRegistration());
        this.addReqParam("request", ((ParRequest)this.getRequest()).getAuthorizationRequest().getRequest());
        this.addReqParam("request_uri", ((ParRequest)this.getRequest()).getAuthorizationRequest().getRequestUri());
        this.addReqParam("access_token", ((ParRequest)this.getRequest()).getAuthorizationRequest().getAccessToken());
        this.addReqParam("custom_response_headers", ((ParRequest)this.getRequest()).getAuthorizationRequest().getCustomResponseHeadersAsString());
        this.addReqParam("dpop_jkt", ((ParRequest)this.getRequest()).getAuthorizationRequest().getDpopJkt());
        this.addReqParam("code_challenge", ((ParRequest)this.getRequest()).getAuthorizationRequest().getCodeChallenge());
        this.addReqParam("code_challenge_method", ((ParRequest)this.getRequest()).getAuthorizationRequest().getCodeChallengeMethod());
        this.addReqParam("session_id", ((ParRequest)this.getRequest()).getAuthorizationRequest().getSessionId());
        for (String key : ((ParRequest)this.request).getCustomParameters().keySet()) {
            this.addReqParam(key, ((ParRequest)this.request).getCustomParameters().get(key));
        }
        Invocation.Builder clientRequest = this.webTarget.request();
        new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.request);
        clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
        this.setResponse(new ParResponse(this.clientResponse));
        return (ParResponse)this.getResponse();
    }
}

