/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.service;

import io.jans.as.client.service.IntrospectionService;
import io.jans.as.client.service.StatService;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public class ClientFactory {
    private static final ClientFactory INSTANCE = new ClientFactory();
    private final ApacheHttpClient43Engine engine = this.createEngine();

    private ClientFactory() {
    }

    public static ClientFactory instance() {
        return INSTANCE;
    }

    public StatService createStatService(String url) {
        return this.createStatService(url, (ClientHttpEngine)this.engine);
    }

    public StatService createStatService(String url, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)url));
        return (StatService)target.proxy(StatService.class);
    }

    public IntrospectionService createIntrospectionService(String url) {
        return this.createIntrospectionService(url, (ClientHttpEngine)this.engine);
    }

    public IntrospectionService createIntrospectionService(String url, ClientHttpEngine engine) {
        ResteasyClient client = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)url));
        return (IntrospectionService)target.proxy(IntrospectionService.class);
    }

    public ApacheHttpClient43Engine createEngine() {
        return this.createEngine(false);
    }

    public ApacheHttpClient43Engine createEngine(boolean followRedirects) {
        return this.createEngine(200, 20, "standard", followRedirects);
    }

    public ApacheHttpClient43Engine createEngine(int maxTotal, int defaultMaxPerRoute, String cookieSpec, boolean followRedirects) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec(cookieSpec).build()).setConnectionManager((HttpClientConnectionManager)cm).build();
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(defaultMaxPerRoute);
        ApacheHttpClient43Engine client4Engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        client4Engine.setFollowRedirects(followRedirects);
        return client4Engine;
    }
}

