/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ssa.create;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.jans.as.client.BaseRequest;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.common.AuthorizationMethod;
import io.jans.as.model.json.JsonApplier;
import io.jans.as.model.ssa.SsaRequestParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SsaCreateRequest
extends BaseRequest {
    private static final Logger log = Logger.getLogger(SsaCreateRequest.class);
    @JsonProperty(value="org_id")
    private String orgId;
    private Long expiration;
    private String description;
    @JsonProperty(value="software_id")
    private String softwareId;
    @JsonProperty(value="software_roles")
    private List<String> softwareRoles;
    @JsonProperty(value="grant_types")
    private List<String> grantTypes;
    @JsonProperty(value="one_time_use")
    private Boolean oneTimeUse;
    @JsonProperty(value="rotate_ssa")
    private Boolean rotateSsa;
    @JsonProperty(value="lifetime")
    private Integer lifetime;
    private String accessToken;

    public SsaCreateRequest() {
        this.setContentType("application/json");
        this.setMediaType("application/json");
        this.setAuthorizationMethod(AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD);
        this.softwareRoles = new ArrayList<String>();
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Long expiration) {
        this.expiration = expiration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public List<String> getSoftwareRoles() {
        return this.softwareRoles;
    }

    public void setSoftwareRoles(List<String> softwareRoles) {
        this.softwareRoles = softwareRoles;
    }

    public List<String> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public Boolean getOneTimeUse() {
        return this.oneTimeUse;
    }

    public void setOneTimeUse(Boolean oneTimeUse) {
        this.oneTimeUse = oneTimeUse;
    }

    public Boolean getRotateSsa() {
        return this.rotateSsa;
    }

    public void setRotateSsa(Boolean rotateSsa) {
        this.rotateSsa = rotateSsa;
    }

    public Integer getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Integer lifetime) {
        this.lifetime = lifetime;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public static SsaCreateRequest fromJson(String json) throws JSONException {
        return SsaCreateRequest.fromJson(new JSONObject(json));
    }

    public static SsaCreateRequest fromJson(JSONObject requestObject) throws JSONException {
        SsaCreateRequest result = new SsaCreateRequest();
        JsonApplier.getInstance().apply(requestObject, (Object)result);
        result.setOrgId(requestObject.optString(SsaRequestParam.ORG_ID.getName()));
        result.setExpiration(ClientUtil.longOrNull(requestObject, SsaRequestParam.EXPIRATION.getName()));
        result.setDescription(requestObject.optString(SsaRequestParam.DESCRIPTION.getName()));
        result.setSoftwareId(requestObject.optString(SsaRequestParam.SOFTWARE_ID.getName()));
        result.setSoftwareRoles(ClientUtil.extractListByKey(requestObject, SsaRequestParam.SOFTWARE_ROLES.getName()));
        result.setGrantTypes(ClientUtil.extractListByKey(requestObject, SsaRequestParam.GRANT_TYPES.getName()));
        result.setOneTimeUse(requestObject.optBoolean(SsaRequestParam.ONE_TIME_USE.getName(), true));
        result.setRotateSsa(requestObject.optBoolean(SsaRequestParam.ROTATE_SSA.getName(), true));
        result.setLifetime(ClientUtil.integerOrNull(requestObject, SsaRequestParam.LIFETIME.getName()));
        return result;
    }

    @Override
    public String getQueryString() {
        try {
            return ClientUtil.toPrettyJson(this.getJSONParameters()).replace("\\/", "/");
        }
        catch (JsonProcessingException | JSONException e) {
            log.error((Object)e.getMessage(), e);
            return null;
        }
    }

    @Override
    public JSONObject getJSONParameters() throws JSONException {
        JSONObject parameters = new JSONObject();
        parameters.put(SsaRequestParam.ORG_ID.getName(), (Object)this.orgId);
        parameters.put(SsaRequestParam.EXPIRATION.getName(), (Object)this.expiration);
        parameters.put(SsaRequestParam.DESCRIPTION.getName(), (Object)this.description);
        parameters.put(SsaRequestParam.SOFTWARE_ID.getName(), (Object)this.softwareId);
        parameters.put(SsaRequestParam.SOFTWARE_ROLES.getName(), this.softwareRoles);
        parameters.put(SsaRequestParam.GRANT_TYPES.getName(), this.grantTypes);
        parameters.put(SsaRequestParam.ONE_TIME_USE.getName(), (Object)this.oneTimeUse);
        parameters.put(SsaRequestParam.ROTATE_SSA.getName(), (Object)this.rotateSsa);
        parameters.put(SsaRequestParam.LIFETIME.getName(), (Object)this.lifetime);
        return parameters;
    }

    public String toString() {
        return "SsaRequest{orgId='" + this.orgId + "', expiration=" + this.expiration + ", description='" + this.description + "', softwareId='" + this.softwareId + "', softwareRoles=" + this.softwareRoles + ", grantTypes=" + this.grantTypes + ", oneTimeUse=" + this.oneTimeUse + ", rotateSsa=" + this.rotateSsa + ", lifetime=" + this.lifetime + "}";
    }
}

