/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.IsJsonRequest;
import io.jans.as.model.util.QueryBuilder;
import io.jans.model.authzen.AccessEvaluationRequest;
import org.apache.log4j.Logger;

public class AccessEvaluationClientRequest
extends ClientAuthnRequest
implements IsJsonRequest {
    private static final Logger LOG = Logger.getLogger(AccessEvaluationClientRequest.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private AccessEvaluationRequest request;

    public AccessEvaluationClientRequest() {
        this.setContentType("application/json");
    }

    public AccessEvaluationRequest getRequest() {
        return this.request;
    }

    public AccessEvaluationClientRequest setRequest(AccessEvaluationRequest request) {
        this.request = request;
        return this;
    }

    @Override
    public String getQueryString() {
        QueryBuilder builder = QueryBuilder.instance();
        if (this.request == null) {
            return builder.toString();
        }
        this.appendClientAuthnToQuery(builder);
        for (String key : this.getCustomParameters().keySet()) {
            builder.append(key, this.getCustomParameters().get(key));
        }
        return builder.toString();
    }

    public String toString() {
        return "AccessEvaluationClientRequest{request=" + this.request + "} " + super.toString();
    }

    @Override
    public String asJson() {
        try {
            return this.request != null ? MAPPER.writeValueAsString((Object)this.request) : "";
        }
        catch (JsonProcessingException e) {
            LOG.error((Object)"Failed to serialize request", (Throwable)e);
            return "";
        }
    }
}

