/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseRequest;
import io.jans.as.model.authorize.CodeVerifier;
import io.jans.as.model.common.Display;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationRequest
extends BaseRequest {
    private static final Logger LOG = Logger.getLogger(AuthorizationRequest.class);
    public static final String NO_REDIRECT_HEADER = "X-Gluu-NoRedirect";
    private List<ResponseType> responseTypes;
    private String clientId;
    private List<String> scopes;
    private String redirectUri;
    private String state;
    private ResponseMode responseMode;
    private String nonce;
    private Display display;
    private List<Prompt> prompts;
    private Integer maxAge;
    private List<String> uiLocales;
    private List<String> claimsLocales;
    private String idTokenHint;
    private String loginHint;
    private List<String> acrValues;
    private JSONObject claims;
    private String registration;
    private String request;
    private String requestUri;
    private boolean requestLogoutStatusJwt;
    private boolean requestSessionId;
    private String sessionId;
    private String accessToken;
    private boolean useNoRedirectHeader;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String authorizationDetails;
    private String dpopJkt;
    private Map<String, String> customResponseHeaders;

    public AuthorizationRequest(List<ResponseType> responseTypes, String clientId, List<String> scopes, String redirectUri, String nonce) {
        this.responseTypes = responseTypes;
        this.clientId = clientId;
        this.scopes = scopes;
        this.redirectUri = redirectUri;
        this.nonce = nonce;
        this.prompts = new ArrayList<Prompt>();
        this.useNoRedirectHeader = false;
    }

    public AuthorizationRequest(String requestUri) {
        this.requestUri = requestUri;
    }

    public CodeVerifier generateAndSetCodeChallengeWithMethod() {
        CodeVerifier verifier = new CodeVerifier(CodeVerifier.CodeChallengeMethod.S256);
        this.codeChallenge = verifier.getCodeChallenge();
        this.codeChallengeMethod = verifier.getTransformationType().getPkceString();
        return verifier;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getDpopJkt() {
        return this.dpopJkt;
    }

    public void setDpopJkt(String dpopJkt) {
        this.dpopJkt = dpopJkt;
    }

    public String getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public void setAuthorizationDetails(String authorizationDetails) {
        this.authorizationDetails = authorizationDetails;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public void setPrompts(List<Prompt> prompts) {
        this.prompts = prompts;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public List<String> getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(List<String> uiLocales) {
        this.uiLocales = uiLocales;
    }

    public List<String> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimsLocales(List<String> claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public List<String> getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(List<String> acrValues) {
        this.acrValues = acrValues;
    }

    public JSONObject getClaims() {
        return this.claims;
    }

    public void setClaims(JSONObject claims) {
        this.claims = claims;
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public boolean isRequestSessionId() {
        return this.requestSessionId;
    }

    public void setRequestSessionId(boolean requestSessionId) {
        this.requestSessionId = requestSessionId;
    }

    public boolean isRequestLogoutStatusJwt() {
        return this.requestLogoutStatusJwt;
    }

    public AuthorizationRequest setRequestLogoutStatusJwt(boolean requestLogoutStatusJwt) {
        this.requestLogoutStatusJwt = requestLogoutStatusJwt;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isUseNoRedirectHeader() {
        return this.useNoRedirectHeader;
    }

    public void setUseNoRedirectHeader(boolean useNoRedirectHeader) {
        this.useNoRedirectHeader = useNoRedirectHeader;
    }

    public String getResponseTypesAsString() {
        return Util.asString(this.responseTypes);
    }

    public String getScopesAsString() {
        return Util.listAsString(this.scopes);
    }

    public String getPromptsAsString() {
        return Util.asString(this.prompts);
    }

    public String getUiLocalesAsString() {
        return Util.listAsString(this.uiLocales);
    }

    public String getClaimsLocalesAsString() {
        return Util.listAsString(this.claimsLocales);
    }

    public String getAcrValuesAsString() {
        return Util.listAsString(this.acrValues);
    }

    public String getCustomResponseHeadersAsString() throws JSONException {
        String header = Util.mapAsString(this.customResponseHeaders);
        if (header == null) {
            return null;
        }
        try {
            return URLEncoder.encode(header, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)"Failed to encode string", (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getCustomResponseHeaders() {
        return this.customResponseHeaders;
    }

    public void setCustomResponseHeaders(Map<String, String> customResponseHeaders) {
        this.customResponseHeaders = customResponseHeaders;
    }

    public String getClaimsAsString() {
        if (this.claims != null) {
            return this.claims.toString();
        }
        return null;
    }

    public String getParQueryString() {
        StringBuilder builder = new StringBuilder();
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.state)) {
                builder.append("&").append("state").append("=").append(URLEncoder.encode(this.state, "UTF-8"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.nonce)) {
                builder.append("&").append("nonce").append("=").append(URLEncoder.encode(this.nonce, "UTF-8"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.requestUri)) {
                builder.append("&").append("request_uri").append("=").append(URLEncoder.encode(this.requestUri, "UTF-8"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.clientId)) {
                builder.append("&").append("client_id").append("=").append(URLEncoder.encode(this.clientId, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return builder.toString();
    }

    @Override
    public String getQueryString() {
        if (Util.isPar((String)this.requestUri)) {
            return this.getParQueryString();
        }
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            String responseTypesAsString = this.getResponseTypesAsString();
            String scopesAsString = this.getScopesAsString();
            String promptsAsString = this.getPromptsAsString();
            String customResponseHeadersAsString = this.getCustomResponseHeadersAsString();
            String uiLocalesAsString = this.getUiLocalesAsString();
            String claimLocalesAsString = this.getClaimsLocalesAsString();
            String acrValuesAsString = this.getAcrValuesAsString();
            String claimsAsString = this.getClaimsAsString();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)responseTypesAsString)) {
                queryStringBuilder.append("response_type").append("=").append(URLEncoder.encode(responseTypesAsString, "UTF-8"));
            }
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"client_id", (Object)this.clientId);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"scope", (Object)scopesAsString);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"redirect_uri", (Object)this.redirectUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"state", (Object)this.state);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"response_mode", this.responseMode != null ? this.responseMode.toString() : null);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"nonce", (Object)this.nonce);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"display", this.display != null ? this.display.toString() : null);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"prompt", (Object)promptsAsString);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"max_age", (Object)this.maxAge);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"ui_locales", (Object)uiLocalesAsString);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"claims_locales", (Object)claimLocalesAsString);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"id_token_hint", (Object)this.idTokenHint);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"login_hint", (Object)this.loginHint);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"acr_values", (Object)acrValuesAsString);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"claims", (Object)claimsAsString);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"registration", (Object)this.registration);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"request", (Object)this.request);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"request_uri", (Object)this.requestUri);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"request_session_id", (Object)this.requestSessionId);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"logout_status_jwt", (Object)this.requestLogoutStatusJwt);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"session_id", (Object)this.sessionId);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"access_token", (Object)this.accessToken);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"code_challenge", (Object)this.codeChallenge);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"code_challenge_method", (Object)this.codeChallengeMethod);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"dpop_jkt", (Object)this.dpopJkt);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"authorization_details", (Object)this.authorizationDetails);
            StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)"custom_response_headers", (Object)customResponseHeadersAsString);
            for (String key : this.getCustomParameters().keySet()) {
                queryStringBuilder.append("&");
                queryStringBuilder.append(key).append("=").append(this.getCustomParameters().get(key));
            }
        }
        catch (UnsupportedEncodingException | JSONException e) {
            LOG.error((Object)e.getMessage(), e);
        }
        return queryStringBuilder.toString();
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            String responseTypesAsString = this.getResponseTypesAsString();
            String scopesAsString = this.getScopesAsString();
            String promptsAsString = this.getPromptsAsString();
            String customResponseHeadersAsString = this.getCustomResponseHeadersAsString();
            String uiLocalesAsString = this.getUiLocalesAsString();
            String claimLocalesAsString = this.getClaimsLocalesAsString();
            String acrValuesAsString = this.getAcrValuesAsString();
            String claimsAsString = this.getClaimsAsString();
            Util.putNotBlank(parameters, (String)"response_type", (Object)responseTypesAsString);
            Util.putNotBlank(parameters, (String)"client_id", (Object)this.clientId);
            Util.putNotBlank(parameters, (String)"scope", (Object)scopesAsString);
            Util.putNotBlank(parameters, (String)"redirect_uri", (Object)this.redirectUri);
            Util.putNotBlank(parameters, (String)"state", (Object)this.state);
            Util.putNotBlank(parameters, (String)"response_mode", this.responseMode != null ? this.responseMode.toString() : null);
            Util.putNotBlank(parameters, (String)"nonce", (Object)this.nonce);
            Util.putNotBlank(parameters, (String)"display", this.display != null ? this.display.toString() : null);
            Util.putNotBlank(parameters, (String)"prompt", (Object)promptsAsString);
            Util.putNotBlank(parameters, (String)"max_age", this.maxAge != null ? this.maxAge.toString() : null);
            Util.putNotBlank(parameters, (String)"ui_locales", (Object)uiLocalesAsString);
            Util.putNotBlank(parameters, (String)"claims_locales", (Object)claimLocalesAsString);
            Util.putNotBlank(parameters, (String)"id_token_hint", (Object)this.idTokenHint);
            Util.putNotBlank(parameters, (String)"login_hint", (Object)this.loginHint);
            Util.putNotBlank(parameters, (String)"acr_values", (Object)acrValuesAsString);
            Util.putNotBlank(parameters, (String)"claims", (Object)claimsAsString);
            Util.putNotBlank(parameters, (String)"registration", (Object)this.registration);
            Util.putNotBlank(parameters, (String)"request", (Object)this.request);
            Util.putNotBlank(parameters, (String)"request_uri", (Object)this.requestUri);
            Util.putNotBlank(parameters, (String)"request_session_id", this.requestSessionId ? Boolean.toString(this.requestSessionId) : null);
            Util.putNotBlank(parameters, (String)"logout_status_jwt", this.requestLogoutStatusJwt ? Boolean.toString(this.requestLogoutStatusJwt) : null);
            Util.putNotBlank(parameters, (String)"session_id", (Object)this.sessionId);
            Util.putNotBlank(parameters, (String)"access_token", (Object)this.accessToken);
            Util.putNotBlank(parameters, (String)"code_challenge", (Object)this.codeChallenge);
            Util.putNotBlank(parameters, (String)"code_challenge_method", (Object)this.codeChallengeMethod);
            Util.putNotBlank(parameters, (String)"dpop_jkt", (Object)this.dpopJkt);
            Util.putNotBlank(parameters, (String)"authorization_details", (Object)this.authorizationDetails);
            Util.putNotBlank(parameters, (String)"custom_response_headers", (Object)customResponseHeadersAsString);
            for (String key : this.getCustomParameters().keySet()) {
                parameters.put(key, this.getCustomParameters().get(key));
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return parameters;
    }
}

