/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.util.QueryBuilder;
import io.jans.as.model.util.Util;
import java.util.List;

public class BackchannelAuthenticationRequest
extends ClientAuthnRequest {
    private List<String> scope;
    private String clientNotificationToken;
    private List<String> acrValues;
    private String loginHintToken;
    private String idTokenHint;
    private String loginHint;
    private String bindingMessage;
    private String userCode;
    private Integer requestedExpiry;
    private String clientId;
    private String request;
    private String requestUri;

    public BackchannelAuthenticationRequest() {
        this.setContentType("application/x-www-form-urlencoded");
        this.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
    }

    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public String getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public void setClientNotificationToken(String clientNotificationToken) {
        this.clientNotificationToken = clientNotificationToken;
    }

    public List<String> getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(List<String> acrValues) {
        this.acrValues = acrValues;
    }

    public String getLoginHintToken() {
        return this.loginHintToken;
    }

    public void setLoginHintToken(String loginHintToken) {
        this.loginHintToken = loginHintToken;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public void setBindingMessage(String bindingMessage) {
        this.bindingMessage = bindingMessage;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public Integer getRequestedExpiry() {
        return this.requestedExpiry;
    }

    public void setRequestedExpiry(Integer requestedExpiry) {
        this.requestedExpiry = requestedExpiry;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getQueryString() {
        QueryBuilder builder = QueryBuilder.instance();
        String scopesAsString = Util.listAsString(this.scope);
        String acrValuesAsString = Util.listAsString(this.acrValues);
        builder.append("scope", scopesAsString);
        builder.append("client_notification_token", this.clientNotificationToken);
        builder.append("acr_values", acrValuesAsString);
        builder.append("login_hint_token", this.loginHintToken);
        builder.append("id_token_hint", this.idTokenHint);
        builder.append("login_hint", this.loginHint);
        builder.append("binding_message", this.bindingMessage);
        builder.append("user_code", this.userCode);
        builder.appendIfNotNull("requested_expiry", (Object)this.requestedExpiry);
        builder.appendIfNotNull("client_id", (Object)this.clientId);
        builder.appendIfNotNull("request", (Object)this.request);
        builder.appendIfNotNull("request_uri", (Object)this.requestUri);
        this.appendClientAuthnToQuery(builder);
        return builder.toString();
    }
}

