/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.token.ClientAssertionType;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import org.apache.commons.lang3.StringUtils;

public class ClientAuthnEnabler {
    private final Invocation.Builder clientRequest;
    private final Form requestForm;

    public ClientAuthnEnabler(Invocation.Builder clientRequest, Form requestForm) {
        this.clientRequest = clientRequest;
        this.requestForm = requestForm;
    }

    public void exec(ClientAuthnRequest request) {
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && request.hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + request.getEncodedCredentials()));
            return;
        }
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            if (request.getAuthUsername() != null && !request.getAuthUsername().isEmpty()) {
                this.requestForm.param("client_id", request.getAuthUsername());
            }
            if (request.getAuthPassword() != null && !request.getAuthPassword().isEmpty()) {
                this.requestForm.param("client_secret", request.getAuthPassword());
            }
            return;
        }
        if (request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || request.getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            this.requestForm.param("client_assertion_type", ClientAssertionType.JWT_BEARER.toString());
            String clientAssertion = request.getClientAssertion();
            if (clientAssertion != null) {
                this.requestForm.param("client_assertion", clientAssertion);
            }
            if (StringUtils.isNotBlank((CharSequence)request.getAuthUsername())) {
                this.requestForm.param("client_id", request.getAuthUsername());
            }
        }
    }
}

