/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.BaseRequest;
import io.jans.as.client.BaseResponse;
import org.apache.http.client.CookieStore;

public class ClientUtils {
    private ClientUtils() {
    }

    public static void showHeader(String header) {
        System.out.println("-------------------------------------------------------");
        System.out.println(header);
        System.out.println("-------------------------------------------------------");
    }

    public static void showClient(BaseClient client) {
        ClientUtils.showHeader("REQUEST:");
        System.out.println(client.getRequestAsString());
        System.out.println();
        ClientUtils.showHeader("RESPONSE:");
        System.out.println(client.getResponseAsString());
        System.out.println();
    }

    public static void showClientUserAgent(BaseClient client) {
        ClientUtils.showHeader("REQUEST:");
        System.out.println(client.getUrl() + "?" + ((BaseRequest)client.getRequest()).getQueryString());
        System.out.println();
        if (client.getResponse() != null) {
            ClientUtils.showHeader("RESPONSE:");
            System.out.println("HTTP/1.1 302 Found");
            System.out.println("Location: " + ((BaseResponse)client.getResponse()).getLocation());
            System.out.println();
        }
    }

    public static void showClient(BaseClient client, CookieStore cookieStore) {
        ClientUtils.showClient(client);
        ClientUtils.showHeader("COOKIES:");
        System.out.println(cookieStore.getCookies());
        System.out.println();
    }
}

