/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.GlobalTokenRevocationClientRequest;
import io.jans.as.client.GlobalTokenRevocationResponse;
import io.jans.as.model.common.SubId;
import io.jans.as.model.revoke.GlobalTokenRevocationRequest;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import org.apache.log4j.Logger;

public class GlobalTokenRevocationClient
extends BaseClient<GlobalTokenRevocationClientRequest, GlobalTokenRevocationResponse> {
    private static final Logger LOG = Logger.getLogger(GlobalTokenRevocationClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public GlobalTokenRevocationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public GlobalTokenRevocationResponse exec(GlobalTokenRevocationClientRequest request) {
        this.setRequest(request);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalTokenRevocationResponse exec() {
        this.initClient();
        Invocation.Builder clientRequest = this.webTarget.request();
        this.applyCookies(clientRequest);
        new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.request);
        clientRequest.header("Content-Type", (Object)((GlobalTokenRevocationClientRequest)this.request).getContentType());
        SubId subId = new SubId();
        subId.setFormat(((GlobalTokenRevocationClientRequest)this.getRequest()).getFormat());
        subId.setId(((GlobalTokenRevocationClientRequest)this.getRequest()).getId());
        GlobalTokenRevocationRequest model = new GlobalTokenRevocationRequest();
        model.setSubId(subId);
        try {
            this.clientResponse = clientRequest.buildPost(Entity.json((Object)MAPPER.writeValueAsString((Object)model))).invoke();
            GlobalTokenRevocationResponse response = new GlobalTokenRevocationResponse(this.clientResponse);
            this.setResponse(response);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (GlobalTokenRevocationResponse)this.getResponse();
    }
}

