/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseResponseWithErrors;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.session.EndSessionErrorResponseType;
import io.jans.model.tokenstatus.StatusList;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.json.JSONObject;

public class StatusListResponse
extends BaseResponseWithErrors<EndSessionErrorResponseType> {
    private String lst;
    private int bits;
    private Jwt jwt;

    public StatusListResponse() {
    }

    public StatusListResponse(Response clientResponse) {
        super(clientResponse);
        this.injectData(clientResponse);
    }

    public StatusList getStatusList() throws IOException {
        return StatusList.fromEncoded((String)this.lst, (int)this.bits);
    }

    @Override
    public EndSessionErrorResponseType fromString(String params) {
        return EndSessionErrorResponseType.fromString((String)params);
    }

    public void injectData(Response clientResponse) {
        this.injectErrorIfExistSilently(this.entity);
        if (this.getErrorType() != null) {
            return;
        }
        if (clientResponse.getStatus() != 200) {
            return;
        }
        String contentType = clientResponse.getHeaderString("Content-Type");
        if ("application/statuslist+jwt".equalsIgnoreCase(contentType)) {
            this.jwt = Jwt.parseSilently((String)this.entity);
            if (this.jwt != null) {
                JSONObject statusList = this.jwt.getClaims().getClaimAsJSON("status_list");
                this.lst = statusList.getString("lst");
                this.bits = statusList.getInt("bits");
            }
        } else if ("application/statuslist+json".equalsIgnoreCase(contentType)) {
            JSONObject json = new JSONObject(this.entity);
            JSONObject statusList = json.getJSONObject("status_list");
            this.lst = statusList.getString("lst");
            this.bits = statusList.getInt("bits");
        } else {
            throw new UnsupportedOperationException("Unable to recognize content-type: " + contentType);
        }
    }

    public String getLst() {
        return this.lst;
    }

    public void setLst(String lst) {
        this.lst = lst;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    @Override
    public String toString() {
        return "StatusListResponse{lst='" + this.lst + "', bits=" + this.bits + ", jwt=" + this.jwt + "} " + super.toString();
    }
}

