/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseResponseWithErrors;
import io.jans.as.model.common.ExchangeTokenType;
import io.jans.as.model.common.TokenType;
import io.jans.as.model.token.TokenErrorResponseType;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenResponse
extends BaseResponseWithErrors<TokenErrorResponseType> {
    private static final Logger LOG = Logger.getLogger(TokenResponse.class);
    private String accessToken;
    private TokenType tokenType;
    private Integer expiresIn;
    private String refreshToken;
    private String scope;
    private String idToken;
    private String deviceToken;
    private ExchangeTokenType issuedTokenType;

    public TokenResponse() {
    }

    public TokenResponse(Response clientResponse) {
        super(clientResponse);
    }

    @Override
    public TokenErrorResponseType fromString(String str) {
        return TokenErrorResponseType.fromString((String)str);
    }

    public void injectDataFromJson() {
        this.injectDataFromJson(this.entity);
    }

    @Override
    public void injectDataFromJson(String json) {
        if (StringUtils.isNotBlank((CharSequence)this.entity)) {
            try {
                JSONObject jsonObj = new JSONObject(this.entity);
                if (jsonObj.has("access_token")) {
                    this.setAccessToken(jsonObj.getString("access_token"));
                }
                if (jsonObj.has("token_type")) {
                    this.setTokenType(TokenType.fromString((String)jsonObj.getString("token_type")));
                }
                if (jsonObj.has("issued_token_type")) {
                    this.setIssuedTokenType(ExchangeTokenType.fromString((String)jsonObj.getString("issued_token_type")));
                }
                if (jsonObj.has("expires_in")) {
                    this.setExpiresIn(jsonObj.getInt("expires_in"));
                }
                if (jsonObj.has("refresh_token")) {
                    this.setRefreshToken(jsonObj.getString("refresh_token"));
                }
                if (jsonObj.has("scope")) {
                    this.setScope(jsonObj.getString("scope"));
                }
                if (jsonObj.has("id_token")) {
                    this.setIdToken(jsonObj.getString("id_token"));
                }
                this.setDeviceToken(jsonObj.optString("device_token"));
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public ExchangeTokenType getIssuedTokenType() {
        return this.issuedTokenType;
    }

    public void setIssuedTokenType(ExchangeTokenType issuedTokenType) {
        this.issuedTokenType = issuedTokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }
}

