/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.model;

import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwe.JweEncrypterImpl;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtHeader;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.util.Base64Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JwtState {
    private JwtType type = JwtType.JWT;
    private SignatureAlgorithm signatureAlgorithm;
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    private BlockEncryptionAlgorithm blockEncryptionAlgorithm;
    private String keyId;
    private String rfp;
    private String iat;
    private String exp;
    private String iss;
    private String aud;
    private String targetLinkUri;
    private String as;
    private String jti;
    private String atHash;
    private String cHash;
    private JSONObject additionalClaims;
    private final String sharedKey;
    private final AbstractCryptoProvider cryptoProvider;

    public JwtState(SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider) {
        this(signatureAlgorithm, cryptoProvider, null, null, null);
    }

    public JwtState(SignatureAlgorithm signatureAlgorithm, String sharedKey, AbstractCryptoProvider cryptoProvider) {
        this(signatureAlgorithm, cryptoProvider, null, null, sharedKey);
    }

    public JwtState(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, AbstractCryptoProvider cryptoProvider) {
        this(null, cryptoProvider, keyEncryptionAlgorithm, blockEncryptionAlgorithm, null);
    }

    public JwtState(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, String sharedKey) {
        this(null, null, keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedKey);
    }

    private JwtState(SignatureAlgorithm signatureAlgorithm, AbstractCryptoProvider cryptoProvider, KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, String sharedKey) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.cryptoProvider = cryptoProvider;
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
        this.sharedKey = sharedKey;
    }

    public JwtType getType() {
        return this.type;
    }

    public void setType(JwtType type) {
        this.type = type;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public KeyEncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public BlockEncryptionAlgorithm getBlockEncryptionAlgorithm() {
        return this.blockEncryptionAlgorithm;
    }

    public void setBlockEncryptionAlgorithm(BlockEncryptionAlgorithm blockEncryptionAlgorithm) {
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getRfp() {
        return this.rfp;
    }

    public void setRfp(String rfp) {
        this.rfp = rfp;
    }

    public String getIat() {
        return this.iat;
    }

    public void setIat(String iat) {
        this.iat = iat;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public String getIss() {
        return this.iss;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }

    public String getAud() {
        return this.aud;
    }

    public void setAud(String aud) {
        this.aud = aud;
    }

    public String getTargetLinkUri() {
        return this.targetLinkUri;
    }

    public void setTargetLinkUri(String targetLinkUri) {
        this.targetLinkUri = targetLinkUri;
    }

    public String getAs() {
        return this.as;
    }

    public void setAs(String as) {
        this.as = as;
    }

    public String getJti() {
        return this.jti;
    }

    public void setJti(String jti) {
        this.jti = jti;
    }

    public String getAtHash() {
        return this.atHash;
    }

    public void setAtHash(String atHash) {
        this.atHash = atHash;
    }

    public String getcHash() {
        return this.cHash;
    }

    public void setcHash(String cHash) {
        this.cHash = cHash;
    }

    public JSONObject getAdditionalClaims() {
        return this.additionalClaims;
    }

    public void setAdditionalClaims(JSONObject additionalClaims) {
        this.additionalClaims = additionalClaims;
    }

    public String getEncodedJwt(JSONObject jwks) throws Exception {
        Object encodedJwt = null;
        if (this.keyEncryptionAlgorithm != null && this.blockEncryptionAlgorithm != null) {
            JweEncrypterImpl jweEncrypter;
            if (this.cryptoProvider != null && jwks != null) {
                PublicKey publicKey = this.cryptoProvider.getPublicKey(this.keyId, jwks, null);
                jweEncrypter = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, publicKey);
            } else {
                jweEncrypter = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, this.sharedKey.getBytes(StandardCharsets.UTF_8));
            }
            String header = ClientUtil.toPrettyJson(this.headerToJSONObject());
            String encodedHeader = Base64Util.base64urlencode((byte[])header.getBytes(StandardCharsets.UTF_8));
            String claims = ClientUtil.toPrettyJson(this.payloadToJSONObject());
            String encodedClaims = Base64Util.base64urlencode((byte[])claims.getBytes(StandardCharsets.UTF_8));
            Jwe jwe = new Jwe();
            jwe.setHeader(new JwtHeader(encodedHeader));
            jwe.setClaims(new JwtClaims(encodedClaims));
            jweEncrypter.encrypt(jwe);
            encodedJwt = jwe.toString();
        } else {
            JSONObject headerJsonObject = this.headerToJSONObject();
            JSONObject payloadJsonObject = this.payloadToJSONObject();
            String headerString = ClientUtil.toPrettyJson(headerJsonObject);
            String payloadString = ClientUtil.toPrettyJson(payloadJsonObject);
            String encodedHeader = Base64Util.base64urlencode((byte[])headerString.getBytes(StandardCharsets.UTF_8));
            String encodedPayload = Base64Util.base64urlencode((byte[])payloadString.getBytes(StandardCharsets.UTF_8));
            String signingInput = encodedHeader + "." + encodedPayload;
            String encodedSignature = this.cryptoProvider.sign(signingInput, this.keyId, this.sharedKey, this.signatureAlgorithm);
            encodedJwt = encodedHeader + "." + encodedPayload + "." + encodedSignature;
        }
        return encodedJwt;
    }

    public String getEncodedJwt() throws Exception {
        return this.getEncodedJwt(null);
    }

    protected JSONObject headerToJSONObject() throws InvalidJwtException {
        JwtHeader jwtHeader = new JwtHeader();
        jwtHeader.setType(this.type);
        if (this.keyEncryptionAlgorithm != null && this.blockEncryptionAlgorithm != null) {
            jwtHeader.setAlgorithm(this.keyEncryptionAlgorithm);
            jwtHeader.setEncryptionMethod(this.blockEncryptionAlgorithm);
        } else {
            jwtHeader.setAlgorithm(this.signatureAlgorithm);
        }
        jwtHeader.setKeyId(this.keyId);
        return jwtHeader.toJsonObject();
    }

    protected JSONObject payloadToJSONObject() throws JSONException {
        JSONObject obj = new JSONObject();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.rfp)) {
                obj.put("rfp", (Object)this.rfp);
            }
            if (StringUtils.isNotBlank((CharSequence)this.keyId)) {
                obj.put("kid", (Object)this.keyId);
            }
            if (StringUtils.isNotBlank((CharSequence)this.iat)) {
                obj.put("iat", (Object)this.iat);
            }
            if (StringUtils.isNotBlank((CharSequence)this.exp)) {
                obj.put("exp", (Object)this.exp);
            }
            if (StringUtils.isNotBlank((CharSequence)this.iss)) {
                obj.put("iss", (Object)this.iss);
            }
            if (StringUtils.isNotBlank((CharSequence)this.aud)) {
                obj.put("aud", (Object)this.aud);
            }
            if (StringUtils.isNotBlank((CharSequence)this.targetLinkUri)) {
                obj.put("target_link_uri", (Object)URLEncoder.encode(this.targetLinkUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((CharSequence)this.as)) {
                obj.put("as", (Object)this.as);
            }
            if (StringUtils.isNotBlank((CharSequence)this.jti)) {
                obj.put("jti", (Object)this.jti);
            }
            if (StringUtils.isNotBlank((CharSequence)this.atHash)) {
                obj.put("at_hash", (Object)this.atHash);
            }
            if (StringUtils.isNotBlank((CharSequence)this.cHash)) {
                obj.put("c_hash", (Object)this.cHash);
            }
            if (this.additionalClaims != null) {
                obj.put("additional_claims", (Object)this.additionalClaims);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

