/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service.common;

import io.jans.as.common.model.common.User;
import io.jans.as.common.service.common.InumService;
import io.jans.as.common.service.common.TestUserService;
import io.jans.model.GluuStatus;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import io.jans.service.DataSourceTypeService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.testng.MockitoTestNGListener;
import org.slf4j.Logger;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={MockitoTestNGListener.class})
public class UserServiceTest {
    @InjectMocks
    protected TestUserService userService;
    @Mock
    protected PersistenceEntryManager persistenceEntryManager;
    @Mock
    protected DataSourceTypeService dataSourceTypeService;
    @Mock
    private Logger log;
    @Mock
    private InumService inumService;

    @Test
    private void getUserByDn_nullDn_null() {
        User user = this.userService.getUserByDn(null, null);
        Assert.assertNull((Object)user);
    }

    @Test
    private void getUserByDn_emptyDn_null() {
        User user = this.userService.getUserByDn("", null);
        Assert.assertNull((Object)user);
    }

    @Test
    private void getUserByDn_validDnWithAttributes_user() {
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)new User());
        User user = this.userService.getUserByDn("123", null);
        Assert.assertNotNull((Object)user);
    }

    @Test
    private void getUserByInum_nullInum_null() {
        User user = this.userService.getUserByInum(null, null);
        Assert.assertNull((Object)user);
    }

    @Test
    private void getUserByInum_emptyInum_null() {
        User user = this.userService.getUserByInum("", null);
        Assert.assertNull((Object)user);
    }

    @Test
    private void getUserByInum_validDnWithAttributes_user() {
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)new User());
        User user = this.userService.getUserByInum("123", null);
        Assert.assertNotNull((Object)user);
    }

    @Test
    private void getUser_nullUserId_user() {
        User user = this.userService.getUser(null, null);
        Assert.assertNull((Object)user);
    }

    @Test
    private void getUser_isSpannerPeopleBaseDn_user() {
        String userId = "123";
        String baseDn = "dn123";
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User user = this.userService.getUser(userId, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((String)user.getUserId(), (String)userId);
        Assert.assertEquals((String)user.getBaseDn(), (String)baseDn);
    }

    @Test
    private void getUser_noSpannerPeopleBaseDn_user() {
        String userId = "123";
        String baseDn = "dn123";
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User user = this.userService.getUser(userId, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((String)user.getUserId(), (String)userId);
        Assert.assertEquals((String)user.getBaseDn(), (String)baseDn);
    }

    @Test
    private void getUser_findEmpty_null() {
        String userId = "123";
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(new ArrayList());
        User user = this.userService.getUser(userId, null);
        Assert.assertNull((Object)user);
    }

    @Test
    private void getUserInum_userNull_null() {
        User user = null;
        String inum = this.userService.getUserInum(user);
        Assert.assertNull((Object)inum);
    }

    @Test
    private void getUserInum_userNoInum_null() {
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        Mockito.when((Object)user.getAttribute("inum")).thenReturn(null);
        String inum = this.userService.getUserInum(user);
        Assert.assertNull((Object)inum);
    }

    @Test
    private void getUserInum_userWithInum_inum() {
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        Mockito.when((Object)user.getAttribute("inum")).thenReturn((Object)"inumExample");
        String inum = this.userService.getUserInum(user);
        Assert.assertNotNull((Object)inum);
        Assert.assertEquals((String)inum, (String)"inumExample");
    }

    @Test
    private void getUserInum_userId_inum() {
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        Mockito.when((Object)user.getAttribute("inum")).thenReturn((Object)"inumExample");
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(user));
        String inum = this.userService.getUserInum("123");
        Assert.assertNotNull((Object)inum);
        Assert.assertEquals((String)inum, (String)"inumExample");
    }

    @Test
    private void updateUser_nullUser_nullPointerException() {
        try {
            this.userService.updateUser(null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    private void updateUser_validUser_user() {
        User user = this.getBasicUser("123", "dn123");
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).merge((Object)user);
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)user);
        User resultUser = this.userService.updateUser(user);
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getUserId());
        Assert.assertTrue((boolean)resultUser.getUserId().equals(user.getUserId()));
    }

    @Test
    private void addDefaultUser_withUidEmptyPersonCustomObject_user() {
        String uid = UUID.randomUUID().toString();
        User user = this.getBasicUser(uid, "dn123");
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).persist(ArgumentMatchers.any());
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(user));
        Mockito.when((Object)this.inumService.generatePeopleInum()).thenReturn((Object)uid);
        this.userService.setReturnTestListPersonCustomObjectClassList(false);
        User resultUser = this.userService.addDefaultUser(uid);
        Assert.assertNotNull((Object)resultUser);
        Assert.assertNotNull((Object)resultUser.getUserId());
        Assert.assertEquals((String)resultUser.getUserId(), (String)uid);
    }

    @Test
    private void addDefaultUser_withUidNoEmptyPersonCustomObject_user() {
        String uid = UUID.randomUUID().toString();
        User user = this.getBasicUser(uid, "dn123");
        user.setCustomObjectClasses(TestUserService.DEFAULT_PERSON_CUSTOM_OBJECT_CLASS_LIST);
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).persist(ArgumentMatchers.any());
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(user));
        Mockito.when((Object)this.inumService.generatePeopleInum()).thenReturn((Object)uid);
        this.userService.setReturnTestListPersonCustomObjectClassList(true);
        User resultUser = this.userService.addDefaultUser(uid);
        Assert.assertNotNull((Object)resultUser);
        Assert.assertNotNull((Object)resultUser.getUserId());
        Assert.assertEquals((String)resultUser.getUserId(), (String)uid);
        Assert.assertTrue((resultUser.getCustomObjectClasses().length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)resultUser.getCustomObjectClasses()[0].equals(user.getCustomObjectClasses()[0]));
    }

    @Test
    private void addUser_noEmptyPersonCustomObject_user() {
        User user = this.getBasicUser("123", "dn123");
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).persist(ArgumentMatchers.any());
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)user);
        Mockito.when((Object)this.inumService.generatePeopleInum()).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)this.dataSourceTypeService.isLDAP(ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.userService.setReturnTestListPersonCustomObjectClassList(true);
        User resultUser = this.userService.addUser(user, true);
        Assert.assertNotNull((Object)resultUser);
        Assert.assertNotNull((Object)resultUser.getUserId());
        Assert.assertNotNull((Object)user.getStatus());
        Assert.assertNotNull((Object)user.getAttribute("inum"));
        Assert.assertEquals((Object)user.getStatus(), (Object)GluuStatus.ACTIVE);
        Assert.assertEquals((int)resultUser.getCustomObjectClasses().length, (int)2);
        Assert.assertEquals((String)user.getCustomObjectClasses()[0], (String)resultUser.getCustomObjectClasses()[0]);
    }

    @Test
    private void getUserByAttribute_attributeNameNull_nulll() {
        User resultUser = this.userService.getUserByAttribute(null, null);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void getUserByAttribute_attributeValueNull_nulll() {
        User resultUser = this.userService.getUserByAttribute("attr1", null);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void getUserByAttribute_validAttributeValueAttributeName_user() {
        String userId = "123";
        String baseDn = "baseDn";
        String attributeName = "attribute1";
        String attributeValue = "value1";
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), Mockito.anyInt())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User resultUser = this.userService.getUserByAttribute(attributeName, attributeValue);
        Assert.assertNotNull((Object)resultUser);
    }

    @Test
    private void getUniqueUserByAttributes_attributeNamesNull_null() {
        User resultUser = this.userService.getUniqueUserByAttributes(null, null);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void getUniqueUserByAttributes_attributeNamesEmpty_null() {
        ArrayList lisAttributes = new ArrayList();
        User resultUser = this.userService.getUniqueUserByAttributes(lisAttributes, null);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void getUniqueUserByAttributes_attributeNamesSizeOne_null() {
        String userId = "123";
        String baseDn = "baseDn";
        String attributeName = "attribute1";
        String attributeValue = "value1";
        ArrayList<String> lisAttributes = new ArrayList<String>();
        lisAttributes.add(attributeName);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User resultUser = this.userService.getUniqueUserByAttributes(lisAttributes, attributeValue);
        Assert.assertNotNull((Object)resultUser);
    }

    @Test
    private void getUniqueUserByAttributes_exceptionFindEntriesNull_null() {
        String attributeName = "attribute1";
        String attributeValue = "value1";
        ArrayList<String> lisAttributes = new ArrayList<String>();
        lisAttributes.add(attributeName);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.any())).thenReturn(null);
        User resultUser = this.userService.getUniqueUserByAttributes(lisAttributes, attributeValue);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void getUsersByAttribute_multiValuedTrue_null() {
        String userId = "123";
        String baseDn = "baseDn";
        String attributeName = "attribute1";
        String attributeValue = "value1";
        ArrayList<String> lisAttributes = new ArrayList<String>();
        lisAttributes.add(attributeName);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), Mockito.anyInt())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        List resultListUser = this.userService.getUsersByAttribute(attributeName, attributeValue, true, 1);
        Assert.assertNotNull((Object)resultListUser);
        Assert.assertTrue((resultListUser.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    private void getUserByAttributes_attributeNamesEmpty_null() {
        String[] attributeNames = new String[]{};
        User resultUser = this.userService.getUserByAttributes(null, attributeNames, null);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void getUserByAttributes_validAttributeNamesSize1IsSpanner_user() {
        String userId = "123";
        String baseDn = "baseDn";
        String[] attributeNames = new String[]{"attribute1"};
        String attributeValue = "value1";
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any(), Mockito.anyInt())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User resultUser = this.userService.getUserByAttributes(attributeValue, attributeNames, true, null);
        Assert.assertNotNull((Object)resultUser);
    }

    @Test
    private void getUserByAttributes_validAttributeNamesSize2NoIsSpanner_user() {
        String userId = "123";
        String baseDn = "baseDn";
        String[] attributeNames = new String[]{"attribute1", "attribute2"};
        String attributeValue = "value1";
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any(), Mockito.anyInt())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User resultUser = this.userService.getUserByAttributes(attributeValue, attributeNames, true, null);
        Assert.assertNotNull((Object)resultUser);
    }

    @Test
    private void getUserByAttributes_nullAttributes_null() {
        User resultUser = this.userService.getUserByAttributes(null, true, null);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void getUserByAttributes_oneAttributes_user() {
        String userId = "123";
        String baseDn = "baseDn";
        ArrayList<CustomAttribute> attributes = new ArrayList<CustomAttribute>();
        CustomAttribute customAttribute1 = new CustomAttribute("attribute1", "value1");
        attributes.add(customAttribute1);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any(), Mockito.anyInt())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User resultUser = this.userService.getUserByAttributes(attributes, true, null);
        Assert.assertNotNull((Object)resultUser);
    }

    @Test
    private void getUserByAttributes_twoAttributes_user() {
        String userId = "123";
        String baseDn = "baseDn";
        ArrayList<CustomAttribute> attributes = new ArrayList<CustomAttribute>();
        CustomAttribute customAttribute1 = new CustomAttribute("attribute1", "value1");
        CustomAttribute customAttribute2 = new CustomAttribute("attribute2", "value2");
        attributes.add(customAttribute1);
        attributes.add(customAttribute2);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any(), Mockito.anyInt())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User resultUser = this.userService.getUserByAttributes(attributes, true, null);
        Assert.assertNotNull((Object)resultUser);
    }

    @Test
    private void getUsersBySample_user_listUser() {
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        int limit = 1;
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.any(), Mockito.anyInt())).thenReturn(this.getListBasicOneUser(user));
        List listResultUser = this.userService.getUsersBySample(user, limit);
        Assert.assertNotNull((Object)listResultUser);
        Assert.assertTrue((listResultUser.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    private void addUserAttributeByUserInum_inumNull_null() {
        User resultUser = this.userService.addUserAttributeByUserInum(null, null, null);
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void addUserAttributeByUserInum_newAttribute_user() {
        String inumUser = "inumUser";
        String attributeName = "attribute1";
        String attributeValue = "value1";
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setCustomAttributes(new ArrayList());
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)user);
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).merge((Object)user);
        User resultUser = this.userService.addUserAttributeByUserInum(inumUser, attributeName, attributeValue);
        Assert.assertNotNull((Object)resultUser);
        Assert.assertTrue((resultUser.getCustomAttributes().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getName(), (String)attributeName);
        Assert.assertEquals((Object)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getValue(), (Object)attributeValue);
    }

    @Test
    private void addUserAttributeByUserInum_existentAttributeNoValue_user() {
        String inumUser = "inumUser";
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setDn("dn123");
        CustomObjectAttribute customAttribute1 = new CustomObjectAttribute("attribute1", (Object)"value1");
        CustomObjectAttribute customAttribute2 = new CustomObjectAttribute("attribute2", (Object)"value2");
        user.setCustomAttributes(new ArrayList());
        user.getCustomAttributes().add(customAttribute1);
        user.getCustomAttributes().add(customAttribute2);
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)user);
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).merge((Object)user);
        User resultUser = this.userService.addUserAttributeByUserInum(inumUser, "attribute2", "value3");
        Assert.assertNotNull((Object)resultUser);
        Assert.assertTrue((resultUser.getCustomAttributes().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getName(), (String)"attribute1");
        Assert.assertEquals((Object)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getValue(), (Object)"value1");
        Assert.assertEquals((String)((CustomObjectAttribute)resultUser.getCustomAttributes().get(1)).getName(), (String)"attribute2");
        Assert.assertTrue((((CustomObjectAttribute)resultUser.getCustomAttributes().get(1)).getValues().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals(((CustomObjectAttribute)resultUser.getCustomAttributes().get(1)).getValues().get(0), (Object)"value2");
        Assert.assertEquals(((CustomObjectAttribute)resultUser.getCustomAttributes().get(1)).getValues().get(1), (Object)"value3");
    }

    @Test
    private void addUserAttributeByUserInum_existentAttributeExistentValue_user() {
        String inumUser = "inumUser";
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setDn("dn123");
        CustomObjectAttribute customAttribute1 = new CustomObjectAttribute("attribute1", (Object)"value1");
        CustomObjectAttribute customAttribute2 = new CustomObjectAttribute("attribute2", (Object)"value2");
        user.setCustomAttributes(new ArrayList());
        user.getCustomAttributes().add(customAttribute1);
        user.getCustomAttributes().add(customAttribute2);
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)user);
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).merge((Object)user);
        User resultUser = this.userService.addUserAttributeByUserInum(inumUser, "attribute2", "value2");
        Assert.assertNotNull((Object)resultUser);
        Assert.assertTrue((resultUser.getCustomAttributes().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getName(), (String)"attribute1");
        Assert.assertEquals((Object)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getValue(), (Object)"value1");
        Assert.assertEquals((String)((CustomObjectAttribute)resultUser.getCustomAttributes().get(1)).getName(), (String)"attribute2");
        Assert.assertEquals((Object)((CustomObjectAttribute)resultUser.getCustomAttributes().get(1)).getValue(), (Object)"value2");
        Assert.assertTrue((((CustomObjectAttribute)resultUser.getCustomAttributes().get(1)).getValues().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    private void addUserAttribute_newAttribute_user() {
        String attributeName = "attribute1";
        String attributeValue = "value1";
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setCustomAttributes(new ArrayList());
        Boolean result = this.userService.addUserAttribute(user, attributeName, attributeValue, null);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((user.getCustomAttributes().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)((CustomObjectAttribute)user.getCustomAttributes().get(0)).getName(), (String)attributeName);
        Assert.assertEquals((Object)((CustomObjectAttribute)user.getCustomAttributes().get(0)).getValue(), (Object)attributeValue);
    }

    @Test
    private void removeUserAttribute_noExistentAttribute_null() {
        String userId = "123";
        String baseDn = "dn123";
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        CustomObjectAttribute customAttribute1 = new CustomObjectAttribute("attribute1", (Object)"value1");
        user.setCustomAttributes(new ArrayList());
        user.getCustomAttributes().add(customAttribute1);
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        User resultUser = this.userService.removeUserAttributeValue(userId, "attribute2", "value2");
        Assert.assertNull((Object)resultUser);
    }

    @Test
    private void removeUserAttribute_existentAttribute_user() {
        String userId = "123";
        String baseDn = "dn123";
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setDn(baseDn);
        CustomObjectAttribute customAttribute1 = new CustomObjectAttribute("attribute1", (Object)"value1");
        CustomObjectAttribute customAttribute2 = new CustomObjectAttribute("attribute2", (Object)"value2");
        user.setCustomAttributes(new ArrayList());
        user.getCustomAttributes().add(customAttribute1);
        user.getCustomAttributes().add(customAttribute2);
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(user));
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)user);
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).merge(ArgumentMatchers.any());
        User resultUser = this.userService.removeUserAttributeValue(userId, "attribute1", "value1");
        Assert.assertNotNull((Object)resultUser);
        Assert.assertTrue((boolean)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getValues().isEmpty());
    }

    @Test
    private void replaceUserAttribute_existentAttribute_user() {
        String userId = "123";
        String baseDn = "dn123";
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setDn(baseDn);
        CustomObjectAttribute customAttribute1 = new CustomObjectAttribute("attribute1", (Object)"value1");
        CustomObjectAttribute customAttribute2 = new CustomObjectAttribute("attribute2", (Object)"value2");
        user.setCustomAttributes(new ArrayList());
        user.getCustomAttributes().add(customAttribute1);
        user.getCustomAttributes().add(customAttribute2);
        Mockito.when((Object)this.dataSourceTypeService.isSpanner(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(user));
        Mockito.when((Object)this.persistenceEntryManager.find((Object)ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (String[])ArgumentMatchers.any())).thenReturn((Object)user);
        ((PersistenceEntryManager)Mockito.doNothing().when((Object)this.persistenceEntryManager)).merge(ArgumentMatchers.any());
        User resultUser = this.userService.replaceUserAttribute(userId, "attribute1", "value1", "newValue1");
        Assert.assertNotNull((Object)resultUser);
        Assert.assertEquals((Object)((CustomObjectAttribute)resultUser.getCustomAttributes().get(0)).getValue(), (Object)"newValue1");
    }

    @Test
    private void getCustomAttribute_noExistentAttribute_null() {
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setCustomAttributes(new ArrayList());
        CustomObjectAttribute resultAttribute = this.userService.getCustomAttribute(user, "attribute1");
        Assert.assertNull((Object)resultAttribute);
    }

    @Test
    private void getCustomAttribute_existentAttribute_user() {
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        CustomObjectAttribute customAttribute1 = new CustomObjectAttribute("attribute1", (Object)"value1");
        CustomObjectAttribute customAttribute2 = new CustomObjectAttribute("attribute2", (Object)"value2");
        user.setCustomAttributes(new ArrayList());
        user.getCustomAttributes().add(customAttribute1);
        user.getCustomAttributes().add(customAttribute2);
        CustomObjectAttribute resultAttribute = this.userService.getCustomAttribute(user, "attribute1");
        Assert.assertNotNull((Object)resultAttribute);
        Assert.assertEquals((String)resultAttribute.getName(), (String)"attribute1");
        Assert.assertEquals((Object)resultAttribute.getValue(), (Object)"value1");
    }

    @Test
    private void setCustomAttribute_noExistentAttribute_user() {
        User user = (User)Mockito.spy((Object)this.getBasicUser("123", "dn123"));
        user.setCustomAttributes(new ArrayList());
        this.userService.setCustomAttribute(user, "attribute1", "value1");
        Assert.assertTrue((user.getCustomAttributes().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)((CustomObjectAttribute)user.getCustomAttributes().get(0)).getName(), (String)"attribute1");
        Assert.assertEquals((Object)((CustomObjectAttribute)user.getCustomAttributes().get(0)).getValue(), (Object)"value1");
    }

    @Test
    private void getUsersWithPersistentJwts_noParams_listUsers() {
        String userId = "123";
        String baseDn = "dn123";
        Mockito.when((Object)this.persistenceEntryManager.findEntries(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any(), (Filter)ArgumentMatchers.any())).thenReturn(this.getListBasicOneUser(userId, baseDn));
        List list = this.userService.getUsersWithPersistentJwts();
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    private void getDnForUser_emptyInum_dnForUser() {
        String inum = "";
        String result = this.userService.getDnForUser(inum);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"baseDnTest");
    }

    @Test
    private void getDnForUser_validInum_dnForUser() {
        String inum = "inumTest";
        String result = this.userService.getDnForUser(inum);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"inum=inumTest,baseDnTest");
    }

    @Test
    private void getUserInumByDn_emptyDn_null() {
        String dn = "";
        String result = this.userService.getUserInumByDn(dn);
        Assert.assertNull((Object)result);
    }

    @Test
    private void getUserInumByDn_dnNotEndsWithPeopleBaseDn_null() {
        String dn = "123OtherDnTest";
        String result = this.userService.getUserInumByDn(dn);
        Assert.assertNull((Object)result);
    }

    private void getUserInumByDn_validDn_inum() {
        String inum = "inumTest1";
        String peopleBaseDn = this.userService.getPeopleBaseDn();
        String dn = "inum=" + inum + "," + peopleBaseDn;
        String result = this.userService.getUserInumByDn(dn);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"inumTest1");
    }

    private <T> List<T> getListBasicOneUser(User user) {
        ArrayList<User> list = new ArrayList<User>();
        list.add(user);
        return list;
    }

    private <T> List<T> getListBasicOneUser(String userId, String baseDn) {
        ArrayList<User> list = new ArrayList<User>();
        list.add(this.getBasicUser(userId, baseDn));
        return list;
    }

    private User getBasicUser(String uerId, String baseDn) {
        User user1 = new User();
        user1.setUserId(uerId);
        user1.setCreatedAt(new Date());
        user1.setBaseDn(baseDn);
        return user1;
    }
}

